/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import com.sun.beans.ObjectHandler;
import java.beans.ExceptionListener;
import java.beans.Statement;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.HandlerBase;
import org.xml.sax.SAXException;

public class XMLDecoder {
    private InputStream in;
    private Object owner;
    private ExceptionListener exceptionListener;
    private ObjectHandler handler;
    private Reference clref;

    public XMLDecoder(InputStream in) {
        this(in, null);
    }

    public XMLDecoder(InputStream in, Object owner) {
        this(in, owner, null);
    }

    public XMLDecoder(InputStream in, Object owner, ExceptionListener exceptionListener) {
        this(in, owner, exceptionListener, null);
    }

    public XMLDecoder(InputStream in, Object owner, ExceptionListener exceptionListener, ClassLoader cl) {
        this.in = in;
        this.setOwner(owner);
        this.setExceptionListener(exceptionListener);
        this.setClassLoader(cl);
    }

    private void setClassLoader(ClassLoader cl) {
        if (cl != null) {
            this.clref = new WeakReference<ClassLoader>(cl);
        }
    }

    private ClassLoader getClassLoader() {
        if (this.clref != null) {
            return (ClassLoader)this.clref.get();
        }
        return null;
    }

    public void close() {
        if (this.in != null) {
            this.getHandler();
            try {
                this.in.close();
            }
            catch (IOException e) {
                this.getExceptionListener().exceptionThrown(e);
            }
        }
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener != null ? this.exceptionListener : Statement.defaultExceptionListener;
    }

    public Object readObject() {
        if (this.in == null) {
            return null;
        }
        return this.getHandler().dequeueResult();
    }

    public void setOwner(Object owner) {
        this.owner = owner;
    }

    public Object getOwner() {
        return this.owner;
    }

    private ObjectHandler getHandler() {
        if (this.handler == null) {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            try {
                SAXParser parser = factory.newSAXParser();
                this.handler = new ObjectHandler(this, this.getClassLoader());
                parser.parse(this.in, (HandlerBase)this.handler);
            }
            catch (ParserConfigurationException e) {
                this.getExceptionListener().exceptionThrown(e);
            }
            catch (SAXException se) {
                Exception e = se.getException();
                if (e == null) {
                    e = se;
                }
                this.getExceptionListener().exceptionThrown(e);
            }
            catch (IOException ioe) {
                this.getExceptionListener().exceptionThrown(ioe);
            }
        }
        return this.handler;
    }
}

