/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Byte
extends Number
implements Comparable<Byte> {
    public static final byte MIN_VALUE = -128;
    public static final byte MAX_VALUE = 127;
    public static final Class<Byte> TYPE = Class.getPrimitiveClass("byte");
    private final byte value;
    public static final int SIZE = 8;
    private static final long serialVersionUID = -7183698231559129828L;

    public static String toString(byte b) {
        return Integer.toString(b, 10);
    }

    public static Byte valueOf(byte b) {
        int offset = 128;
        return ByteCache.cache[b + 128];
    }

    public static byte parseByte(String s, int radix) throws NumberFormatException {
        int i = Integer.parseInt(s, radix);
        if (i < -128 || i > 127) {
            throw new NumberFormatException("Value out of range. Value:\"" + s + "\" Radix:" + radix);
        }
        return (byte)i;
    }

    public static byte parseByte(String s) throws NumberFormatException {
        return Byte.parseByte(s, 10);
    }

    public static Byte valueOf(String s, int radix) throws NumberFormatException {
        return new Byte(Byte.parseByte(s, radix));
    }

    public static Byte valueOf(String s) throws NumberFormatException {
        return Byte.valueOf(s, 10);
    }

    public static Byte decode(String nm) throws NumberFormatException {
        int i = Integer.decode(nm);
        if (i < -128 || i > 127) {
            throw new NumberFormatException("Value " + i + " out of range from input " + nm);
        }
        return (byte)i;
    }

    public Byte(byte value) {
        this.value = value;
    }

    public Byte(String s) throws NumberFormatException {
        this.value = Byte.parseByte(s, 10);
    }

    @Override
    public byte byteValue() {
        return this.value;
    }

    @Override
    public short shortValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Byte) {
            return this.value == (Byte)obj;
        }
        return false;
    }

    @Override
    public int compareTo(Byte anotherByte) {
        return this.value - anotherByte.value;
    }

    private static class ByteCache {
        static final Byte[] cache = new Byte[256];

        private ByteCache() {
        }

        static {
            for (int i = 0; i < cache.length; ++i) {
                ByteCache.cache[i] = new Byte((byte)(i - 128));
            }
        }
    }
}

