/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.ArrayList;

class Shutdown {
    private static final int RUNNING = 0;
    private static final int HOOKS = 1;
    private static final int FINALIZERS = 2;
    private static int state = 0;
    private static boolean runFinalizersOnExit = false;
    private static ArrayList<Runnable> hooks = new ArrayList();
    private static Object lock = new Lock();
    private static Object haltLock = new Lock();

    Shutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setRunFinalizersOnExit(boolean run) {
        Object object = lock;
        synchronized (object) {
            runFinalizersOnExit = run;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void add(Runnable hook) {
        Object object = lock;
        synchronized (object) {
            if (state > 0) {
                throw new IllegalStateException("Shutdown in progress");
            }
            hooks.add(hook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean remove(Runnable hook) {
        Object object = lock;
        synchronized (object) {
            if (state > 0) {
                throw new IllegalStateException("Shutdown in progress");
            }
            if (hook == null) {
                throw new NullPointerException();
            }
            if (hooks == null) {
                return false;
            }
            return hooks.remove(hook);
        }
    }

    private static void runHooks() {
        for (Runnable hook : hooks) {
            try {
                hook.run();
            }
            catch (Throwable t) {
                if (!(t instanceof ThreadDeath)) continue;
                ThreadDeath td = (ThreadDeath)t;
                throw td;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void halt(int status) {
        Object object = haltLock;
        synchronized (object) {
            Shutdown.halt0(status);
        }
    }

    static native void halt0(int var0);

    private static native void runAllFinalizers();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sequence() {
        boolean rfoe;
        Object object = lock;
        synchronized (object) {
            if (state != 1) {
                return;
            }
        }
        Shutdown.runHooks();
        Object object2 = lock;
        synchronized (object2) {
            state = 2;
            rfoe = runFinalizersOnExit;
        }
        if (rfoe) {
            Shutdown.runAllFinalizers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void exit(int status) {
        boolean runMoreFinalizers = false;
        Class<Shutdown> clazz = lock;
        synchronized (clazz) {
            if (status != 0) {
                runFinalizersOnExit = false;
            }
            switch (state) {
                case 0: {
                    state = 1;
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    if (status != 0) {
                        Shutdown.halt(status);
                        break;
                    }
                    runMoreFinalizers = runFinalizersOnExit;
                }
            }
        }
        if (runMoreFinalizers) {
            Shutdown.runAllFinalizers();
            Shutdown.halt(status);
        }
        clazz = Shutdown.class;
        synchronized (Shutdown.class) {
            Shutdown.sequence();
            Shutdown.halt(status);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void shutdown() {
        Class<Shutdown> clazz = lock;
        synchronized (clazz) {
            switch (state) {
                case 0: {
                    state = 1;
                    break;
                }
            }
        }
        clazz = Shutdown.class;
        synchronized (Shutdown.class) {
            Shutdown.sequence();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static class Lock {
        private Lock() {
        }
    }
}

