/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;

public class Throwable
implements Serializable {
    private static final long serialVersionUID = -3042686055658047285L;
    private transient Object backtrace;
    private String detailMessage;
    private Throwable cause = this;
    private StackTraceElement[] stackTrace;

    public Throwable() {
        this.fillInStackTrace();
    }

    public Throwable(String message) {
        this.fillInStackTrace();
        this.detailMessage = message;
    }

    public Throwable(String message, Throwable cause) {
        this.fillInStackTrace();
        this.detailMessage = message;
        this.cause = cause;
    }

    public Throwable(Throwable cause) {
        this.fillInStackTrace();
        this.detailMessage = cause == null ? null : cause.toString();
        this.cause = cause;
    }

    public String getMessage() {
        return this.detailMessage;
    }

    public String getLocalizedMessage() {
        return this.getMessage();
    }

    public Throwable getCause() {
        return this.cause == this ? null : this.cause;
    }

    public synchronized Throwable initCause(Throwable cause) {
        if (this.cause != this) {
            throw new IllegalStateException("Can't overwrite cause");
        }
        if (cause == this) {
            throw new IllegalArgumentException("Self-causation not permitted");
        }
        this.cause = cause;
        return this;
    }

    public String toString() {
        String s = this.getClass().getName();
        String message = this.getLocalizedMessage();
        return message != null ? s + ": " + message : s;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream s) {
        PrintStream printStream = s;
        synchronized (printStream) {
            s.println(this);
            StackTraceElement[] trace = this.getOurStackTrace();
            for (int i = 0; i < trace.length; ++i) {
                s.println("\tat " + trace[i]);
            }
            Throwable ourCause = this.getCause();
            if (ourCause != null) {
                ourCause.printStackTraceAsCause(s, trace);
            }
        }
    }

    private void printStackTraceAsCause(PrintStream s, StackTraceElement[] causedTrace) {
        Throwable ourCause;
        StackTraceElement[] trace = this.getOurStackTrace();
        int m = trace.length - 1;
        for (int n = causedTrace.length - 1; m >= 0 && n >= 0 && trace[m].equals(causedTrace[n]); --m, --n) {
        }
        int framesInCommon = trace.length - 1 - m;
        s.println("Caused by: " + this);
        for (int i = 0; i <= m; ++i) {
            s.println("\tat " + trace[i]);
        }
        if (framesInCommon != 0) {
            s.println("\t... " + framesInCommon + " more");
        }
        if ((ourCause = this.getCause()) != null) {
            ourCause.printStackTraceAsCause(s, trace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter s) {
        PrintWriter printWriter = s;
        synchronized (printWriter) {
            s.println(this);
            StackTraceElement[] trace = this.getOurStackTrace();
            for (int i = 0; i < trace.length; ++i) {
                s.println("\tat " + trace[i]);
            }
            Throwable ourCause = this.getCause();
            if (ourCause != null) {
                ourCause.printStackTraceAsCause(s, trace);
            }
        }
    }

    private void printStackTraceAsCause(PrintWriter s, StackTraceElement[] causedTrace) {
        Throwable ourCause;
        StackTraceElement[] trace = this.getOurStackTrace();
        int m = trace.length - 1;
        for (int n = causedTrace.length - 1; m >= 0 && n >= 0 && trace[m].equals(causedTrace[n]); --m, --n) {
        }
        int framesInCommon = trace.length - 1 - m;
        s.println("Caused by: " + this);
        for (int i = 0; i <= m; ++i) {
            s.println("\tat " + trace[i]);
        }
        if (framesInCommon != 0) {
            s.println("\t... " + framesInCommon + " more");
        }
        if ((ourCause = this.getCause()) != null) {
            ourCause.printStackTraceAsCause(s, trace);
        }
    }

    public synchronized native Throwable fillInStackTrace();

    public StackTraceElement[] getStackTrace() {
        return (StackTraceElement[])this.getOurStackTrace().clone();
    }

    private synchronized StackTraceElement[] getOurStackTrace() {
        if (this.stackTrace == null) {
            int depth = this.getStackTraceDepth();
            this.stackTrace = new StackTraceElement[depth];
            for (int i = 0; i < depth; ++i) {
                this.stackTrace[i] = this.getStackTraceElement(i);
            }
        }
        return this.stackTrace;
    }

    public void setStackTrace(StackTraceElement[] stackTrace) {
        StackTraceElement[] defensiveCopy = (StackTraceElement[])stackTrace.clone();
        for (int i = 0; i < defensiveCopy.length; ++i) {
            if (defensiveCopy[i] != null) continue;
            throw new NullPointerException("stackTrace[" + i + "]");
        }
        this.stackTrace = defensiveCopy;
    }

    private native int getStackTraceDepth();

    private native StackTraceElement getStackTraceElement(int var1);

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        this.getOurStackTrace();
        s.defaultWriteObject();
    }
}

