/*
 * Decompiled with CFR 0.152.
 */
package java.lang.management;

import java.io.IOException;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import javax.management.InstanceNotFoundException;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerPermission;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagementFactory {
    public static final String CLASS_LOADING_MXBEAN_NAME = "java.lang:type=ClassLoading";
    public static final String COMPILATION_MXBEAN_NAME = "java.lang:type=Compilation";
    public static final String MEMORY_MXBEAN_NAME = "java.lang:type=Memory";
    public static final String OPERATING_SYSTEM_MXBEAN_NAME = "java.lang:type=OperatingSystem";
    public static final String RUNTIME_MXBEAN_NAME = "java.lang:type=Runtime";
    public static final String THREAD_MXBEAN_NAME = "java.lang:type=Threading";
    public static final String GARBAGE_COLLECTOR_MXBEAN_DOMAIN_TYPE = "java.lang:type=GarbageCollector";
    public static final String MEMORY_MANAGER_MXBEAN_DOMAIN_TYPE = "java.lang:type=MemoryManager";
    public static final String MEMORY_POOL_MXBEAN_DOMAIN_TYPE = "java.lang:type=MemoryPool";
    private static MBeanServer platformMBeanServer;
    private static final String NOTIF_EMITTER = "javax.management.NotificationEmitter";

    private ManagementFactory() {
    }

    public static ClassLoadingMXBean getClassLoadingMXBean() {
        return sun.management.ManagementFactory.getClassLoadingMXBean();
    }

    public static MemoryMXBean getMemoryMXBean() {
        return sun.management.ManagementFactory.getMemoryMXBean();
    }

    public static ThreadMXBean getThreadMXBean() {
        return sun.management.ManagementFactory.getThreadMXBean();
    }

    public static RuntimeMXBean getRuntimeMXBean() {
        return sun.management.ManagementFactory.getRuntimeMXBean();
    }

    public static CompilationMXBean getCompilationMXBean() {
        return sun.management.ManagementFactory.getCompilationMXBean();
    }

    public static OperatingSystemMXBean getOperatingSystemMXBean() {
        return sun.management.ManagementFactory.getOperatingSystemMXBean();
    }

    public static List<MemoryPoolMXBean> getMemoryPoolMXBeans() {
        return sun.management.ManagementFactory.getMemoryPoolMXBeans();
    }

    public static List<MemoryManagerMXBean> getMemoryManagerMXBeans() {
        return sun.management.ManagementFactory.getMemoryManagerMXBeans();
    }

    public static List<GarbageCollectorMXBean> getGarbageCollectorMXBeans() {
        return sun.management.ManagementFactory.getGarbageCollectorMXBeans();
    }

    public static synchronized MBeanServer getPlatformMBeanServer() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            MBeanServerPermission perm = new MBeanServerPermission("createMBeanServer");
            sm.checkPermission(perm);
        }
        if (platformMBeanServer == null) {
            platformMBeanServer = sun.management.ManagementFactory.createPlatformMBeanServer();
        }
        return platformMBeanServer;
    }

    public static <T> T newPlatformMXBeanProxy(MBeanServerConnection connection, String mxbeanName, Class<T> mxbeanInterface) throws IOException {
        final Class<T> interfaceClass = mxbeanInterface;
        ClassLoader loader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return interfaceClass.getClassLoader();
            }
        });
        if (loader != null) {
            throw new IllegalArgumentException(mxbeanName + " is not a platform MXBean");
        }
        try {
            ObjectName objName = new ObjectName(mxbeanName);
            if (!connection.isInstanceOf(objName, interfaceClass.getName())) {
                throw new IllegalArgumentException(mxbeanName + " is not an instance of " + interfaceClass);
            }
            boolean emitter = connection.isInstanceOf(objName, NOTIF_EMITTER);
            return JMX.newMXBeanProxy(connection, objName, mxbeanInterface, emitter);
        }
        catch (InstanceNotFoundException e) {
            IllegalArgumentException iae = new IllegalArgumentException(mxbeanName + " not found in the connection.");
            iae.initCause(e);
            throw iae;
        }
        catch (MalformedObjectNameException e) {
            IllegalArgumentException iae = new IllegalArgumentException(mxbeanName + " is not a valid ObjectName format.");
            iae.initCause(e);
            throw iae;
        }
    }
}

