/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.security.AccessController;
import sun.security.action.LoadLibraryAction;

public final class DatagramPacket {
    byte[] buf;
    int offset;
    int length;
    int bufLength;
    InetAddress address;
    int port;

    public DatagramPacket(byte[] buf, int offset, int length) {
        this.setData(buf, offset, length);
        this.address = null;
        this.port = -1;
    }

    public DatagramPacket(byte[] buf, int length) {
        this(buf, 0, length);
    }

    public DatagramPacket(byte[] buf, int offset, int length, InetAddress address, int port) {
        this.setData(buf, offset, length);
        this.setAddress(address);
        this.setPort(port);
    }

    public DatagramPacket(byte[] buf, int offset, int length, SocketAddress address) throws SocketException {
        this.setData(buf, offset, length);
        this.setSocketAddress(address);
    }

    public DatagramPacket(byte[] buf, int length, InetAddress address, int port) {
        this(buf, 0, length, address, port);
    }

    public DatagramPacket(byte[] buf, int length, SocketAddress address) throws SocketException {
        this(buf, 0, length, address);
    }

    public synchronized InetAddress getAddress() {
        return this.address;
    }

    public synchronized int getPort() {
        return this.port;
    }

    public synchronized byte[] getData() {
        return this.buf;
    }

    public synchronized int getOffset() {
        return this.offset;
    }

    public synchronized int getLength() {
        return this.length;
    }

    public synchronized void setData(byte[] buf, int offset, int length) {
        if (length < 0 || offset < 0 || length + offset < 0 || length + offset > buf.length) {
            throw new IllegalArgumentException("illegal length or offset");
        }
        this.buf = buf;
        this.length = length;
        this.bufLength = length;
        this.offset = offset;
    }

    public synchronized void setAddress(InetAddress iaddr) {
        this.address = iaddr;
    }

    public synchronized void setPort(int iport) {
        if (iport < 0 || iport > 65535) {
            throw new IllegalArgumentException("Port out of range:" + iport);
        }
        this.port = iport;
    }

    public synchronized void setSocketAddress(SocketAddress address) {
        if (address == null || !(address instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("unsupported address type");
        }
        InetSocketAddress addr = (InetSocketAddress)address;
        if (addr.isUnresolved()) {
            throw new IllegalArgumentException("unresolved address");
        }
        this.setAddress(addr.getAddress());
        this.setPort(addr.getPort());
    }

    public synchronized SocketAddress getSocketAddress() {
        return new InetSocketAddress(this.getAddress(), this.getPort());
    }

    public synchronized void setData(byte[] buf) {
        if (buf == null) {
            throw new NullPointerException("null packet buffer");
        }
        this.buf = buf;
        this.offset = 0;
        this.length = buf.length;
        this.bufLength = buf.length;
    }

    public synchronized void setLength(int length) {
        if (length + this.offset > this.buf.length || length < 0 || length + this.offset < 0) {
            throw new IllegalArgumentException("illegal length");
        }
        this.bufLength = this.length = length;
    }

    private static native void init();

    static {
        AccessController.doPrivileged(new LoadLibraryAction("javanet"));
        DatagramPacket.init();
    }
}

