/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.ObjectStreamException;
import java.net.InetAddress;

public final class Inet4Address
extends InetAddress {
    static final int INADDRSZ = 4;
    private static final long serialVersionUID = 3286316764910316507L;
    private static final int loopback = 2130706433;

    Inet4Address() {
        this.hostName = null;
        this.address = 0;
        this.family = 1;
    }

    Inet4Address(String hostName, byte[] addr) {
        this.hostName = hostName;
        this.family = 1;
        if (addr != null && addr.length == 4) {
            this.address = addr[3] & 0xFF;
            this.address |= addr[2] << 8 & 0xFF00;
            this.address |= addr[1] << 16 & 0xFF0000;
            this.address |= addr[0] << 24 & 0xFF000000;
        }
    }

    Inet4Address(String hostName, int address) {
        this.hostName = hostName;
        this.family = 1;
        this.address = address;
    }

    private Object writeReplace() throws ObjectStreamException {
        InetAddress inet = new InetAddress();
        inet.hostName = this.hostName;
        inet.address = this.address;
        inet.family = 2;
        return inet;
    }

    public boolean isMulticastAddress() {
        return (this.address & 0xF0000000) == -536870912;
    }

    public boolean isAnyLocalAddress() {
        return this.address == 0;
    }

    public boolean isLoopbackAddress() {
        byte[] byteAddr = this.getAddress();
        return byteAddr[0] == 127;
    }

    public boolean isLinkLocalAddress() {
        return (this.address >>> 24 & 0xFF) == 169 && (this.address >>> 16 & 0xFF) == 254;
    }

    public boolean isSiteLocalAddress() {
        return (this.address >>> 24 & 0xFF) == 10 || (this.address >>> 24 & 0xFF) == 172 && (this.address >>> 16 & 0xF0) == 16 || (this.address >>> 24 & 0xFF) == 192 && (this.address >>> 16 & 0xFF) == 168;
    }

    public boolean isMCGlobal() {
        byte[] byteAddr = this.getAddress();
        return (byteAddr[0] & 0xFF) >= 224 && (byteAddr[0] & 0xFF) <= 238 && ((byteAddr[0] & 0xFF) != 224 || byteAddr[1] != 0 || byteAddr[2] != 0);
    }

    public boolean isMCNodeLocal() {
        return false;
    }

    public boolean isMCLinkLocal() {
        return (this.address >>> 24 & 0xFF) == 224 && (this.address >>> 16 & 0xFF) == 0 && (this.address >>> 8 & 0xFF) == 0;
    }

    public boolean isMCSiteLocal() {
        return (this.address >>> 24 & 0xFF) == 239 && (this.address >>> 16 & 0xFF) == 255;
    }

    public boolean isMCOrgLocal() {
        return (this.address >>> 24 & 0xFF) == 239 && (this.address >>> 16 & 0xFF) >= 192 && (this.address >>> 16 & 0xFF) <= 195;
    }

    public byte[] getAddress() {
        byte[] addr = new byte[]{(byte)(this.address >>> 24 & 0xFF), (byte)(this.address >>> 16 & 0xFF), (byte)(this.address >>> 8 & 0xFF), (byte)(this.address & 0xFF)};
        return addr;
    }

    public String getHostAddress() {
        return Inet4Address.numericToTextFormat(this.getAddress());
    }

    public int hashCode() {
        return this.address;
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof Inet4Address && ((InetAddress)obj).address == this.address;
    }

    static String numericToTextFormat(byte[] src) {
        return (src[0] & 0xFF) + "." + (src[1] & 0xFF) + "." + (src[2] & 0xFF) + "." + (src[3] & 0xFF);
    }

    private static native void init();

    static {
        Inet4Address.init();
    }
}

