/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddressImpl;
import java.net.InetAddressImplFactory;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import sun.misc.Service;
import sun.net.InetAddressCachePolicy;
import sun.net.spi.nameservice.NameService;
import sun.net.spi.nameservice.NameServiceDescriptor;
import sun.net.util.IPAddressUtil;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetPropertyAction;
import sun.security.action.LoadLibraryAction;

public class InetAddress
implements Serializable {
    static final int IPv4 = 1;
    static final int IPv6 = 2;
    static transient boolean preferIPv6Address;
    String hostName;
    int address;
    int family;
    private static List<NameService> nameServices;
    private transient String canonicalHostName = null;
    private static final long serialVersionUID = 3286316764910316507L;
    private static Cache addressCache;
    private static Cache negativeCache;
    private static boolean addressCacheInit;
    static InetAddress[] unknown_array;
    static InetAddressImpl impl;
    private static HashMap lookupTable;
    private static InetAddress cachedLocalHost;
    private static long cacheTime;
    private static final long maxCacheTime = 5000L;
    private static final Object cacheLock;

    InetAddress() {
    }

    private Object readResolve() throws ObjectStreamException {
        return new Inet4Address(this.hostName, this.address);
    }

    public boolean isMulticastAddress() {
        return false;
    }

    public boolean isAnyLocalAddress() {
        return false;
    }

    public boolean isLoopbackAddress() {
        return false;
    }

    public boolean isLinkLocalAddress() {
        return false;
    }

    public boolean isSiteLocalAddress() {
        return false;
    }

    public boolean isMCGlobal() {
        return false;
    }

    public boolean isMCNodeLocal() {
        return false;
    }

    public boolean isMCLinkLocal() {
        return false;
    }

    public boolean isMCSiteLocal() {
        return false;
    }

    public boolean isMCOrgLocal() {
        return false;
    }

    public boolean isReachable(int timeout) throws IOException {
        return this.isReachable(null, 0, timeout);
    }

    public boolean isReachable(NetworkInterface netif, int ttl, int timeout) throws IOException {
        if (ttl < 0) {
            throw new IllegalArgumentException("ttl can't be negative");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout can't be negative");
        }
        return impl.isReachable(this, timeout, netif, ttl);
    }

    public String getHostName() {
        return this.getHostName(true);
    }

    String getHostName(boolean check) {
        if (this.hostName == null) {
            this.hostName = InetAddress.getHostFromNameService(this, check);
        }
        return this.hostName;
    }

    public String getCanonicalHostName() {
        if (this.canonicalHostName == null) {
            this.canonicalHostName = InetAddress.getHostFromNameService(this, true);
        }
        return this.canonicalHostName;
    }

    private static String getHostFromNameService(InetAddress addr, boolean check) {
        String host = null;
        for (NameService nameService : nameServices) {
            try {
                SecurityManager sec;
                host = nameService.getHostByAddr(addr.getAddress());
                if (check && (sec = System.getSecurityManager()) != null) {
                    sec.checkConnect(host, -1);
                }
                InetAddress[] arr = InetAddress.getAllByName0(host, check);
                boolean ok = false;
                if (arr != null) {
                    for (int i = 0; !ok && i < arr.length; ++i) {
                        ok = addr.equals(arr[i]);
                    }
                }
                if (!ok) {
                    host = addr.getHostAddress();
                    return host;
                }
                break;
            }
            catch (SecurityException e) {
                host = addr.getHostAddress();
                break;
            }
            catch (UnknownHostException e) {
                host = addr.getHostAddress();
            }
        }
        return host;
    }

    public byte[] getAddress() {
        return null;
    }

    public String getHostAddress() {
        return null;
    }

    public int hashCode() {
        return -1;
    }

    public boolean equals(Object obj) {
        return false;
    }

    public String toString() {
        return (this.hostName != null ? this.hostName : "") + "/" + this.getHostAddress();
    }

    private static void cacheInitIfNeeded() {
        assert (Thread.holdsLock(addressCache));
        if (addressCacheInit) {
            return;
        }
        unknown_array = new InetAddress[1];
        InetAddress.unknown_array[0] = impl.anyLocalAddress();
        addressCache.put(impl.anyLocalAddress().getHostName(), unknown_array);
        addressCacheInit = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cacheAddress(String hostname, Object address, boolean success) {
        hostname = hostname.toLowerCase();
        Cache cache = addressCache;
        synchronized (cache) {
            InetAddress.cacheInitIfNeeded();
            if (success) {
                addressCache.put(hostname, address);
            } else {
                negativeCache.put(hostname, address);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getCachedAddress(String hostname) {
        hostname = hostname.toLowerCase();
        Cache cache = addressCache;
        synchronized (cache) {
            InetAddress.cacheInitIfNeeded();
            CacheEntry entry = addressCache.get(hostname);
            if (entry == null) {
                entry = negativeCache.get(hostname);
            }
            if (entry != null) {
                return entry.address;
            }
        }
        return null;
    }

    private static NameService createNSProvider(String provider) {
        if (provider == null) {
            return null;
        }
        NameService nameService = null;
        if (provider.equals("default")) {
            nameService = new NameService(){

                public InetAddress[] lookupAllHostAddr(String host) throws UnknownHostException {
                    return impl.lookupAllHostAddr(host);
                }

                public String getHostByAddr(byte[] addr) throws UnknownHostException {
                    return impl.getHostByAddr(addr);
                }
            };
        } else {
            final String providerName = provider;
            try {
                nameService = AccessController.doPrivileged(new PrivilegedExceptionAction<NameService>(){

                    @Override
                    public NameService run() {
                        Iterator itr = Service.providers(NameServiceDescriptor.class);
                        while (itr.hasNext()) {
                            NameServiceDescriptor nsd = (NameServiceDescriptor)itr.next();
                            if (!providerName.equalsIgnoreCase(nsd.getType() + "," + nsd.getProviderName())) continue;
                            try {
                                return nsd.createNameService();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                System.err.println("Cannot create name service:" + providerName + ": " + e);
                            }
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                // empty catch block
            }
        }
        return nameService;
    }

    public static InetAddress getByAddress(String host, byte[] addr) throws UnknownHostException {
        if (host != null && host.length() > 0 && host.charAt(0) == '[' && host.charAt(host.length() - 1) == ']') {
            host = host.substring(1, host.length() - 1);
        }
        if (addr != null) {
            if (addr.length == 4) {
                return new Inet4Address(host, addr);
            }
            if (addr.length == 16) {
                byte[] newAddr = IPAddressUtil.convertFromIPv4MappedAddress(addr);
                if (newAddr != null) {
                    return new Inet4Address(host, newAddr);
                }
                return new Inet6Address(host, addr);
            }
        }
        throw new UnknownHostException("addr is of illegal length");
    }

    public static InetAddress getByName(String host) throws UnknownHostException {
        return InetAddress.getAllByName(host)[0];
    }

    private static InetAddress getByName(String host, InetAddress reqAddr) throws UnknownHostException {
        return InetAddress.getAllByName(host, reqAddr)[0];
    }

    public static InetAddress[] getAllByName(String host) throws UnknownHostException {
        return InetAddress.getAllByName(host, null);
    }

    private static InetAddress[] getAllByName(String host, InetAddress reqAddr) throws UnknownHostException {
        if (host == null || host.length() == 0) {
            InetAddress[] ret = new InetAddress[]{impl.loopbackAddress()};
            return ret;
        }
        boolean ipv6Expected = false;
        if (host.charAt(0) == '[') {
            if (host.length() > 2 && host.charAt(host.length() - 1) == ']') {
                host = host.substring(1, host.length() - 1);
                ipv6Expected = true;
            } else {
                throw new UnknownHostException(host);
            }
        }
        if (Character.digit(host.charAt(0), 16) != -1 || host.charAt(0) == ':') {
            byte[] addr = null;
            int numericZone = -1;
            String ifname = null;
            addr = IPAddressUtil.textToNumericFormatV4(host);
            if (addr == null) {
                int pos = host.indexOf("%");
                if (pos != -1 && (numericZone = InetAddress.checkNumericZone(host)) == -1) {
                    ifname = host.substring(pos + 1);
                }
                addr = IPAddressUtil.textToNumericFormatV6(host);
            } else if (ipv6Expected) {
                throw new UnknownHostException("[" + host + "]");
            }
            InetAddress[] ret = new InetAddress[1];
            if (addr != null) {
                ret[0] = addr.length == 4 ? new Inet4Address(null, addr) : (ifname != null ? new Inet6Address(null, addr, ifname) : new Inet6Address(null, addr, numericZone));
                return ret;
            }
        } else if (ipv6Expected) {
            throw new UnknownHostException("[" + host + "]");
        }
        return InetAddress.getAllByName0(host, reqAddr, true);
    }

    private static int checkNumericZone(String s) throws UnknownHostException {
        int percent = s.indexOf(37);
        int slen = s.length();
        int zone = 0;
        if (percent == -1) {
            return -1;
        }
        for (int i = percent + 1; i < slen; ++i) {
            char c = s.charAt(i);
            if (c == ']') {
                if (i != percent + 1) break;
                return -1;
            }
            int digit = Character.digit(c, 10);
            if (digit < 0) {
                return -1;
            }
            zone = zone * 10 + digit;
        }
        return zone;
    }

    private static InetAddress[] getAllByName0(String host) throws UnknownHostException {
        return InetAddress.getAllByName0(host, true);
    }

    static InetAddress[] getAllByName0(String host, boolean check) throws UnknownHostException {
        return InetAddress.getAllByName0(host, null, check);
    }

    private static InetAddress[] getAllByName0(String host, InetAddress reqAddr, boolean check) throws UnknownHostException {
        SecurityManager security;
        Object obj = null;
        Object objcopy = null;
        if (check && (security = System.getSecurityManager()) != null) {
            security.checkConnect(host, -1);
        }
        if ((obj = InetAddress.getCachedAddress(host)) == null) {
            obj = InetAddress.getAddressFromNameService(host, reqAddr);
        }
        if (obj == unknown_array) {
            throw new UnknownHostException(host);
        }
        objcopy = ((InetAddress[])obj).clone();
        return (InetAddress[])objcopy;
    }

    private static Object getAddressFromNameService(String host, InetAddress reqAddr) throws UnknownHostException {
        InetAddress[] obj = null;
        boolean success = false;
        UnknownHostException ex = null;
        obj = InetAddress.checkLookupTable(host);
        if (obj == null) {
            for (NameService nameService : nameServices) {
                try {
                    obj = nameService.lookupAllHostAddr(host);
                    success = true;
                    break;
                }
                catch (UnknownHostException uhe) {
                    if (host.equalsIgnoreCase("localhost")) {
                        InetAddress[] local = new InetAddress[]{impl.loopbackAddress()};
                        obj = local;
                        success = true;
                        break;
                    }
                    obj = unknown_array;
                    success = false;
                    ex = uhe;
                }
            }
            InetAddress[] addrs = obj;
            if (reqAddr != null && addrs.length > 1 && !addrs[0].equals(reqAddr)) {
                int i;
                for (i = 1; i < addrs.length && !addrs[i].equals(reqAddr); ++i) {
                }
                if (i < addrs.length) {
                    InetAddress tmp2 = reqAddr;
                    for (int j = 0; j < i; ++j) {
                        InetAddress tmp = addrs[j];
                        addrs[j] = tmp2;
                        tmp2 = tmp;
                    }
                    addrs[i] = tmp2;
                }
            }
            InetAddress.cacheAddress(host, obj, success);
            InetAddress.updateLookupTable(host);
            if (!success && ex != null) {
                throw ex;
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object checkLookupTable(String host) {
        Object obj = null;
        HashMap hashMap = lookupTable;
        synchronized (hashMap) {
            if (!lookupTable.containsKey(host)) {
                lookupTable.put(host, null);
                return obj;
            }
            while (lookupTable.containsKey(host)) {
                try {
                    lookupTable.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        obj = InetAddress.getCachedAddress(host);
        if (obj == null) {
            hashMap = lookupTable;
            synchronized (hashMap) {
                lookupTable.put(host, null);
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateLookupTable(String host) {
        HashMap hashMap = lookupTable;
        synchronized (hashMap) {
            lookupTable.remove(host);
            lookupTable.notifyAll();
        }
    }

    public static InetAddress getByAddress(byte[] addr) throws UnknownHostException {
        return InetAddress.getByAddress(null, addr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InetAddress getLocalHost() throws UnknownHostException {
        SecurityManager security = System.getSecurityManager();
        try {
            String local = impl.getLocalHostName();
            if (security != null) {
                security.checkConnect(local, -1);
            }
            if (local.equals("localhost")) {
                return impl.loopbackAddress();
            }
            InetAddress ret = null;
            Object object = cacheLock;
            synchronized (object) {
                long now = System.currentTimeMillis();
                if (cachedLocalHost != null) {
                    if (now - cacheTime < 5000L) {
                        ret = cachedLocalHost;
                    } else {
                        cachedLocalHost = null;
                    }
                }
                if (ret == null) {
                    InetAddress[] localAddrs;
                    try {
                        localAddrs = (InetAddress[])InetAddress.getAddressFromNameService(local, null);
                    }
                    catch (UnknownHostException uhe) {
                        throw new UnknownHostException(local + ": " + uhe.getMessage());
                    }
                    cachedLocalHost = localAddrs[0];
                    cacheTime = now;
                    ret = localAddrs[0];
                }
            }
            return ret;
        }
        catch (SecurityException e) {
            return impl.loopbackAddress();
        }
    }

    private static native void init();

    static InetAddress anyLocalAddress() {
        return impl.anyLocalAddress();
    }

    static Object loadImpl(String implName) {
        String prefix = AccessController.doPrivileged(new GetPropertyAction("impl.prefix", ""));
        Object impl = null;
        try {
            impl = Class.forName("java.net." + prefix + implName).newInstance();
        }
        catch (ClassNotFoundException e) {
            System.err.println("Class not found: java.net." + prefix + implName + ":\ncheck impl.prefix property " + "in your properties file.");
        }
        catch (InstantiationException e) {
            System.err.println("Could not instantiate: java.net." + prefix + implName + ":\ncheck impl.prefix property " + "in your properties file.");
        }
        catch (IllegalAccessException e) {
            System.err.println("Cannot access class: java.net." + prefix + implName + ":\ncheck impl.prefix property " + "in your properties file.");
        }
        if (impl == null) {
            try {
                impl = Class.forName(implName).newInstance();
            }
            catch (Exception e) {
                throw new Error("System property impl.prefix incorrect");
            }
        }
        return impl;
    }

    private void readObjectNoData(ObjectInputStream s) throws IOException, ClassNotFoundException {
        if (this.getClass().getClassLoader() != null) {
            throw new SecurityException("invalid address type");
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.getClass().getClassLoader() != null) {
            this.hostName = null;
            this.address = 0;
            throw new SecurityException("invalid address type");
        }
    }

    static {
        NameService ns;
        preferIPv6Address = false;
        nameServices = null;
        preferIPv6Address = AccessController.doPrivileged(new GetBooleanAction("java.net.preferIPv6Addresses"));
        AccessController.doPrivileged(new LoadLibraryAction("javanet"));
        InetAddress.init();
        addressCache = new Cache(Cache.Type.Positive);
        negativeCache = new Cache(Cache.Type.Negative);
        addressCacheInit = false;
        lookupTable = new HashMap();
        new InetAddressImplFactory();
        impl = InetAddressImplFactory.create();
        String provider = null;
        String propPrefix = "sun.net.spi.nameservice.provider.";
        int n = 1;
        nameServices = new ArrayList<NameService>();
        provider = AccessController.doPrivileged(new GetPropertyAction(propPrefix + n));
        while (provider != null) {
            ns = InetAddress.createNSProvider(provider);
            if (ns != null) {
                nameServices.add(ns);
            }
            provider = AccessController.doPrivileged(new GetPropertyAction(propPrefix + ++n));
        }
        if (nameServices.size() == 0) {
            ns = InetAddress.createNSProvider("default");
            nameServices.add(ns);
        }
        cachedLocalHost = null;
        cacheTime = 0L;
        cacheLock = new Object();
    }

    static final class Cache {
        private LinkedHashMap cache;
        private Type type;

        public Cache(Type type) {
            this.type = type;
            this.cache = new LinkedHashMap();
        }

        private int getPolicy() {
            if (this.type == Type.Positive) {
                return InetAddressCachePolicy.get();
            }
            return InetAddressCachePolicy.getNegative();
        }

        public Cache put(String host, Object address) {
            int policy = this.getPolicy();
            if (policy == 0) {
                return this;
            }
            if (policy != -1) {
                LinkedList<String> expired = new LinkedList<String>();
                Iterator<Object> i = this.cache.keySet().iterator();
                long now = System.currentTimeMillis();
                while (i.hasNext()) {
                    String key = (String)i.next();
                    CacheEntry entry = (CacheEntry)this.cache.get(key);
                    if (entry.expiration < 0L || entry.expiration >= now) break;
                    expired.add(key);
                }
                i = expired.iterator();
                while (i.hasNext()) {
                    this.cache.remove(i.next());
                }
            }
            long expiration = policy == -1 ? -1L : System.currentTimeMillis() + (long)(policy * 1000);
            CacheEntry entry = new CacheEntry(address, expiration);
            this.cache.put(host, entry);
            return this;
        }

        public CacheEntry get(String host) {
            int policy = this.getPolicy();
            if (policy == 0) {
                return null;
            }
            CacheEntry entry = (CacheEntry)this.cache.get(host);
            if (entry != null && policy != -1 && entry.expiration >= 0L && entry.expiration < System.currentTimeMillis()) {
                this.cache.remove(host);
                entry = null;
            }
            return entry;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum Type {
            Positive,
            Negative;

        }
    }

    static final class CacheEntry {
        Object address;
        long expiration;

        CacheEntry(Object address, long expiration) {
            this.address = address;
            this.expiration = expiration;
        }
    }
}

