/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteBuffer;
import java.nio.ByteBufferAsCharBufferL;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.ReadOnlyBufferException;

class ByteBufferAsCharBufferRL
extends ByteBufferAsCharBufferL {
    ByteBufferAsCharBufferRL(ByteBuffer bb) {
        super(bb);
    }

    ByteBufferAsCharBufferRL(ByteBuffer bb, int mark, int pos, int lim, int cap, int off) {
        super(bb, mark, pos, lim, cap, off);
    }

    public CharBuffer slice() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        int off = (pos << 1) + this.offset;
        assert (off >= 0);
        return new ByteBufferAsCharBufferRL(this.bb, -1, 0, rem, rem, off);
    }

    public CharBuffer duplicate() {
        return new ByteBufferAsCharBufferRL(this.bb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    public CharBuffer asReadOnlyBuffer() {
        return this.duplicate();
    }

    public CharBuffer put(char x) {
        throw new ReadOnlyBufferException();
    }

    public CharBuffer put(int i, char x) {
        throw new ReadOnlyBufferException();
    }

    public CharBuffer compact() {
        throw new ReadOnlyBufferException();
    }

    public boolean isDirect() {
        return this.bb.isDirect();
    }

    public boolean isReadOnly() {
        return true;
    }

    public String toString(int start, int end) {
        if (end > this.limit() || start > end) {
            throw new IndexOutOfBoundsException();
        }
        try {
            int len = end - start;
            char[] ca = new char[len];
            CharBuffer cb = CharBuffer.wrap(ca);
            CharBuffer db = this.duplicate();
            db.position(start);
            db.limit(end);
            cb.put(db);
            return new String(ca);
        }
        catch (StringIndexOutOfBoundsException x) {
            throw new IndexOutOfBoundsException();
        }
    }

    public CharSequence subSequence(int start, int end) {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        pos = pos <= lim ? pos : lim;
        int len = lim - pos;
        if (start < 0 || end > len || start > end) {
            throw new IndexOutOfBoundsException();
        }
        int sublen = end - start;
        int off = this.offset + (pos + start << 1);
        assert (off >= 0);
        return new ByteBufferAsCharBufferRL(this.bb, -1, 0, sublen, sublen, off);
    }

    public ByteOrder order() {
        return ByteOrder.LITTLE_ENDIAN;
    }
}

