/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import sun.nio.ch.ChannelInputStream;
import sun.nio.cs.StreamDecoder;
import sun.nio.cs.StreamEncoder;

public final class Channels {
    private Channels() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int write(WritableByteChannel ch, ByteBuffer bb) throws IOException {
        if (ch instanceof SelectableChannel) {
            SelectableChannel sc = (SelectableChannel)((Object)ch);
            Object object = sc.blockingLock();
            synchronized (object) {
                if (!sc.isBlocking()) {
                    throw new IllegalBlockingModeException();
                }
                return ch.write(bb);
            }
        }
        return ch.write(bb);
    }

    public static InputStream newInputStream(ReadableByteChannel ch) {
        return new ChannelInputStream(ch);
    }

    public static OutputStream newOutputStream(final WritableByteChannel ch) {
        return new OutputStream(){
            private ByteBuffer bb = null;
            private byte[] bs = null;
            private byte[] b1 = null;

            public synchronized void write(int b) throws IOException {
                if (this.b1 == null) {
                    this.b1 = new byte[1];
                }
                this.b1[0] = (byte)b;
                this.write(this.b1);
            }

            public synchronized void write(byte[] bs, int off, int len) throws IOException {
                if (off < 0 || off > bs.length || len < 0 || off + len > bs.length || off + len < 0) {
                    throw new IndexOutOfBoundsException();
                }
                if (len == 0) {
                    return;
                }
                ByteBuffer bb = this.bs == bs ? this.bb : ByteBuffer.wrap(bs);
                bb.limit(Math.min(off + len, bb.capacity()));
                bb.position(off);
                this.bb = bb;
                this.bs = bs;
                Channels.write(ch, bb);
            }

            public void close() throws IOException {
                ch.close();
            }
        };
    }

    public static ReadableByteChannel newChannel(InputStream in) {
        if (in == null) {
            throw new NullPointerException();
        }
        if (in instanceof FileInputStream && FileInputStream.class.equals(in.getClass())) {
            return ((FileInputStream)in).getChannel();
        }
        return new ReadableByteChannelImpl(in);
    }

    public static WritableByteChannel newChannel(OutputStream out) {
        if (out == null) {
            throw new NullPointerException();
        }
        if (out instanceof FileOutputStream && FileOutputStream.class.equals(out.getClass())) {
            return ((FileOutputStream)out).getChannel();
        }
        return new WritableByteChannelImpl(out);
    }

    public static Reader newReader(ReadableByteChannel ch, CharsetDecoder dec, int minBufferCap) {
        dec.reset();
        return StreamDecoder.forDecoder(ch, dec, minBufferCap);
    }

    public static Reader newReader(ReadableByteChannel ch, String csName) {
        return Channels.newReader(ch, Charset.forName(csName).newDecoder(), -1);
    }

    public static Writer newWriter(WritableByteChannel ch, CharsetEncoder enc, int minBufferCap) {
        enc.reset();
        return StreamEncoder.forEncoder(ch, enc, minBufferCap);
    }

    public static Writer newWriter(WritableByteChannel ch, String csName) {
        return Channels.newWriter(ch, Charset.forName(csName).newEncoder(), -1);
    }

    private static class WritableByteChannelImpl
    extends AbstractInterruptibleChannel
    implements WritableByteChannel {
        OutputStream out;
        private static final int TRANSFER_SIZE = 8192;
        private byte[] buf = new byte[0];
        private boolean open = true;
        private Object writeLock = new Object();

        WritableByteChannelImpl(OutputStream out) {
            this.out = out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int write(ByteBuffer src) throws IOException {
            int len = src.remaining();
            Object object = this.writeLock;
            synchronized (object) {
                int totalWritten;
                int bytesToWrite;
                for (totalWritten = 0; totalWritten < len; totalWritten += bytesToWrite) {
                    Object var7_6;
                    bytesToWrite = Math.min(len - totalWritten, 8192);
                    if (this.buf.length < bytesToWrite) {
                        this.buf = new byte[bytesToWrite];
                    }
                    src.get(this.buf, 0, bytesToWrite);
                    try {
                        this.begin();
                        this.out.write(this.buf, 0, bytesToWrite);
                        var7_6 = null;
                        this.end(bytesToWrite > 0);
                        continue;
                    }
                    catch (Throwable throwable) {
                        var7_6 = null;
                        this.end(bytesToWrite > 0);
                        throw throwable;
                    }
                }
                return totalWritten;
            }
        }

        protected void implCloseChannel() throws IOException {
            this.out.close();
            this.open = false;
        }
    }

    private static class ReadableByteChannelImpl
    extends AbstractInterruptibleChannel
    implements ReadableByteChannel {
        InputStream in;
        private static final int TRANSFER_SIZE = 8192;
        private byte[] buf = new byte[0];
        private boolean open = true;
        private Object readLock = new Object();

        ReadableByteChannelImpl(InputStream in) {
            this.in = in;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(ByteBuffer dst) throws IOException {
            int len = dst.remaining();
            int bytesRead = 0;
            Object object = this.readLock;
            synchronized (object) {
                int totalRead;
                for (totalRead = 0; totalRead < len; totalRead += bytesRead) {
                    Object var8_7;
                    int bytesToRead = Math.min(len - totalRead, 8192);
                    if (this.buf.length < bytesToRead) {
                        this.buf = new byte[bytesToRead];
                    }
                    if (totalRead > 0 && this.in.available() <= 0) break;
                    try {
                        this.begin();
                        bytesRead = this.in.read(this.buf, 0, bytesToRead);
                        var8_7 = null;
                        this.end(bytesRead > 0);
                    }
                    catch (Throwable throwable) {
                        var8_7 = null;
                        this.end(bytesRead > 0);
                        throw throwable;
                    }
                    if (bytesRead < 0) break;
                    dst.put(this.buf, 0, bytesRead);
                }
                if (bytesRead < 0 && totalRead == 0) {
                    return -1;
                }
                return totalRead;
            }
        }

        protected void implCloseChannel() throws IOException {
            this.in.close();
            this.open = false;
        }
    }
}

