/*
 * Decompiled with CFR 0.152.
 */
package java.nio.charset;

import java.lang.ref.WeakReference;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderMalfunctionError;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public abstract class CharsetEncoder {
    private final Charset charset;
    private final float averageBytesPerChar;
    private final float maxBytesPerChar;
    private byte[] replacement;
    private CodingErrorAction malformedInputAction = CodingErrorAction.REPORT;
    private CodingErrorAction unmappableCharacterAction = CodingErrorAction.REPORT;
    private static final int ST_RESET = 0;
    private static final int ST_CODING = 1;
    private static final int ST_END = 2;
    private static final int ST_FLUSHED = 3;
    private int state = 0;
    private static String[] stateNames = new String[]{"RESET", "CODING", "CODING_END", "FLUSHED"};
    private WeakReference cachedDecoder = null;

    protected CharsetEncoder(Charset cs, float averageBytesPerChar, float maxBytesPerChar, byte[] replacement) {
        this.charset = cs;
        if (averageBytesPerChar <= 0.0f) {
            throw new IllegalArgumentException("Non-positive averageBytesPerChar");
        }
        if (maxBytesPerChar <= 0.0f) {
            throw new IllegalArgumentException("Non-positive maxBytesPerChar");
        }
        if (!Charset.atBugLevel("1.4") && averageBytesPerChar > maxBytesPerChar) {
            throw new IllegalArgumentException("averageBytesPerChar exceeds maxBytesPerChar");
        }
        this.replacement = replacement;
        this.averageBytesPerChar = averageBytesPerChar;
        this.maxBytesPerChar = maxBytesPerChar;
        this.replaceWith(replacement);
    }

    protected CharsetEncoder(Charset cs, float averageBytesPerChar, float maxBytesPerChar) {
        this(cs, averageBytesPerChar, maxBytesPerChar, new byte[]{63});
    }

    public final Charset charset() {
        return this.charset;
    }

    public final byte[] replacement() {
        return this.replacement;
    }

    public final CharsetEncoder replaceWith(byte[] newReplacement) {
        if (newReplacement == null) {
            throw new IllegalArgumentException("Null replacement");
        }
        int len = newReplacement.length;
        if (len == 0) {
            throw new IllegalArgumentException("Empty replacement");
        }
        if ((float)len > this.maxBytesPerChar) {
            throw new IllegalArgumentException("Replacement too long");
        }
        if (!this.isLegalReplacement(newReplacement)) {
            throw new IllegalArgumentException("Illegal replacement");
        }
        this.replacement = newReplacement;
        this.implReplaceWith(newReplacement);
        return this;
    }

    protected void implReplaceWith(byte[] newReplacement) {
    }

    public boolean isLegalReplacement(byte[] repl) {
        WeakReference wr = this.cachedDecoder;
        CharsetDecoder dec = null;
        if (wr == null || (dec = (CharsetDecoder)wr.get()) == null) {
            dec = this.charset().newDecoder();
            dec.onMalformedInput(CodingErrorAction.REPORT);
            dec.onUnmappableCharacter(CodingErrorAction.REPORT);
            this.cachedDecoder = new WeakReference<CharsetDecoder>(dec);
        } else {
            dec.reset();
        }
        ByteBuffer bb = ByteBuffer.wrap(repl);
        CharBuffer cb = CharBuffer.allocate((int)((float)bb.remaining() * dec.maxCharsPerByte()));
        CoderResult cr = dec.decode(bb, cb, true);
        return !cr.isError();
    }

    public CodingErrorAction malformedInputAction() {
        return this.malformedInputAction;
    }

    public final CharsetEncoder onMalformedInput(CodingErrorAction newAction) {
        if (newAction == null) {
            throw new IllegalArgumentException("Null action");
        }
        this.malformedInputAction = newAction;
        this.implOnMalformedInput(newAction);
        return this;
    }

    protected void implOnMalformedInput(CodingErrorAction newAction) {
    }

    public CodingErrorAction unmappableCharacterAction() {
        return this.unmappableCharacterAction;
    }

    public final CharsetEncoder onUnmappableCharacter(CodingErrorAction newAction) {
        if (newAction == null) {
            throw new IllegalArgumentException("Null action");
        }
        this.unmappableCharacterAction = newAction;
        this.implOnUnmappableCharacter(newAction);
        return this;
    }

    protected void implOnUnmappableCharacter(CodingErrorAction newAction) {
    }

    public final float averageBytesPerChar() {
        return this.averageBytesPerChar;
    }

    public final float maxBytesPerChar() {
        return this.maxBytesPerChar;
    }

    public final CoderResult encode(CharBuffer in, ByteBuffer out, boolean endOfInput) {
        int newState;
        int n = newState = endOfInput ? 2 : 1;
        if (!(this.state == 0 || this.state == 1 || endOfInput && this.state == 2)) {
            this.throwIllegalStateException(this.state, newState);
        }
        this.state = newState;
        while (true) {
            CoderResult cr;
            try {
                cr = this.encodeLoop(in, out);
            }
            catch (BufferUnderflowException x) {
                throw new CoderMalfunctionError(x);
            }
            catch (BufferOverflowException x) {
                throw new CoderMalfunctionError(x);
            }
            if (cr.isOverflow()) {
                return cr;
            }
            if (cr.isUnderflow()) {
                if (endOfInput && in.hasRemaining()) {
                    cr = CoderResult.malformedForLength(in.remaining());
                } else {
                    return cr;
                }
            }
            CodingErrorAction action = null;
            if (cr.isMalformed()) {
                action = this.malformedInputAction;
            } else if (cr.isUnmappable()) {
                action = this.unmappableCharacterAction;
            } else assert (false) : cr.toString();
            if (action == CodingErrorAction.REPORT) {
                return cr;
            }
            if (action == CodingErrorAction.REPLACE) {
                if (out.remaining() < this.replacement.length) {
                    return CoderResult.OVERFLOW;
                }
                out.put(this.replacement);
            }
            if (action == CodingErrorAction.IGNORE || action == CodingErrorAction.REPLACE) {
                in.position(in.position() + cr.length());
                continue;
            }
            if (!$assertionsDisabled) break;
        }
        throw new AssertionError();
    }

    public final CoderResult flush(ByteBuffer out) {
        if (this.state == 2) {
            CoderResult cr = this.implFlush(out);
            if (cr.isUnderflow()) {
                this.state = 3;
            }
            return cr;
        }
        if (this.state != 3) {
            this.throwIllegalStateException(this.state, 3);
        }
        return CoderResult.UNDERFLOW;
    }

    protected CoderResult implFlush(ByteBuffer out) {
        return CoderResult.UNDERFLOW;
    }

    public final CharsetEncoder reset() {
        this.implReset();
        this.state = 0;
        return this;
    }

    protected void implReset() {
    }

    protected abstract CoderResult encodeLoop(CharBuffer var1, ByteBuffer var2);

    public final ByteBuffer encode(CharBuffer in) throws CharacterCodingException {
        int n = (int)((float)in.remaining() * this.averageBytesPerChar());
        ByteBuffer out = ByteBuffer.allocate(n);
        if (n == 0 && in.remaining() == 0) {
            return out;
        }
        this.reset();
        while (true) {
            CoderResult cr;
            CoderResult coderResult = cr = in.hasRemaining() ? this.encode(in, out, true) : CoderResult.UNDERFLOW;
            if (cr.isUnderflow()) {
                cr = this.flush(out);
            }
            if (cr.isUnderflow()) break;
            if (cr.isOverflow()) {
                n = 2 * n + 1;
                ByteBuffer o = ByteBuffer.allocate(n);
                out.flip();
                o.put(out);
                out = o;
                continue;
            }
            cr.throwException();
        }
        out.flip();
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canEncode(CharBuffer cb) {
        if (this.state == 3) {
            this.reset();
        } else if (this.state != 0) {
            this.throwIllegalStateException(this.state, 1);
        }
        CodingErrorAction ma = this.malformedInputAction();
        CodingErrorAction ua = this.unmappableCharacterAction();
        try {
            this.onMalformedInput(CodingErrorAction.REPORT);
            this.onUnmappableCharacter(CodingErrorAction.REPORT);
            this.encode(cb);
        }
        catch (CharacterCodingException x) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.onMalformedInput(ma);
            this.onUnmappableCharacter(ua);
            this.reset();
        }
        return true;
    }

    public boolean canEncode(char c) {
        CharBuffer cb = CharBuffer.allocate(1);
        cb.put(c);
        cb.flip();
        return this.canEncode(cb);
    }

    public boolean canEncode(CharSequence cs) {
        CharBuffer cb = cs instanceof CharBuffer ? ((CharBuffer)cs).duplicate() : CharBuffer.wrap(((Object)cs).toString());
        return this.canEncode(cb);
    }

    private void throwIllegalStateException(int from, int to) {
        throw new IllegalStateException("Current state = " + stateNames[from] + ", new state = " + stateNames[to]);
    }
}

