/*
 * Decompiled with CFR 0.152.
 */
package java.sql;

import java.util.Date;
import java.util.StringTokenizer;

public class Timestamp
extends Date {
    private int nanos;
    static final long serialVersionUID = 2745179027874758501L;

    @Deprecated
    public Timestamp(int year, int month, int date, int hour, int minute, int second, int nano) {
        super(year, month, date, hour, minute, second);
        if (nano > 999999999 || nano < 0) {
            throw new IllegalArgumentException("nanos > 999999999 or < 0");
        }
        this.nanos = nano;
    }

    public Timestamp(long time) {
        super(time / 1000L * 1000L);
        this.nanos = (int)(time % 1000L * 1000000L);
        if (this.nanos < 0) {
            this.nanos = 1000000000 + this.nanos;
            super.setTime((time / 1000L - 1L) * 1000L);
        }
    }

    public void setTime(long time) {
        super.setTime(time / 1000L * 1000L);
        this.nanos = (int)(time % 1000L * 1000000L);
        if (this.nanos < 0) {
            this.nanos = 1000000000 + this.nanos;
            super.setTime((time / 1000L - 1L) * 1000L);
        }
    }

    public long getTime() {
        long time = super.getTime();
        return time + (long)(this.nanos / 1000000);
    }

    public static Timestamp valueOf(String s) {
        int second;
        int minute;
        int hour;
        int a_nanos = 0;
        int firstColon = 0;
        int secondColon = 0;
        int period = 0;
        String formatError = "Timestamp format must be yyyy-mm-dd hh:mm:ss[.fffffffff]";
        String zeros = "000000000";
        String delimiterDate = "-";
        String delimiterTime = ":";
        if (s == null) {
            throw new IllegalArgumentException("null string");
        }
        int counterD = 0;
        int[] intDate = new int[]{4, 2, 2};
        boolean counterT = false;
        int[] intTime = new int[]{2, 2, 12};
        int dividingSpace = (s = s.trim()).indexOf(32);
        if (dividingSpace <= 0) {
            throw new IllegalArgumentException(formatError);
        }
        String date_s = s.substring(0, dividingSpace);
        String time_s = s.substring(dividingSpace + 1);
        StringTokenizer stringTokeninzerTime = new StringTokenizer(time_s, delimiterTime);
        StringTokenizer stringTokeninzerDate = new StringTokenizer(date_s, delimiterDate);
        while (stringTokeninzerDate.hasMoreTokens()) {
            String tokenDate = stringTokeninzerDate.nextToken();
            if (tokenDate.length() != intDate[counterD]) {
                throw new IllegalArgumentException(formatError);
            }
            ++counterD;
        }
        int firstDash = date_s.indexOf(45);
        int secondDash = date_s.indexOf(45, firstDash + 1);
        if (time_s == null) {
            throw new IllegalArgumentException(formatError);
        }
        firstColon = time_s.indexOf(58);
        secondColon = time_s.indexOf(58, firstColon + 1);
        period = time_s.indexOf(46, secondColon + 1);
        if (firstDash <= 0 || secondDash <= 0 || secondDash >= date_s.length() - 1) {
            throw new IllegalArgumentException(formatError);
        }
        int year = Integer.parseInt(date_s.substring(0, firstDash)) - 1900;
        int month = Integer.parseInt(date_s.substring(firstDash + 1, secondDash)) - 1;
        int day = Integer.parseInt(date_s.substring(secondDash + 1));
        if (firstColon > 0 & secondColon > 0 & secondColon < time_s.length() - 1) {
            hour = Integer.parseInt(time_s.substring(0, firstColon));
            minute = Integer.parseInt(time_s.substring(firstColon + 1, secondColon));
            if (period > 0 & period < time_s.length() - 1) {
                second = Integer.parseInt(time_s.substring(secondColon + 1, period));
                String nanos_s = time_s.substring(period + 1);
                if (nanos_s.length() > 9) {
                    throw new IllegalArgumentException(formatError);
                }
                if (!Character.isDigit(nanos_s.charAt(0))) {
                    throw new IllegalArgumentException(formatError);
                }
                nanos_s = nanos_s + zeros.substring(0, 9 - nanos_s.length());
                a_nanos = Integer.parseInt(nanos_s);
            } else {
                if (period > 0) {
                    throw new IllegalArgumentException(formatError);
                }
                second = Integer.parseInt(time_s.substring(secondColon + 1));
            }
        } else {
            throw new IllegalArgumentException();
        }
        return new Timestamp(year, month, day, hour, minute, second, a_nanos);
    }

    public String toString() {
        String nanosString;
        String yearString;
        int year = super.getYear() + 1900;
        int month = super.getMonth() + 1;
        int day = super.getDate();
        int hour = super.getHours();
        int minute = super.getMinutes();
        int second = super.getSeconds();
        String zeros = "000000000";
        String yearZeros = "0000";
        if (year < 1000) {
            yearString = "" + year;
            yearString = yearZeros.substring(0, 4 - yearString.length()) + yearString;
        } else {
            yearString = "" + year;
        }
        String monthString = month < 10 ? "0" + month : Integer.toString(month);
        String dayString = day < 10 ? "0" + day : Integer.toString(day);
        String hourString = hour < 10 ? "0" + hour : Integer.toString(hour);
        String minuteString = minute < 10 ? "0" + minute : Integer.toString(minute);
        String secondString = second < 10 ? "0" + second : Integer.toString(second);
        if (this.nanos == 0) {
            nanosString = "0";
        } else {
            nanosString = Integer.toString(this.nanos);
            nanosString = zeros.substring(0, 9 - nanosString.length()) + nanosString;
            char[] nanosChar = new char[nanosString.length()];
            nanosString.getChars(0, nanosString.length(), nanosChar, 0);
            int truncIndex = 8;
            while (nanosChar[truncIndex] == '0') {
                --truncIndex;
            }
            nanosString = new String(nanosChar, 0, truncIndex + 1);
        }
        StringBuffer timestampBuf = new StringBuffer(20 + nanosString.length());
        timestampBuf.append(yearString);
        timestampBuf.append("-");
        timestampBuf.append(monthString);
        timestampBuf.append("-");
        timestampBuf.append(dayString);
        timestampBuf.append(" ");
        timestampBuf.append(hourString);
        timestampBuf.append(":");
        timestampBuf.append(minuteString);
        timestampBuf.append(":");
        timestampBuf.append(secondString);
        timestampBuf.append(".");
        timestampBuf.append(nanosString);
        return timestampBuf.toString();
    }

    public int getNanos() {
        return this.nanos;
    }

    public void setNanos(int n) {
        if (n > 999999999 || n < 0) {
            throw new IllegalArgumentException("nanos > 999999999 or < 0");
        }
        this.nanos = n;
    }

    public boolean equals(Timestamp ts) {
        if (super.equals(ts)) {
            return this.nanos == ts.nanos;
        }
        return false;
    }

    public boolean equals(Object ts) {
        if (ts instanceof Timestamp) {
            return this.equals((Timestamp)ts);
        }
        return false;
    }

    public boolean before(Timestamp ts) {
        return this.compareTo(ts) < 0;
    }

    public boolean after(Timestamp ts) {
        return this.compareTo(ts) > 0;
    }

    public int compareTo(Timestamp ts) {
        int i;
        long anotherTime;
        long thisTime = this.getTime();
        int n = thisTime < (anotherTime = ts.getTime()) ? -1 : (i = thisTime == anotherTime ? 0 : 1);
        if (i == 0) {
            if (this.nanos > ts.nanos) {
                return 1;
            }
            if (this.nanos < ts.nanos) {
                return -1;
            }
        }
        return i;
    }

    public int compareTo(Date o) {
        if (o instanceof Timestamp) {
            return this.compareTo((Timestamp)o);
        }
        Timestamp ts = new Timestamp(o.getTime());
        return this.compareTo(ts);
    }
}

