/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.CollationKey;
import java.text.CollationRules;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.text.spi.CollatorProvider;
import java.util.Comparator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import sun.misc.SoftCache;
import sun.util.LocaleServiceProviderPool;
import sun.util.resources.LocaleData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Collator
implements Comparator<Object>,
Cloneable {
    public static final int PRIMARY = 0;
    public static final int SECONDARY = 1;
    public static final int TERTIARY = 2;
    public static final int IDENTICAL = 3;
    public static final int NO_DECOMPOSITION = 0;
    public static final int CANONICAL_DECOMPOSITION = 1;
    public static final int FULL_DECOMPOSITION = 2;
    private int strength = 2;
    private int decmp = 1;
    private static SoftCache cache = new SoftCache();
    static final int LESS = -1;
    static final int EQUAL = 0;
    static final int GREATER = 1;

    public static synchronized Collator getInstance() {
        return Collator.getInstance(Locale.getDefault());
    }

    public static synchronized Collator getInstance(Locale desiredLocale) {
        Collator providersInstance;
        Collator result = (Collator)cache.get(desiredLocale);
        if (result != null) {
            return (Collator)result.clone();
        }
        LocaleServiceProviderPool pool = LocaleServiceProviderPool.getPool(CollatorProvider.class);
        if (pool.hasProviders() && (providersInstance = pool.getLocalizedObject(CollatorGetter.INSTANCE, desiredLocale, desiredLocale)) != null) {
            return providersInstance;
        }
        String colString = "";
        try {
            ResourceBundle resource = LocaleData.getCollationData(desiredLocale);
            colString = resource.getString("Rule");
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        try {
            result = new RuleBasedCollator(CollationRules.DEFAULTRULES + colString, 1);
        }
        catch (ParseException foo) {
            try {
                result = new RuleBasedCollator(CollationRules.DEFAULTRULES);
            }
            catch (ParseException bar) {
                // empty catch block
            }
        }
        result.setDecomposition(0);
        cache.put(desiredLocale, result);
        return (Collator)result.clone();
    }

    @Override
    public abstract int compare(String var1, String var2);

    @Override
    public int compare(Object o1, Object o2) {
        return this.compare((String)o1, (String)o2);
    }

    public abstract CollationKey getCollationKey(String var1);

    public boolean equals(String source, String target) {
        return this.compare(source, target) == 0;
    }

    public synchronized int getStrength() {
        return this.strength;
    }

    public synchronized void setStrength(int newStrength) {
        if (newStrength != 0 && newStrength != 1 && newStrength != 2 && newStrength != 3) {
            throw new IllegalArgumentException("Incorrect comparison level.");
        }
        this.strength = newStrength;
    }

    public synchronized int getDecomposition() {
        return this.decmp;
    }

    public synchronized void setDecomposition(int decompositionMode) {
        if (decompositionMode != 0 && decompositionMode != 1 && decompositionMode != 2) {
            throw new IllegalArgumentException("Wrong decomposition mode.");
        }
        this.decmp = decompositionMode;
    }

    public static synchronized Locale[] getAvailableLocales() {
        LocaleServiceProviderPool pool = LocaleServiceProviderPool.getPool(CollatorProvider.class);
        return pool.getAvailableLocales();
    }

    public Object clone() {
        try {
            return (Collator)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (this.getClass() != that.getClass()) {
            return false;
        }
        Collator other = (Collator)that;
        return this.strength == other.strength && this.decmp == other.decmp;
    }

    public abstract int hashCode();

    protected Collator() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CollatorGetter
    implements LocaleServiceProviderPool.LocalizedObjectGetter<CollatorProvider, Collator> {
        private static final CollatorGetter INSTANCE = new CollatorGetter();

        private CollatorGetter() {
        }

        @Override
        public Collator getObject(CollatorProvider collatorProvider, Locale locale, String key, Object ... params) {
            assert (params.length == 1);
            Collator result = collatorProvider.getInstance(locale);
            if (result != null) {
                cache.put((Locale)params[0], result);
                cache.put(locale, result);
                return (Collator)result.clone();
            }
            return null;
        }
    }
}

