/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.text.spi.DateFormatSymbolsProvider;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import sun.util.LocaleServiceProviderPool;
import sun.util.TimeZoneNameUtility;
import sun.util.resources.LocaleData;

public class DateFormatSymbols
implements Serializable,
Cloneable {
    String[] eras = null;
    String[] months = null;
    String[] shortMonths = null;
    String[] weekdays = null;
    String[] shortWeekdays = null;
    String[] ampms = null;
    String[][] zoneStrings = null;
    transient boolean isZoneStringsSet = false;
    static final String patternChars = "GyMdkHmsSEDFwWahKzZ";
    String localPatternChars = null;
    Locale locale = null;
    static final long serialVersionUID = -5987973545549424702L;
    static final int millisPerHour = 3600000;
    private static Hashtable cachedLocaleData = new Hashtable(3);

    public DateFormatSymbols() {
        this.initializeData(Locale.getDefault());
    }

    public DateFormatSymbols(Locale locale) {
        this.initializeData(locale);
    }

    public static Locale[] getAvailableLocales() {
        LocaleServiceProviderPool pool = LocaleServiceProviderPool.getPool(DateFormatSymbolsProvider.class);
        return pool.getAvailableLocales();
    }

    public static final DateFormatSymbols getInstance() {
        return DateFormatSymbols.getInstance(Locale.getDefault());
    }

    public static final DateFormatSymbols getInstance(Locale locale) {
        DateFormatSymbols providersInstance;
        LocaleServiceProviderPool pool = LocaleServiceProviderPool.getPool(DateFormatSymbolsProvider.class);
        if (pool.hasProviders() && (providersInstance = pool.getLocalizedObject(DateFormatSymbolsGetter.INSTANCE, locale, new Object[0])) != null) {
            return providersInstance;
        }
        return new DateFormatSymbols(locale);
    }

    public String[] getEras() {
        return this.duplicate(this.eras);
    }

    public void setEras(String[] newEras) {
        this.eras = this.duplicate(newEras);
    }

    public String[] getMonths() {
        return this.duplicate(this.months);
    }

    public void setMonths(String[] newMonths) {
        this.months = this.duplicate(newMonths);
    }

    public String[] getShortMonths() {
        return this.duplicate(this.shortMonths);
    }

    public void setShortMonths(String[] newShortMonths) {
        this.shortMonths = this.duplicate(newShortMonths);
    }

    public String[] getWeekdays() {
        return this.duplicate(this.weekdays);
    }

    public void setWeekdays(String[] newWeekdays) {
        this.weekdays = this.duplicate(newWeekdays);
    }

    public String[] getShortWeekdays() {
        return this.duplicate(this.shortWeekdays);
    }

    public void setShortWeekdays(String[] newShortWeekdays) {
        this.shortWeekdays = this.duplicate(newShortWeekdays);
    }

    public String[] getAmPmStrings() {
        return this.duplicate(this.ampms);
    }

    public void setAmPmStrings(String[] newAmpms) {
        this.ampms = this.duplicate(newAmpms);
    }

    public String[][] getZoneStrings() {
        return this.getZoneStringsImpl(true);
    }

    public void setZoneStrings(String[][] newZoneStrings) {
        String[][] aCopy = new String[newZoneStrings.length][];
        for (int i = 0; i < newZoneStrings.length; ++i) {
            if (newZoneStrings[i].length < 5) {
                throw new IllegalArgumentException();
            }
            aCopy[i] = this.duplicate(newZoneStrings[i]);
        }
        this.zoneStrings = aCopy;
        this.isZoneStringsSet = true;
    }

    public String getLocalPatternChars() {
        return new String(this.localPatternChars);
    }

    public void setLocalPatternChars(String newLocalPatternChars) {
        this.localPatternChars = new String(newLocalPatternChars);
    }

    public Object clone() {
        try {
            DateFormatSymbols other = (DateFormatSymbols)super.clone();
            this.copyMembers(this, other);
            return other;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public int hashCode() {
        int hashcode = 0;
        String[][] zoneStrings = this.getZoneStringsWrapper();
        for (int index = 0; index < zoneStrings[0].length; ++index) {
            hashcode ^= zoneStrings[0][index].hashCode();
        }
        return hashcode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DateFormatSymbols that = (DateFormatSymbols)obj;
        return Arrays.equals(this.eras, that.eras) && Arrays.equals(this.months, that.months) && Arrays.equals(this.shortMonths, that.shortMonths) && Arrays.equals(this.weekdays, that.weekdays) && Arrays.equals(this.shortWeekdays, that.shortWeekdays) && Arrays.equals(this.ampms, that.ampms) && Arrays.deepEquals((Object[])this.getZoneStringsWrapper(), (Object[])that.getZoneStringsWrapper()) && (this.localPatternChars != null && this.localPatternChars.equals(that.localPatternChars) || this.localPatternChars == null && that.localPatternChars == null);
    }

    private static ResourceBundle cacheLookup(Locale desiredLocale) {
        ResourceBundle rb;
        SoftReference<ResourceBundle> data = (SoftReference<ResourceBundle>)cachedLocaleData.get(desiredLocale);
        if (data == null) {
            rb = LocaleData.getDateFormatData(desiredLocale);
            data = new SoftReference<ResourceBundle>(rb);
            cachedLocaleData.put(desiredLocale, data);
        } else {
            rb = (ResourceBundle)data.get();
            if (rb == null) {
                rb = LocaleData.getDateFormatData(desiredLocale);
                data = new SoftReference<ResourceBundle>(rb);
            }
        }
        return rb;
    }

    private void initializeData(Locale desiredLocale) {
        int i;
        ResourceBundle resource = DateFormatSymbols.cacheLookup(desiredLocale);
        this.eras = (String[])resource.getObject("Eras");
        this.months = resource.getStringArray("MonthNames");
        this.shortMonths = resource.getStringArray("MonthAbbreviations");
        String[] lWeekdays = resource.getStringArray("DayNames");
        this.weekdays = new String[8];
        this.weekdays[0] = "";
        for (i = 0; i < lWeekdays.length; ++i) {
            this.weekdays[i + 1] = lWeekdays[i];
        }
        String[] sWeekdays = resource.getStringArray("DayAbbreviations");
        this.shortWeekdays = new String[8];
        this.shortWeekdays[0] = "";
        for (i = 0; i < sWeekdays.length; ++i) {
            this.shortWeekdays[i + 1] = sWeekdays[i];
        }
        this.ampms = resource.getStringArray("AmPmMarkers");
        this.localPatternChars = resource.getString("DateTimePatternChars");
        this.locale = desiredLocale;
    }

    final int getZoneIndex(String ID2) {
        String[][] zoneStrings = this.getZoneStringsWrapper();
        for (int index = 0; index < zoneStrings.length; ++index) {
            if (!ID2.equalsIgnoreCase(zoneStrings[index][0])) continue;
            return index;
        }
        return -1;
    }

    final String[][] getZoneStringsWrapper() {
        if (this.isSubclassObject()) {
            return this.getZoneStrings();
        }
        return this.getZoneStringsImpl(false);
    }

    private final String[][] getZoneStringsImpl(boolean needsCopy) {
        if (this.zoneStrings == null) {
            this.zoneStrings = TimeZoneNameUtility.getZoneStrings(this.locale);
        }
        if (needsCopy) {
            String[][] aCopy = new String[this.zoneStrings.length][];
            for (int i = 0; i < this.zoneStrings.length; ++i) {
                aCopy[i] = this.duplicate(this.zoneStrings[i]);
            }
            return aCopy;
        }
        return this.zoneStrings;
    }

    private final boolean isSubclassObject() {
        return !this.getClass().getName().equals("java.text.DateFormatSymbols");
    }

    private final String[] duplicate(String[] srcArray) {
        String[] dstArray = new String[srcArray.length];
        System.arraycopy(srcArray, 0, dstArray, 0, srcArray.length);
        return dstArray;
    }

    private final void copyMembers(DateFormatSymbols src, DateFormatSymbols dst) {
        dst.eras = this.duplicate(src.eras);
        dst.months = this.duplicate(src.months);
        dst.shortMonths = this.duplicate(src.shortMonths);
        dst.weekdays = this.duplicate(src.weekdays);
        dst.shortWeekdays = this.duplicate(src.shortWeekdays);
        dst.ampms = this.duplicate(src.ampms);
        if (src.zoneStrings != null) {
            if (dst.zoneStrings == null) {
                dst.zoneStrings = new String[src.zoneStrings.length][];
            }
            for (int i = 0; i < dst.zoneStrings.length; ++i) {
                dst.zoneStrings[i] = this.duplicate(src.zoneStrings[i]);
            }
        } else {
            dst.zoneStrings = null;
        }
        dst.localPatternChars = new String(src.localPatternChars);
    }

    private final boolean equals(String[] current, String[] other) {
        int count = current.length;
        for (int i = 0; i < count; ++i) {
            if (current[i].equals(other[i])) continue;
            return false;
        }
        return true;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        if (this.zoneStrings == null) {
            this.zoneStrings = TimeZoneNameUtility.getZoneStrings(this.locale);
        }
        stream.defaultWriteObject();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DateFormatSymbolsGetter
    implements LocaleServiceProviderPool.LocalizedObjectGetter<DateFormatSymbolsProvider, DateFormatSymbols> {
        private static final DateFormatSymbolsGetter INSTANCE = new DateFormatSymbolsGetter();

        private DateFormatSymbolsGetter() {
        }

        @Override
        public DateFormatSymbols getObject(DateFormatSymbolsProvider dateFormatSymbolsProvider, Locale locale, String key, Object ... params) {
            assert (params.length == 0);
            return dateFormatSymbolsProvider.getInstance(locale);
        }
    }
}

