/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import sun.misc.SharedSecrets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumMap<K extends Enum<K>, V>
extends AbstractMap<K, V>
implements Serializable,
Cloneable {
    private final Class<K> keyType;
    private transient K[] keyUniverse;
    private transient Object[] vals;
    private transient int size = 0;
    private static final Object NULL = new Object();
    private static Enum[] ZERO_LENGTH_ENUM_ARRAY = new Enum[0];
    private transient Set<Map.Entry<K, V>> entrySet = null;
    private static final long serialVersionUID = 458661240069192865L;

    private Object maskNull(Object value) {
        return value == null ? NULL : value;
    }

    private V unmaskNull(Object value) {
        return (V)(value == NULL ? null : value);
    }

    public EnumMap(Class<K> keyType) {
        this.keyType = keyType;
        this.keyUniverse = EnumMap.getKeyUniverse(keyType);
        this.vals = new Object[this.keyUniverse.length];
    }

    public EnumMap(EnumMap<K, ? extends V> m) {
        this.keyType = m.keyType;
        this.keyUniverse = m.keyUniverse;
        this.vals = (Object[])m.vals.clone();
        this.size = m.size;
    }

    public EnumMap(Map<K, ? extends V> m) {
        if (m instanceof EnumMap) {
            EnumMap em = (EnumMap)m;
            this.keyType = em.keyType;
            this.keyUniverse = em.keyUniverse;
            this.vals = (Object[])em.vals.clone();
            this.size = em.size;
        } else {
            if (m.isEmpty()) {
                throw new IllegalArgumentException("Specified map is empty");
            }
            this.keyType = ((Enum)m.keySet().iterator().next()).getDeclaringClass();
            this.keyUniverse = EnumMap.getKeyUniverse(this.keyType);
            this.vals = new Object[this.keyUniverse.length];
            this.putAll(m);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean containsValue(Object value) {
        value = this.maskNull(value);
        for (Object val : this.vals) {
            if (!value.equals(val)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.isValidKey(key) && this.vals[((Enum)key).ordinal()] != null;
    }

    private boolean containsMapping(Object key, Object value) {
        return this.isValidKey(key) && this.maskNull(value).equals(this.vals[((Enum)key).ordinal()]);
    }

    @Override
    public V get(Object key) {
        return this.isValidKey(key) ? (V)this.unmaskNull(this.vals[((Enum)key).ordinal()]) : null;
    }

    @Override
    public V put(K key, V value) {
        this.typeCheck(key);
        int index = ((Enum)key).ordinal();
        Object oldValue = this.vals[index];
        this.vals[index] = this.maskNull(value);
        if (oldValue == null) {
            ++this.size;
        }
        return this.unmaskNull(oldValue);
    }

    @Override
    public V remove(Object key) {
        if (!this.isValidKey(key)) {
            return null;
        }
        int index = ((Enum)key).ordinal();
        Object oldValue = this.vals[index];
        this.vals[index] = null;
        if (oldValue != null) {
            --this.size;
        }
        return this.unmaskNull(oldValue);
    }

    private boolean removeMapping(Object key, Object value) {
        if (!this.isValidKey(key)) {
            return false;
        }
        int index = ((Enum)key).ordinal();
        if (this.maskNull(value).equals(this.vals[index])) {
            this.vals[index] = null;
            --this.size;
            return true;
        }
        return false;
    }

    private boolean isValidKey(Object key) {
        if (key == null) {
            return false;
        }
        Class<?> keyClass = key.getClass();
        return keyClass == this.keyType || keyClass.getSuperclass() == this.keyType;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        if (m instanceof EnumMap) {
            EnumMap em = (EnumMap)m;
            if (em.keyType != this.keyType) {
                if (em.isEmpty()) {
                    return;
                }
                throw new ClassCastException(em.keyType + " != " + this.keyType);
            }
            for (int i = 0; i < this.keyUniverse.length; ++i) {
                Object emValue = em.vals[i];
                if (emValue == null) continue;
                if (this.vals[i] == null) {
                    ++this.size;
                }
                this.vals[i] = emValue;
            }
        } else {
            super.putAll(m);
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this.vals, null);
        this.size = 0;
    }

    @Override
    public Set<K> keySet() {
        Set ks = this.keySet;
        if (ks != null) {
            return ks;
        }
        this.keySet = new KeySet();
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        Collection vs = this.values;
        if (vs != null) {
            return vs;
        }
        this.values = new Values();
        return this.values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> es = this.entrySet;
        if (es != null) {
            return es;
        }
        this.entrySet = new EntrySet();
        return this.entrySet;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof EnumMap)) {
            return super.equals(o);
        }
        EnumMap em = (EnumMap)o;
        if (em.keyType != this.keyType) {
            return this.size == 0 && em.size == 0;
        }
        for (int i = 0; i < this.keyUniverse.length; ++i) {
            Object hisValue = em.vals[i];
            Object ourValue = this.vals[i];
            if (hisValue == ourValue || hisValue != null && hisValue.equals(ourValue)) continue;
            return false;
        }
        return true;
    }

    @Override
    public EnumMap<K, V> clone() {
        EnumMap result = null;
        try {
            result = (EnumMap)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
        result.vals = (Object[])result.vals.clone();
        return result;
    }

    private void typeCheck(K key) {
        Class<?> keyClass = key.getClass();
        if (keyClass != this.keyType && keyClass.getSuperclass() != this.keyType) {
            throw new ClassCastException(keyClass + " != " + this.keyType);
        }
    }

    private static <K extends Enum<K>> K[] getKeyUniverse(Class<K> keyType) {
        return SharedSecrets.getJavaLangAccess().getEnumConstantsShared(keyType);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.size);
        for (Map.Entry<K, V> e : this.entrySet()) {
            s.writeObject(e.getKey());
            s.writeObject(e.getValue());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.keyUniverse = EnumMap.getKeyUniverse(this.keyType);
        this.vals = new Object[this.keyUniverse.length];
        int size = s.readInt();
        for (int i = 0; i < size; ++i) {
            Enum key = (Enum)s.readObject();
            Object value = s.readObject();
            this.put((K)key, (V)value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    extends EnumMapIterator<Map.Entry<K, V>>
    implements Map.Entry<K, V> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturnedIndex = this.index++;
            return this;
        }

        @Override
        public K getKey() {
            this.checkLastReturnedIndexForEntryUse();
            return EnumMap.this.keyUniverse[this.lastReturnedIndex];
        }

        @Override
        public V getValue() {
            this.checkLastReturnedIndexForEntryUse();
            return EnumMap.this.unmaskNull(EnumMap.this.vals[this.lastReturnedIndex]);
        }

        @Override
        public V setValue(V value) {
            this.checkLastReturnedIndexForEntryUse();
            Object oldValue = EnumMap.this.unmaskNull(EnumMap.this.vals[this.lastReturnedIndex]);
            ((EnumMap)EnumMap.this).vals[this.lastReturnedIndex] = EnumMap.this.maskNull(value);
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (this.lastReturnedIndex < 0) {
                return o == this;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object ourValue = EnumMap.this.unmaskNull(EnumMap.this.vals[this.lastReturnedIndex]);
            Object hisValue = e.getValue();
            return e.getKey() == EnumMap.this.keyUniverse[this.lastReturnedIndex] && (ourValue == hisValue || ourValue != null && ourValue.equals(hisValue));
        }

        @Override
        public int hashCode() {
            if (this.lastReturnedIndex < 0) {
                return super.hashCode();
            }
            Object value = EnumMap.this.vals[this.lastReturnedIndex];
            return EnumMap.this.keyUniverse[this.lastReturnedIndex].hashCode() ^ (value == NULL ? 0 : value.hashCode());
        }

        public String toString() {
            if (this.lastReturnedIndex < 0) {
                return super.toString();
            }
            return EnumMap.this.keyUniverse[this.lastReturnedIndex] + "=" + EnumMap.this.unmaskNull(EnumMap.this.vals[this.lastReturnedIndex]);
        }

        private void checkLastReturnedIndexForEntryUse() {
            if (this.lastReturnedIndex < 0) {
                throw new IllegalStateException("Entry was removed");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValueIterator
    extends EnumMapIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturnedIndex = this.index++;
            return EnumMap.this.unmaskNull(EnumMap.this.vals[this.lastReturnedIndex]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyIterator
    extends EnumMapIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturnedIndex = this.index++;
            return EnumMap.this.keyUniverse[this.lastReturnedIndex];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class EnumMapIterator<T>
    implements Iterator<T> {
        int index = 0;
        int lastReturnedIndex = -1;

        private EnumMapIterator() {
        }

        @Override
        public boolean hasNext() {
            while (this.index < EnumMap.this.vals.length && EnumMap.this.vals[this.index] == null) {
                ++this.index;
            }
            return this.index != EnumMap.this.vals.length;
        }

        @Override
        public void remove() {
            this.checkLastReturnedIndex();
            if (EnumMap.this.vals[this.lastReturnedIndex] != null) {
                ((EnumMap)EnumMap.this).vals[this.lastReturnedIndex] = null;
                EnumMap.this.size--;
            }
            this.lastReturnedIndex = -1;
        }

        private void checkLastReturnedIndex() {
            if (this.lastReturnedIndex < 0) {
                throw new IllegalStateException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            return EnumMap.this.containsMapping(entry.getKey(), entry.getValue());
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            return EnumMap.this.removeMapping(entry.getKey(), entry.getValue());
        }

        @Override
        public int size() {
            return EnumMap.this.size;
        }

        @Override
        public void clear() {
            EnumMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            return this.fillEntryArray(new Object[EnumMap.this.size]);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            int size = this.size();
            if (a.length < size) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
            }
            if (a.length > size) {
                a[size] = null;
            }
            return this.fillEntryArray(a);
        }

        private Object[] fillEntryArray(Object[] a) {
            int j = 0;
            for (int i = 0; i < EnumMap.this.vals.length; ++i) {
                if (EnumMap.this.vals[i] == null) continue;
                a[j++] = new AbstractMap.SimpleEntry<Enum, Object>(EnumMap.this.keyUniverse[i], EnumMap.this.unmaskNull(EnumMap.this.vals[i]));
            }
            return a;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return EnumMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return EnumMap.this.containsValue(o);
        }

        @Override
        public boolean remove(Object o) {
            o = EnumMap.this.maskNull(o);
            for (int i = 0; i < EnumMap.this.vals.length; ++i) {
                if (!o.equals(EnumMap.this.vals[i])) continue;
                ((EnumMap)EnumMap.this).vals[i] = null;
                EnumMap.this.size--;
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            EnumMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return EnumMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return EnumMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            int oldSize = EnumMap.this.size;
            EnumMap.this.remove(o);
            return EnumMap.this.size != oldSize;
        }

        @Override
        public void clear() {
            EnumMap.this.clear();
        }
    }
}

