/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PriorityQueue<E>
extends AbstractQueue<E>
implements Serializable {
    private static final long serialVersionUID = -7720805057305804111L;
    private static final int DEFAULT_INITIAL_CAPACITY = 11;
    private transient Object[] queue;
    private int size = 0;
    private final Comparator<? super E> comparator;
    private transient int modCount = 0;

    public PriorityQueue() {
        this(11, null);
    }

    public PriorityQueue(int initialCapacity) {
        this(initialCapacity, null);
    }

    public PriorityQueue(int initialCapacity, Comparator<? super E> comparator) {
        if (initialCapacity < 1) {
            throw new IllegalArgumentException();
        }
        this.queue = new Object[initialCapacity];
        this.comparator = comparator;
    }

    public PriorityQueue(Collection<? extends E> c) {
        this.initFromCollection(c);
        if (c instanceof SortedSet) {
            this.comparator = ((SortedSet)c).comparator();
        } else if (c instanceof PriorityQueue) {
            this.comparator = ((PriorityQueue)c).comparator();
        } else {
            this.comparator = null;
            this.heapify();
        }
    }

    public PriorityQueue(PriorityQueue<? extends E> c) {
        this.comparator = c.comparator();
        this.initFromCollection(c);
    }

    public PriorityQueue(SortedSet<? extends E> c) {
        this.comparator = c.comparator();
        this.initFromCollection(c);
    }

    private void initFromCollection(Collection<? extends E> c) {
        Object[] a = c.toArray();
        if (a.getClass() != Object[].class) {
            a = Arrays.copyOf(a, a.length, Object[].class);
        }
        this.queue = a;
        this.size = a.length;
    }

    private void grow(int minCapacity) {
        int newCapacity;
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        int oldCapacity = this.queue.length;
        int n = newCapacity = oldCapacity < 64 ? (oldCapacity + 1) * 2 : oldCapacity / 2 * 3;
        if (newCapacity < 0) {
            newCapacity = Integer.MAX_VALUE;
        }
        if (newCapacity < minCapacity) {
            newCapacity = minCapacity;
        }
        this.queue = Arrays.copyOf(this.queue, newCapacity);
    }

    @Override
    public boolean add(E e) {
        return this.offer(e);
    }

    @Override
    public boolean offer(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        ++this.modCount;
        int i = this.size;
        if (i >= this.queue.length) {
            this.grow(i + 1);
        }
        this.size = i + 1;
        if (i == 0) {
            this.queue[0] = e;
        } else {
            this.siftUp(i, e);
        }
        return true;
    }

    @Override
    public E peek() {
        if (this.size == 0) {
            return null;
        }
        return (E)this.queue[0];
    }

    private int indexOf(Object o) {
        if (o != null) {
            for (int i = 0; i < this.size; ++i) {
                if (!o.equals(this.queue[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean remove(Object o) {
        int i = this.indexOf(o);
        if (i == -1) {
            return false;
        }
        this.removeAt(i);
        return true;
    }

    boolean removeEq(Object o) {
        for (int i = 0; i < this.size; ++i) {
            if (o != this.queue[i]) continue;
            this.removeAt(i);
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.queue, this.size);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.size) {
            return Arrays.copyOf(this.queue, this.size, a.getClass());
        }
        System.arraycopy(this.queue, 0, a, 0, this.size);
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        ++this.modCount;
        for (int i = 0; i < this.size; ++i) {
            this.queue[i] = null;
        }
        this.size = 0;
    }

    @Override
    public E poll() {
        if (this.size == 0) {
            return null;
        }
        int s = --this.size;
        ++this.modCount;
        Object result = this.queue[0];
        Object x = this.queue[s];
        this.queue[s] = null;
        if (s != 0) {
            this.siftDown(0, x);
        }
        return (E)result;
    }

    private E removeAt(int i) {
        int s;
        assert (i >= 0 && i < this.size);
        ++this.modCount;
        if ((s = --this.size) == i) {
            this.queue[i] = null;
        } else {
            Object moved = this.queue[s];
            this.queue[s] = null;
            this.siftDown(i, moved);
            if (this.queue[i] == moved) {
                this.siftUp(i, moved);
                if (this.queue[i] != moved) {
                    return (E)moved;
                }
            }
        }
        return null;
    }

    private void siftUp(int k, E x) {
        if (this.comparator != null) {
            this.siftUpUsingComparator(k, x);
        } else {
            this.siftUpComparable(k, x);
        }
    }

    private void siftUpComparable(int k, E x) {
        int parent;
        Object e;
        Comparable key = (Comparable)x;
        while (k > 0 && key.compareTo(e = this.queue[parent = k - 1 >>> 1]) < 0) {
            this.queue[k] = e;
            k = parent;
        }
        this.queue[k] = key;
    }

    private void siftUpUsingComparator(int k, E x) {
        int parent;
        Object e;
        while (k > 0 && this.comparator.compare(x, e = this.queue[parent = k - 1 >>> 1]) < 0) {
            this.queue[k] = e;
            k = parent;
        }
        this.queue[k] = x;
    }

    private void siftDown(int k, E x) {
        if (this.comparator != null) {
            this.siftDownUsingComparator(k, x);
        } else {
            this.siftDownComparable(k, x);
        }
    }

    private void siftDownComparable(int k, E x) {
        Comparable key = (Comparable)x;
        int half = this.size >>> 1;
        while (k < half) {
            int child = (k << 1) + 1;
            Object c = this.queue[child];
            int right = child + 1;
            if (right < this.size && ((Comparable)c).compareTo(this.queue[right]) > 0) {
                child = right;
                c = this.queue[child];
            }
            if (key.compareTo(c) <= 0) break;
            this.queue[k] = c;
            k = child;
        }
        this.queue[k] = key;
    }

    private void siftDownUsingComparator(int k, E x) {
        int half = this.size >>> 1;
        while (k < half) {
            int child = (k << 1) + 1;
            Object c = this.queue[child];
            int right = child + 1;
            if (right < this.size && this.comparator.compare(c, this.queue[right]) > 0) {
                child = right;
                c = this.queue[child];
            }
            if (this.comparator.compare(x, c) <= 0) break;
            this.queue[k] = c;
            k = child;
        }
        this.queue[k] = x;
    }

    private void heapify() {
        for (int i = (this.size >>> 1) - 1; i >= 0; --i) {
            this.siftDown(i, this.queue[i]);
        }
    }

    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(Math.max(2, this.size + 1));
        for (int i = 0; i < this.size; ++i) {
            s.writeObject(this.queue[i]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        s.readInt();
        this.queue = new Object[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.queue[i] = s.readObject();
        }
        this.heapify();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Itr
    implements Iterator<E> {
        private int cursor = 0;
        private int lastRet = -1;
        private ArrayDeque<E> forgetMeNot = null;
        private E lastRetElt = null;
        private int expectedModCount = PriorityQueue.access$100(PriorityQueue.this);

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor < PriorityQueue.this.size || this.forgetMeNot != null && !this.forgetMeNot.isEmpty();
        }

        @Override
        public E next() {
            if (this.expectedModCount != PriorityQueue.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.cursor < PriorityQueue.this.size) {
                this.lastRet = this.cursor++;
                return PriorityQueue.this.queue[this.lastRet];
            }
            if (this.forgetMeNot != null) {
                this.lastRet = -1;
                this.lastRetElt = this.forgetMeNot.poll();
                if (this.lastRetElt != null) {
                    return this.lastRetElt;
                }
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.expectedModCount != PriorityQueue.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastRet != -1) {
                Object moved = PriorityQueue.this.removeAt(this.lastRet);
                this.lastRet = -1;
                if (moved == null) {
                    --this.cursor;
                } else {
                    if (this.forgetMeNot == null) {
                        this.forgetMeNot = new ArrayDeque();
                    }
                    this.forgetMeNot.add(moved);
                }
            } else if (this.lastRetElt != null) {
                PriorityQueue.this.removeEq(this.lastRetElt);
                this.lastRetElt = null;
            } else {
                throw new IllegalStateException();
            }
            this.expectedModCount = PriorityQueue.this.modCount;
        }
    }
}

