/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ServiceConfigurationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServiceLoader<S>
implements Iterable<S> {
    private static final String PREFIX = "META-INF/services/";
    private Class<S> service;
    private ClassLoader loader;
    private LinkedHashMap<String, S> providers = new LinkedHashMap();
    private LazyIterator lookupIterator;

    public void reload() {
        this.providers.clear();
        this.lookupIterator = new LazyIterator(this.service, this.loader);
    }

    private ServiceLoader(Class<S> svc, ClassLoader cl) {
        this.service = svc;
        this.loader = cl;
        this.reload();
    }

    private static void fail(Class service, String msg, Throwable cause) throws ServiceConfigurationError {
        throw new ServiceConfigurationError(service.getName() + ": " + msg, cause);
    }

    private static void fail(Class service, String msg) throws ServiceConfigurationError {
        throw new ServiceConfigurationError(service.getName() + ": " + msg);
    }

    private static void fail(Class service, URL u, int line, String msg) throws ServiceConfigurationError {
        ServiceLoader.fail(service, u + ":" + line + ": " + msg);
    }

    private int parseLine(Class service, URL u, BufferedReader r, int lc, List<String> names) throws IOException, ServiceConfigurationError {
        int n;
        String ln = r.readLine();
        if (ln == null) {
            return -1;
        }
        int ci = ln.indexOf(35);
        if (ci >= 0) {
            ln = ln.substring(0, ci);
        }
        if ((n = (ln = ln.trim()).length()) != 0) {
            int cp;
            if (ln.indexOf(32) >= 0 || ln.indexOf(9) >= 0) {
                ServiceLoader.fail(service, u, lc, "Illegal configuration-file syntax");
            }
            if (!Character.isJavaIdentifierStart(cp = ln.codePointAt(0))) {
                ServiceLoader.fail(service, u, lc, "Illegal provider-class name: " + ln);
            }
            for (int i = Character.charCount(cp); i < n; i += Character.charCount(cp)) {
                cp = ln.codePointAt(i);
                if (Character.isJavaIdentifierPart(cp) || cp == 46) continue;
                ServiceLoader.fail(service, u, lc, "Illegal provider-class name: " + ln);
            }
            if (!this.providers.containsKey(ln) && !names.contains(ln)) {
                names.add(ln);
            }
        }
        return lc + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Iterator<String> parse(Class service, URL u) throws ServiceConfigurationError {
        ArrayList<String> names;
        block15: {
            InputStream in = null;
            BufferedReader r = null;
            names = new ArrayList<String>();
            in = u.openStream();
            r = new BufferedReader(new InputStreamReader(in, "utf-8"));
            int lc = 1;
            while ((lc = this.parseLine(service, u, r, lc, names)) >= 0) {
            }
            Object var8_8 = null;
            try {
                if (r != null) {
                    r.close();
                }
                if (in != null) {
                    in.close();
                }
                break block15;
            }
            catch (IOException y) {
                ServiceLoader.fail(service, "Error closing configuration file", y);
            }
            break block15;
            {
                catch (IOException x) {
                    ServiceLoader.fail(service, "Error reading configuration file", x);
                    Object var8_9 = null;
                    try {
                        if (r != null) {
                            r.close();
                        }
                        if (in != null) {
                            in.close();
                        }
                        break block15;
                    }
                    catch (IOException y) {
                        ServiceLoader.fail(service, "Error closing configuration file", y);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    if (r != null) {
                        r.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException y) {
                    ServiceLoader.fail(service, "Error closing configuration file", y);
                }
                throw throwable;
            }
        }
        return names.iterator();
    }

    @Override
    public Iterator<S> iterator() {
        return new Iterator<S>(){
            Iterator<Map.Entry<String, S>> knownProviders;
            {
                this.knownProviders = ServiceLoader.this.providers.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.knownProviders.hasNext()) {
                    return true;
                }
                return ServiceLoader.this.lookupIterator.hasNext();
            }

            @Override
            public S next() {
                if (this.knownProviders.hasNext()) {
                    return this.knownProviders.next().getValue();
                }
                return ServiceLoader.this.lookupIterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <S> ServiceLoader<S> load(Class<S> service, ClassLoader loader) {
        return new ServiceLoader<S>(service, loader);
    }

    public static <S> ServiceLoader<S> load(Class<S> service) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return ServiceLoader.load(service, cl);
    }

    public static <S> ServiceLoader<S> loadInstalled(Class<S> service) {
        ClassLoader prev = null;
        for (ClassLoader cl = ClassLoader.getSystemClassLoader(); cl != null; cl = cl.getParent()) {
            prev = cl;
        }
        return ServiceLoader.load(service, prev);
    }

    public String toString() {
        return "java.util.ServiceLoader[" + this.service.getName() + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LazyIterator
    implements Iterator<S> {
        Class<S> service;
        ClassLoader loader;
        Enumeration<URL> configs = null;
        Iterator<String> pending = null;
        String nextName = null;

        private LazyIterator(Class<S> service, ClassLoader loader) {
            this.service = service;
            this.loader = loader;
        }

        @Override
        public boolean hasNext() {
            if (this.nextName != null) {
                return true;
            }
            if (this.configs == null) {
                try {
                    String fullName = ServiceLoader.PREFIX + this.service.getName();
                    this.configs = this.loader == null ? ClassLoader.getSystemResources(fullName) : this.loader.getResources(fullName);
                }
                catch (IOException x) {
                    ServiceLoader.fail(this.service, "Error locating configuration files", x);
                }
            }
            while (this.pending == null || !this.pending.hasNext()) {
                if (!this.configs.hasMoreElements()) {
                    return false;
                }
                this.pending = ServiceLoader.this.parse(this.service, this.configs.nextElement());
            }
            this.nextName = this.pending.next();
            return true;
        }

        @Override
        public S next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String cn = this.nextName;
            this.nextName = null;
            try {
                Object p = this.service.cast(Class.forName(cn, true, this.loader).newInstance());
                ServiceLoader.this.providers.put(cn, p);
                return p;
            }
            catch (ClassNotFoundException x) {
                ServiceLoader.fail(this.service, "Provider " + cn + " not found");
            }
            catch (Throwable x) {
                ServiceLoader.fail(this.service, "Provider " + cn + " could not be instantiated: " + x, x);
            }
            throw new Error();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

