/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyPermission;
import java.util.concurrent.ConcurrentHashMap;
import sun.misc.JavaAWTAccess;
import sun.misc.SharedSecrets;
import sun.security.action.GetPropertyAction;
import sun.util.TimeZoneNameUtility;
import sun.util.calendar.ZoneInfo;
import sun.util.calendar.ZoneInfoFile;

public abstract class TimeZone
implements Serializable,
Cloneable {
    public static final int SHORT = 0;
    public static final int LONG = 1;
    private static final int ONE_MINUTE = 60000;
    private static final int ONE_HOUR = 3600000;
    private static final int ONE_DAY = 86400000;
    private static Hashtable cachedLocaleData = new Hashtable(3);
    static final long serialVersionUID = 3581463369166924961L;
    static final TimeZone NO_TIMEZONE = null;
    private String ID;
    private static volatile TimeZone defaultTimeZone;
    static final String GMT_ID = "GMT";
    private static final int GMT_ID_LENGTH = 3;
    private static JavaAWTAccess javaAWTAccess;
    private static TimeZone mainAppContextDefault;

    public abstract int getOffset(int var1, int var2, int var3, int var4, int var5, int var6);

    public int getOffset(long date) {
        if (this.inDaylightTime(new Date(date))) {
            return this.getRawOffset() + this.getDSTSavings();
        }
        return this.getRawOffset();
    }

    int getOffsets(long date, int[] offsets) {
        int rawoffset = this.getRawOffset();
        int dstoffset = 0;
        if (this.inDaylightTime(new Date(date))) {
            dstoffset = this.getDSTSavings();
        }
        if (offsets != null) {
            offsets[0] = rawoffset;
            offsets[1] = dstoffset;
        }
        return rawoffset + dstoffset;
    }

    public abstract void setRawOffset(int var1);

    public abstract int getRawOffset();

    public String getID() {
        return this.ID;
    }

    public void setID(String ID2) {
        if (ID2 == null) {
            throw new NullPointerException();
        }
        this.ID = ID2;
    }

    public final String getDisplayName() {
        return this.getDisplayName(false, 1, Locale.getDefault());
    }

    public final String getDisplayName(Locale locale) {
        return this.getDisplayName(false, 1, locale);
    }

    public final String getDisplayName(boolean daylight, int style) {
        return this.getDisplayName(daylight, style, Locale.getDefault());
    }

    public String getDisplayName(boolean daylight, int style, Locale locale) {
        int index;
        if (style != 0 && style != 1) {
            throw new IllegalArgumentException("Illegal style: " + style);
        }
        String id = this.getID();
        String[] names = TimeZone.getDisplayNames(id, locale);
        if (names == null) {
            char sign;
            if (id.startsWith(GMT_ID) && ((sign = id.charAt(3)) == '+' || sign == '-')) {
                return id;
            }
            int offset = this.getRawOffset();
            if (daylight) {
                offset += this.getDSTSavings();
            }
            return ZoneInfoFile.toCustomID(offset);
        }
        int n = index = daylight ? 3 : 1;
        if (style == 0) {
            ++index;
        }
        return names[index];
    }

    private static final String[] getDisplayNames(String id, Locale locale) {
        Map perLocale;
        Map displayNames = DisplayNames.CACHE;
        SoftReference ref = (SoftReference)displayNames.get(id);
        if (ref != null && (perLocale = (Map)ref.get()) != null) {
            String[] names = (String[])perLocale.get(locale);
            if (names != null) {
                return names;
            }
            names = TimeZoneNameUtility.retrieveDisplayNames(id, locale);
            if (names != null) {
                perLocale.put(locale, names);
            }
            return names;
        }
        String[] names = TimeZoneNameUtility.retrieveDisplayNames(id, locale);
        if (names != null) {
            ConcurrentHashMap<Locale, String[]> perLocale2 = new ConcurrentHashMap<Locale, String[]>();
            perLocale2.put(locale, names);
            ref = new SoftReference(perLocale2);
            displayNames.put(id, ref);
        }
        return names;
    }

    public int getDSTSavings() {
        if (this.useDaylightTime()) {
            return 3600000;
        }
        return 0;
    }

    public abstract boolean useDaylightTime();

    public abstract boolean inDaylightTime(Date var1);

    public static synchronized TimeZone getTimeZone(String ID2) {
        return TimeZone.getTimeZone(ID2, true);
    }

    private static TimeZone getTimeZone(String ID2, boolean fallback) {
        TimeZone tz = ZoneInfo.getTimeZone(ID2);
        if (tz == null && (tz = TimeZone.parseCustomTimeZone(ID2)) == null && fallback) {
            tz = new ZoneInfo(GMT_ID, 0);
        }
        return tz;
    }

    public static synchronized String[] getAvailableIDs(int rawOffset) {
        return ZoneInfo.getAvailableIDs(rawOffset);
    }

    public static synchronized String[] getAvailableIDs() {
        return ZoneInfo.getAvailableIDs();
    }

    private static native String getSystemTimeZoneID(String var0, String var1);

    private static native String getSystemGMTOffsetID();

    public static TimeZone getDefault() {
        return (TimeZone)TimeZone.getDefaultRef().clone();
    }

    static TimeZone getDefaultRef() {
        TimeZone defaultZone = TimeZone.getDefaultInAppContext();
        if (defaultZone == null && (defaultZone = defaultTimeZone) == null) {
            defaultZone = TimeZone.setDefaultZone();
            assert (defaultZone != null);
        }
        return defaultZone;
    }

    private static synchronized TimeZone setDefaultZone() {
        TimeZone tz = null;
        String zoneID = AccessController.doPrivileged(new GetPropertyAction("user.timezone"));
        if (zoneID == null || zoneID.equals("")) {
            String country = AccessController.doPrivileged(new GetPropertyAction("user.country"));
            String javaHome = AccessController.doPrivileged(new GetPropertyAction("java.home"));
            try {
                zoneID = TimeZone.getSystemTimeZoneID(javaHome, country);
                if (zoneID == null) {
                    zoneID = GMT_ID;
                }
            }
            catch (NullPointerException e) {
                zoneID = GMT_ID;
            }
        }
        if ((tz = TimeZone.getTimeZone(zoneID, false)) == null) {
            String gmtOffsetID = TimeZone.getSystemGMTOffsetID();
            if (gmtOffsetID != null) {
                zoneID = gmtOffsetID;
            }
            tz = TimeZone.getTimeZone(zoneID, true);
        }
        assert (tz != null);
        final String id = zoneID;
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                System.setProperty("user.timezone", id);
                return null;
            }
        });
        defaultTimeZone = tz;
        return tz;
    }

    private static boolean hasPermission() {
        boolean hasPermission = true;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(new PropertyPermission("user.timezone", "write"));
            }
            catch (SecurityException e) {
                hasPermission = false;
            }
        }
        return hasPermission;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefault(TimeZone zone) {
        if (TimeZone.hasPermission()) {
            Class<TimeZone> clazz = TimeZone.class;
            synchronized (TimeZone.class) {
                defaultTimeZone = zone;
                TimeZone.setDefaultInAppContext(null);
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        } else {
            TimeZone.setDefaultInAppContext(zone);
        }
    }

    private static synchronized TimeZone getDefaultInAppContext() {
        javaAWTAccess = SharedSecrets.getJavaAWTAccess();
        if (javaAWTAccess == null) {
            return mainAppContextDefault;
        }
        if (!javaAWTAccess.isDisposed()) {
            TimeZone tz = (TimeZone)javaAWTAccess.get(TimeZone.class);
            if (tz == null && javaAWTAccess.isMainAppContext()) {
                return mainAppContextDefault;
            }
            return tz;
        }
        return null;
    }

    private static synchronized void setDefaultInAppContext(TimeZone tz) {
        javaAWTAccess = SharedSecrets.getJavaAWTAccess();
        if (javaAWTAccess == null) {
            mainAppContextDefault = tz;
        } else if (!javaAWTAccess.isDisposed()) {
            javaAWTAccess.put(TimeZone.class, tz);
            if (javaAWTAccess.isMainAppContext()) {
                mainAppContextDefault = null;
            }
        }
    }

    public boolean hasSameRules(TimeZone other) {
        return other != null && this.getRawOffset() == other.getRawOffset() && this.useDaylightTime() == other.useDaylightTime();
    }

    public Object clone() {
        try {
            TimeZone other = (TimeZone)super.clone();
            other.ID = this.ID;
            return other;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    private static final TimeZone parseCustomTimeZone(String id) {
        char c;
        int length = id.length();
        if (length < 5 || id.indexOf(GMT_ID) != 0) {
            return null;
        }
        ZoneInfo zi = ZoneInfoFile.getZoneInfo(id);
        if (zi != null) {
            return zi;
        }
        int index = 3;
        boolean negative = false;
        if ((c = id.charAt(index++)) == '-') {
            negative = true;
        } else if (c != '+') {
            return null;
        }
        int hours = 0;
        int num = 0;
        int countDelim = 0;
        int len = 0;
        while (index < length) {
            if ((c = id.charAt(index++)) == ':') {
                if (countDelim > 0) {
                    return null;
                }
                if (len > 2) {
                    return null;
                }
                hours = num;
                ++countDelim;
                num = 0;
                len = 0;
                continue;
            }
            if (c < '0' || c > '9') {
                return null;
            }
            num = num * 10 + (c - 48);
            ++len;
        }
        if (index != length) {
            return null;
        }
        if (countDelim == 0) {
            if (len <= 2) {
                hours = num;
                num = 0;
            } else {
                hours = num / 100;
                num %= 100;
            }
        } else if (len != 2) {
            return null;
        }
        if (hours > 23 || num > 59) {
            return null;
        }
        int gmtOffset = (hours * 60 + num) * 60 * 1000;
        if (gmtOffset == 0) {
            zi = ZoneInfoFile.getZoneInfo(GMT_ID);
            if (negative) {
                zi.setID("GMT-00:00");
            } else {
                zi.setID("GMT+00:00");
            }
        } else {
            zi = ZoneInfoFile.getCustomTimeZone(id, negative ? -gmtOffset : gmtOffset);
        }
        return zi;
    }

    private static class DisplayNames {
        private static final Map<String, SoftReference<Map<Locale, String[]>>> CACHE = new ConcurrentHashMap<String, SoftReference<Map<Locale, String[]>>>();

        private DisplayNames() {
        }
    }
}

