/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;

public class ConsoleHandler
extends StreamHandler {
    private void configure() {
        LogManager manager = LogManager.getLogManager();
        String cname = this.getClass().getName();
        this.setLevel(manager.getLevelProperty(cname + ".level", Level.INFO));
        this.setFilter(manager.getFilterProperty(cname + ".filter", null));
        this.setFormatter(manager.getFormatterProperty(cname + ".formatter", new SimpleFormatter()));
        try {
            this.setEncoding(manager.getStringProperty(cname + ".encoding", null));
        }
        catch (Exception ex) {
            try {
                this.setEncoding(null);
            }
            catch (Exception ex2) {
                // empty catch block
            }
        }
    }

    public ConsoleHandler() {
        this.sealed = false;
        this.configure();
        this.setOutputStream(System.err);
        this.sealed = true;
    }

    public void publish(LogRecord record) {
        super.publish(record);
        this.flush();
    }

    public void close() {
        this.flush();
    }
}

