/*
 * Decompiled with CFR 0.152.
 */
package java.util.regex;

import java.util.regex.MatchResult;
import java.util.regex.Pattern;

public final class Matcher
implements MatchResult {
    Pattern parentPattern;
    int[] groups;
    int from;
    int to;
    int lookbehindTo;
    CharSequence text;
    static final int ENDANCHOR = 1;
    static final int NOANCHOR = 0;
    int acceptMode = 0;
    int first = -1;
    int last = 0;
    int oldLast = -1;
    int lastAppendPosition = 0;
    int[] locals;
    boolean hitEnd;
    boolean requireEnd;
    boolean transparentBounds = false;
    boolean anchoringBounds = true;

    Matcher() {
    }

    Matcher(Pattern parent, CharSequence text) {
        this.parentPattern = parent;
        this.text = text;
        int parentGroupCount = Math.max(parent.capturingGroupCount, 10);
        this.groups = new int[parentGroupCount * 2];
        this.locals = new int[parent.localCount];
        this.reset();
    }

    public Pattern pattern() {
        return this.parentPattern;
    }

    public MatchResult toMatchResult() {
        Matcher result = new Matcher(this.parentPattern, ((Object)this.text).toString());
        result.first = this.first;
        result.last = this.last;
        result.groups = (int[])this.groups.clone();
        return result;
    }

    public Matcher usePattern(Pattern newPattern) {
        int i;
        if (newPattern == null) {
            throw new IllegalArgumentException("Pattern cannot be null");
        }
        this.parentPattern = newPattern;
        int parentGroupCount = Math.max(newPattern.capturingGroupCount, 10);
        this.groups = new int[parentGroupCount * 2];
        this.locals = new int[newPattern.localCount];
        for (i = 0; i < this.groups.length; ++i) {
            this.groups[i] = -1;
        }
        for (i = 0; i < this.locals.length; ++i) {
            this.locals[i] = -1;
        }
        return this;
    }

    public Matcher reset() {
        int i;
        this.first = -1;
        this.last = 0;
        this.oldLast = -1;
        for (i = 0; i < this.groups.length; ++i) {
            this.groups[i] = -1;
        }
        for (i = 0; i < this.locals.length; ++i) {
            this.locals[i] = -1;
        }
        this.lastAppendPosition = 0;
        this.from = 0;
        this.to = this.getTextLength();
        return this;
    }

    public Matcher reset(CharSequence input) {
        this.text = input;
        return this.reset();
    }

    public int start() {
        if (this.first < 0) {
            throw new IllegalStateException("No match available");
        }
        return this.first;
    }

    public int start(int group) {
        if (this.first < 0) {
            throw new IllegalStateException("No match available");
        }
        if (group > this.groupCount()) {
            throw new IndexOutOfBoundsException("No group " + group);
        }
        return this.groups[group * 2];
    }

    public int end() {
        if (this.first < 0) {
            throw new IllegalStateException("No match available");
        }
        return this.last;
    }

    public int end(int group) {
        if (this.first < 0) {
            throw new IllegalStateException("No match available");
        }
        if (group > this.groupCount()) {
            throw new IndexOutOfBoundsException("No group " + group);
        }
        return this.groups[group * 2 + 1];
    }

    public String group() {
        return this.group(0);
    }

    public String group(int group) {
        if (this.first < 0) {
            throw new IllegalStateException("No match found");
        }
        if (group < 0 || group > this.groupCount()) {
            throw new IndexOutOfBoundsException("No group " + group);
        }
        if (this.groups[group * 2] == -1 || this.groups[group * 2 + 1] == -1) {
            return null;
        }
        return ((Object)this.getSubSequence(this.groups[group * 2], this.groups[group * 2 + 1])).toString();
    }

    public int groupCount() {
        return this.parentPattern.capturingGroupCount - 1;
    }

    public boolean matches() {
        return this.match(this.from, 1);
    }

    public boolean find() {
        int nextSearchIndex = this.last;
        if (nextSearchIndex == this.first) {
            ++nextSearchIndex;
        }
        if (nextSearchIndex < this.from) {
            nextSearchIndex = this.from;
        }
        if (nextSearchIndex > this.to) {
            for (int i = 0; i < this.groups.length; ++i) {
                this.groups[i] = -1;
            }
            return false;
        }
        return this.search(nextSearchIndex);
    }

    public boolean find(int start) {
        int limit = this.getTextLength();
        if (start < 0 || start > limit) {
            throw new IndexOutOfBoundsException("Illegal start index");
        }
        this.reset();
        return this.search(start);
    }

    public boolean lookingAt() {
        return this.match(this.from, 0);
    }

    public static String quoteReplacement(String s) {
        if (s.indexOf(92) == -1 && s.indexOf(36) == -1) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '$') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public Matcher appendReplacement(StringBuffer sb, String replacement) {
        if (this.first < 0) {
            throw new IllegalStateException("No match available");
        }
        int cursor = 0;
        StringBuilder result = new StringBuilder();
        while (cursor < replacement.length()) {
            char nextChar = replacement.charAt(cursor);
            if (nextChar == '\\') {
                nextChar = replacement.charAt(++cursor);
                result.append(nextChar);
                ++cursor;
                continue;
            }
            if (nextChar == '$') {
                int nextDigit;
                int refNum;
                if ((refNum = replacement.charAt(++cursor) - 48) < 0 || refNum > 9) {
                    throw new IllegalArgumentException("Illegal group reference");
                }
                ++cursor;
                boolean done = false;
                while (!done && cursor < replacement.length() && (nextDigit = replacement.charAt(cursor) - 48) >= 0 && nextDigit <= 9) {
                    int newRefNum = refNum * 10 + nextDigit;
                    if (this.groupCount() < newRefNum) {
                        done = true;
                        continue;
                    }
                    refNum = newRefNum;
                    ++cursor;
                }
                if (this.start(refNum) == -1 || this.end(refNum) == -1) continue;
                result.append(this.text, this.start(refNum), this.end(refNum));
                continue;
            }
            result.append(nextChar);
            ++cursor;
        }
        sb.append(this.text, this.lastAppendPosition, this.first);
        sb.append(result);
        this.lastAppendPosition = this.last;
        return this;
    }

    public StringBuffer appendTail(StringBuffer sb) {
        sb.append(this.text, this.lastAppendPosition, this.getTextLength());
        return sb;
    }

    public String replaceAll(String replacement) {
        this.reset();
        boolean result = this.find();
        if (result) {
            StringBuffer sb = new StringBuffer();
            do {
                this.appendReplacement(sb, replacement);
            } while (result = this.find());
            this.appendTail(sb);
            return sb.toString();
        }
        return ((Object)this.text).toString();
    }

    public String replaceFirst(String replacement) {
        if (replacement == null) {
            throw new NullPointerException("replacement");
        }
        this.reset();
        if (!this.find()) {
            return ((Object)this.text).toString();
        }
        StringBuffer sb = new StringBuffer();
        this.appendReplacement(sb, replacement);
        this.appendTail(sb);
        return sb.toString();
    }

    public Matcher region(int start, int end) {
        if (start < 0 || start > this.getTextLength()) {
            throw new IndexOutOfBoundsException("start");
        }
        if (end < 0 || end > this.getTextLength()) {
            throw new IndexOutOfBoundsException("end");
        }
        if (start > end) {
            throw new IndexOutOfBoundsException("start > end");
        }
        this.reset();
        this.from = start;
        this.to = end;
        return this;
    }

    public int regionStart() {
        return this.from;
    }

    public int regionEnd() {
        return this.to;
    }

    public boolean hasTransparentBounds() {
        return this.transparentBounds;
    }

    public Matcher useTransparentBounds(boolean b) {
        this.transparentBounds = b;
        return this;
    }

    public boolean hasAnchoringBounds() {
        return this.anchoringBounds;
    }

    public Matcher useAnchoringBounds(boolean b) {
        this.anchoringBounds = b;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("java.util.regex.Matcher");
        sb.append("[pattern=" + this.pattern());
        sb.append(" region=");
        sb.append(this.regionStart() + "," + this.regionEnd());
        sb.append(" lastmatch=");
        if (this.first >= 0 && this.group() != null) {
            sb.append(this.group());
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean hitEnd() {
        return this.hitEnd;
    }

    public boolean requireEnd() {
        return this.requireEnd;
    }

    boolean search(int from) {
        this.hitEnd = false;
        this.requireEnd = false;
        this.first = from = from < 0 ? 0 : from;
        this.oldLast = this.oldLast < 0 ? from : this.oldLast;
        for (int i = 0; i < this.groups.length; ++i) {
            this.groups[i] = -1;
        }
        this.acceptMode = 0;
        boolean result = this.parentPattern.root.match(this, from, this.text);
        if (!result) {
            this.first = -1;
        }
        this.oldLast = this.last;
        return result;
    }

    boolean match(int from, int anchor) {
        this.hitEnd = false;
        this.requireEnd = false;
        this.first = from = from < 0 ? 0 : from;
        this.oldLast = this.oldLast < 0 ? from : this.oldLast;
        for (int i = 0; i < this.groups.length; ++i) {
            this.groups[i] = -1;
        }
        this.acceptMode = anchor;
        boolean result = this.parentPattern.matchRoot.match(this, from, this.text);
        if (!result) {
            this.first = -1;
        }
        this.oldLast = this.last;
        return result;
    }

    int getTextLength() {
        return this.text.length();
    }

    CharSequence getSubSequence(int beginIndex, int endIndex) {
        return this.text.subSequence(beginIndex, endIndex);
    }

    char charAt(int i) {
        return this.text.charAt(i);
    }
}

