/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.InvalidApplicationException;
import javax.management.NumericValueExp;
import javax.management.ObjectName;
import javax.management.QueryEval;
import javax.management.QueryExp;
import javax.management.StringValueExp;
import javax.management.ValueExp;

class BetweenQueryExp
extends QueryEval
implements QueryExp {
    private static final long serialVersionUID = -2933597532866307444L;
    private ValueExp exp1;
    private ValueExp exp2;
    private ValueExp exp3;

    public BetweenQueryExp() {
    }

    public BetweenQueryExp(ValueExp v1, ValueExp v2, ValueExp v3) {
        this.exp1 = v1;
        this.exp2 = v2;
        this.exp3 = v3;
    }

    public ValueExp getCheckedValue() {
        return this.exp1;
    }

    public ValueExp getLowerBound() {
        return this.exp2;
    }

    public ValueExp getUpperBound() {
        return this.exp3;
    }

    public boolean apply(ObjectName name) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        ValueExp val1 = this.exp1.apply(name);
        ValueExp val2 = this.exp2.apply(name);
        ValueExp val3 = this.exp3.apply(name);
        boolean numeric = val1 instanceof NumericValueExp;
        if (numeric) {
            if (((NumericValueExp)val1).isLong()) {
                long lval1 = ((NumericValueExp)val1).longValue();
                long lval2 = ((NumericValueExp)val2).longValue();
                long lval3 = ((NumericValueExp)val3).longValue();
                return lval2 <= lval1 && lval1 <= lval3;
            }
            double dval1 = ((NumericValueExp)val1).doubleValue();
            double dval2 = ((NumericValueExp)val2).doubleValue();
            double dval3 = ((NumericValueExp)val3).doubleValue();
            return dval2 <= dval1 && dval1 <= dval3;
        }
        String sval1 = ((StringValueExp)val1).toString();
        String sval2 = ((StringValueExp)val2).toString();
        String sval3 = ((StringValueExp)val3).toString();
        return sval2.compareTo(sval1) <= 0 && sval1.compareTo(sval3) <= 0;
    }

    public String toString() {
        return "(" + this.exp1 + ") between (" + this.exp2 + ") and (" + this.exp3 + ")";
    }
}

