/*
 * Decompiled with CFR 0.152.
 */
package javax.management.loading;

import com.sun.jmx.defaults.JmxProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.management.loading.MLetContent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MLetParser {
    private int c;
    private static String tag = "mlet";

    public void skipSpace(Reader in) throws IOException {
        while (this.c >= 0 && (this.c == 32 || this.c == 9 || this.c == 10 || this.c == 13)) {
            this.c = in.read();
        }
    }

    public String scanIdentifier(Reader in) throws IOException {
        StringBuilder buf = new StringBuilder();
        while (this.c >= 97 && this.c <= 122 || this.c >= 65 && this.c <= 90 || this.c >= 48 && this.c <= 57 || this.c == 95) {
            buf.append((char)this.c);
            this.c = in.read();
        }
        return buf.toString();
    }

    public Map<String, String> scanTag(Reader in) throws IOException {
        HashMap<String, String> atts = new HashMap<String, String>();
        this.skipSpace(in);
        while (this.c >= 0 && this.c != 62) {
            if (this.c == 60) {
                throw new IOException("Missing '>' in tag");
            }
            String att = this.scanIdentifier(in);
            String val = "";
            this.skipSpace(in);
            if (this.c == 61) {
                int quote = -1;
                this.c = in.read();
                this.skipSpace(in);
                if (this.c == 39 || this.c == 34) {
                    quote = this.c;
                    this.c = in.read();
                }
                StringBuilder buf = new StringBuilder();
                while (this.c > 0 && (quote < 0 && this.c != 32 && this.c != 9 && this.c != 10 && this.c != 13 && this.c != 62 || quote >= 0 && this.c != quote)) {
                    buf.append((char)this.c);
                    this.c = in.read();
                }
                if (this.c == quote) {
                    this.c = in.read();
                }
                this.skipSpace(in);
                val = buf.toString();
            }
            atts.put(att.toLowerCase(), val);
            this.skipSpace(in);
        }
        return atts;
    }

    public List<MLetContent> parse(URL url) throws IOException {
        ArrayList<MLetContent> mlets;
        BufferedReader in;
        block10: {
            String mth = "parse";
            String requiresTypeWarning = "<arg type=... value=...> tag requires type parameter.";
            String requiresValueWarning = "<arg type=... value=...> tag requires value parameter.";
            String paramOutsideWarning = "<arg> tag outside <mlet> ... </mlet>.";
            String requiresCodeWarning = "<mlet> tag requires either code or object parameter.";
            String requiresJarsWarning = "<mlet> tag requires archive parameter.";
            URLConnection conn = url.openConnection();
            in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
            url = conn.getURL();
            mlets = new ArrayList<MLetContent>();
            Map<String, String> atts = null;
            ArrayList<String> types = new ArrayList<String>();
            ArrayList<String> values = new ArrayList<String>();
            while (true) {
                String nm;
                this.c = ((Reader)in).read();
                if (this.c == -1) break block10;
                if (this.c != 60) continue;
                this.c = ((Reader)in).read();
                if (this.c == 47) {
                    this.c = ((Reader)in).read();
                    nm = this.scanIdentifier(in);
                    if (this.c != 62) {
                        throw new IOException("Missing '>' in tag");
                    }
                    if (!nm.equalsIgnoreCase(tag)) continue;
                    if (atts != null) {
                        mlets.add(new MLetContent(url, atts, types, values));
                    }
                    atts = null;
                    types = new ArrayList();
                    values = new ArrayList();
                    continue;
                }
                nm = this.scanIdentifier(in);
                if (nm.equalsIgnoreCase("arg")) {
                    Map<String, String> t = this.scanTag(in);
                    String att = t.get("type");
                    if (att == null) {
                        JmxProperties.MLET_LOGGER.logp(Level.FINER, MLetParser.class.getName(), mth, requiresTypeWarning);
                        throw new IOException(requiresTypeWarning);
                    }
                    if (atts == null) {
                        JmxProperties.MLET_LOGGER.logp(Level.FINER, MLetParser.class.getName(), mth, paramOutsideWarning);
                        throw new IOException(paramOutsideWarning);
                    }
                    types.add(att);
                    String val = t.get("value");
                    if (val == null) {
                        JmxProperties.MLET_LOGGER.logp(Level.FINER, MLetParser.class.getName(), mth, requiresValueWarning);
                        throw new IOException(requiresValueWarning);
                    }
                    if (atts != null) {
                        values.add(val);
                        continue;
                    }
                    JmxProperties.MLET_LOGGER.logp(Level.FINER, MLetParser.class.getName(), mth, paramOutsideWarning);
                    throw new IOException(paramOutsideWarning);
                }
                if (!nm.equalsIgnoreCase(tag)) continue;
                atts = this.scanTag(in);
                if (atts.get("code") == null && atts.get("object") == null) {
                    JmxProperties.MLET_LOGGER.logp(Level.FINER, MLetParser.class.getName(), mth, requiresCodeWarning);
                    atts = null;
                    throw new IOException(requiresCodeWarning);
                }
                if (atts.get("archive") == null) break;
            }
            JmxProperties.MLET_LOGGER.logp(Level.FINER, MLetParser.class.getName(), mth, requiresJarsWarning);
            atts = null;
            throw new IOException(requiresJarsWarning);
        }
        ((Reader)in).close();
        return mlets;
    }

    public List<MLetContent> parseURL(String urlname) throws IOException {
        URL url = null;
        if (urlname.indexOf(58) <= 1) {
            String userDir = System.getProperty("user.dir");
            String prot = userDir.charAt(0) == '/' || userDir.charAt(0) == File.separatorChar ? "file:" : "file:/";
            url = new URL(prot + userDir.replace(File.separatorChar, '/') + "/");
            url = new URL(url, urlname);
        } else {
            url = new URL(urlname);
        }
        return this.parse(url);
    }
}

