/*
 * Decompiled with CFR 0.152.
 */
package javax.management.modelmbean;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.mbeanserver.GetPropertyAction;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.AccessController;
import java.util.logging.Level;
import javax.management.Descriptor;
import javax.management.DescriptorAccess;
import javax.management.MBeanNotificationInfo;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.DescriptorSupport;

public class ModelMBeanNotificationInfo
extends MBeanNotificationInfo
implements DescriptorAccess {
    private static final long oldSerialVersionUID = -5211564525059047097L;
    private static final long newSerialVersionUID = -7445681389570207141L;
    private static final ObjectStreamField[] oldSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("notificationDescriptor", Descriptor.class), new ObjectStreamField("currClass", String.class)};
    private static final ObjectStreamField[] newSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("notificationDescriptor", Descriptor.class)};
    private static final long serialVersionUID;
    private static final ObjectStreamField[] serialPersistentFields;
    private static boolean compat;
    private Descriptor notificationDescriptor;
    private static final String currClass = "ModelMBeanNotificationInfo";

    public ModelMBeanNotificationInfo(String[] notifTypes, String name, String description) {
        this(notifTypes, name, description, null);
    }

    public ModelMBeanNotificationInfo(String[] notifTypes, String name, String description, Descriptor descriptor) {
        super(notifTypes, name, description);
        String mth = currClass;
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanNotificationInfo.class.getName(), currClass, "Entry");
        }
        this.applyDescriptor(descriptor, currClass);
    }

    public ModelMBeanNotificationInfo(ModelMBeanNotificationInfo inInfo) {
        this(inInfo.getNotifTypes(), inInfo.getName(), inInfo.getDescription(), inInfo.getDescriptor());
    }

    public Object clone() {
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanNotificationInfo.class.getName(), "clone()", "Entry");
        }
        return new ModelMBeanNotificationInfo(this);
    }

    public Descriptor getDescriptor() {
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanNotificationInfo.class.getName(), "getDescriptor()", "Entry");
        }
        if (this.notificationDescriptor == null) {
            if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanNotificationInfo.class.getName(), "getDescriptor()", "Descriptor value is null, setting descriptor to default values");
            }
            this.notificationDescriptor = this.createDefaultDescriptor();
        }
        return (Descriptor)this.notificationDescriptor.clone();
    }

    public void setDescriptor(Descriptor inDescriptor) {
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanNotificationInfo.class.getName(), "setDescriptor(Descriptor)", "Entry");
        }
        this.applyDescriptor(inDescriptor, "setDescriptor(Descriptor)");
    }

    public String toString() {
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanNotificationInfo.class.getName(), "toString()", "Entry");
        }
        StringBuilder retStr = new StringBuilder();
        retStr.append("ModelMBeanNotificationInfo: ").append(this.getName());
        retStr.append(" ; Description: ").append(this.getDescription());
        retStr.append(" ; Descriptor: ").append(this.getDescriptor());
        retStr.append(" ; Types: ");
        String[] nTypes = this.getNotifTypes();
        for (int i = 0; i < nTypes.length; ++i) {
            if (i > 0) {
                retStr.append(", ");
            }
            retStr.append(nTypes[i]);
        }
        return retStr.toString();
    }

    private final Descriptor createDefaultDescriptor() {
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanNotificationInfo.class.getName(), "createDefaultDescriptor()", "Entry");
        }
        return new DescriptorSupport("descriptorType=notification", "name=" + this.getName(), "displayName=" + this.getName(), "severity=6");
    }

    private boolean isValid(Descriptor inDesc) {
        boolean results = true;
        String badField = "none";
        if (inDesc == null) {
            badField = "nullDescriptor";
            return false;
        }
        if (!inDesc.isValid()) {
            badField = "invalidDescriptor";
            results = false;
        } else if (!((String)inDesc.getFieldValue("name")).equalsIgnoreCase(this.getName())) {
            badField = "name";
            results = false;
        } else if (!((String)inDesc.getFieldValue("descriptorType")).equalsIgnoreCase("notification")) {
            badField = "descriptorType";
            results = false;
        }
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanNotificationInfo.class.getName(), "isValid(Descriptor)", "Returning " + results + " : Invalid field is " + badField);
        }
        return results;
    }

    private final Descriptor setDefaults(Descriptor descriptor) {
        if (descriptor.getFieldValue("displayName") == null) {
            descriptor.setField("displayName", this.getName());
        }
        if (descriptor.getFieldValue("severity") == null) {
            descriptor.setField("severity", "6");
        }
        return descriptor;
    }

    private final void applyDescriptor(Descriptor descriptor, String ftag) {
        if (descriptor == null) {
            if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanNotificationInfo.class.getName(), ftag, "Received null for new descriptor value, setting descriptor to default values");
            }
            this.notificationDescriptor = this.createDefaultDescriptor();
        } else if (this.isValid(descriptor)) {
            this.notificationDescriptor = this.setDefaults((Descriptor)descriptor.clone());
        } else {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid descriptor passed in parameter"), "Exception occurred in ModelMBeanNotificationInfo " + ftag);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (compat) {
            ObjectOutputStream.PutField fields = out.putFields();
            fields.put("notificationDescriptor", this.notificationDescriptor);
            fields.put("currClass", currClass);
            out.writeFields();
        } else {
            out.defaultWriteObject();
        }
    }

    static {
        compat = false;
        try {
            GetPropertyAction act = new GetPropertyAction("jmx.serial.form");
            String form = AccessController.doPrivileged(act);
            compat = form != null && form.equals("1.0");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (compat) {
            serialPersistentFields = oldSerialPersistentFields;
            serialVersionUID = -5211564525059047097L;
        } else {
            serialPersistentFields = newSerialPersistentFields;
            serialVersionUID = -7445681389570207141L;
        }
    }
}

