/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.util.Collections;
import java.util.Set;
import java.util.TreeMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeType
extends OpenType<CompositeData> {
    static final long serialVersionUID = -5366242454346948798L;
    private TreeMap<String, String> nameToDescription;
    private TreeMap<String, OpenType<?>> nameToType;
    private transient Integer myHashCode = null;
    private transient String myToString = null;
    private transient Set<String> myNamesSet = null;

    public CompositeType(String typeName, String description, String[] itemNames, String[] itemDescriptions, OpenType<?>[] itemTypes) throws OpenDataException {
        super(CompositeData.class.getName(), typeName, description, false);
        CompositeType.checkForNullElement(itemNames, "itemNames");
        CompositeType.checkForNullElement(itemDescriptions, "itemDescriptions");
        CompositeType.checkForNullElement(itemTypes, "itemTypes");
        CompositeType.checkForEmptyString(itemNames, "itemNames");
        CompositeType.checkForEmptyString(itemDescriptions, "itemDescriptions");
        if (itemNames.length != itemDescriptions.length || itemNames.length != itemTypes.length) {
            throw new IllegalArgumentException("Array arguments itemNames[], itemDescriptions[] and itemTypes[] should be of same length (got " + itemNames.length + ", " + itemDescriptions.length + " and " + itemTypes.length + ").");
        }
        this.nameToDescription = new TreeMap();
        this.nameToType = new TreeMap();
        for (int i = 0; i < itemNames.length; ++i) {
            String key = itemNames[i].trim();
            if (this.nameToDescription.containsKey(key)) {
                throw new OpenDataException("Argument's element itemNames[" + i + "]=\"" + itemNames[i] + "\" duplicates a previous item names.");
            }
            this.nameToDescription.put(key, itemDescriptions[i].trim());
            this.nameToType.put(key, itemTypes[i]);
        }
    }

    private static void checkForNullElement(Object[] arg, String argName) {
        if (arg == null || arg.length == 0) {
            throw new IllegalArgumentException("Argument " + argName + "[] cannot be null or empty.");
        }
        for (int i = 0; i < arg.length; ++i) {
            if (arg[i] != null) continue;
            throw new IllegalArgumentException("Argument's element " + argName + "[" + i + "] cannot be null.");
        }
    }

    private static void checkForEmptyString(String[] arg, String argName) {
        for (int i = 0; i < arg.length; ++i) {
            if (!arg[i].trim().equals("")) continue;
            throw new IllegalArgumentException("Argument's element " + argName + "[" + i + "] cannot be an empty string.");
        }
    }

    public boolean containsKey(String itemName) {
        if (itemName == null) {
            return false;
        }
        return this.nameToDescription.containsKey(itemName);
    }

    public String getDescription(String itemName) {
        if (itemName == null) {
            return null;
        }
        return this.nameToDescription.get(itemName);
    }

    public OpenType<?> getType(String itemName) {
        if (itemName == null) {
            return null;
        }
        return this.nameToType.get(itemName);
    }

    public Set<String> keySet() {
        if (this.myNamesSet == null) {
            this.myNamesSet = Collections.unmodifiableSet(this.nameToDescription.keySet());
        }
        return this.myNamesSet;
    }

    @Override
    public boolean isValue(Object obj) {
        if (!(obj instanceof CompositeData)) {
            return false;
        }
        CompositeData value = (CompositeData)obj;
        CompositeType valueType = value.getCompositeType();
        return this.isAssignableFrom((OpenType)valueType);
    }

    @Override
    boolean isAssignableFrom(OpenType ot) {
        if (!(ot instanceof CompositeType)) {
            return false;
        }
        CompositeType ct = (CompositeType)ot;
        if (!ct.getTypeName().equals(this.getTypeName())) {
            return false;
        }
        for (String key : this.keySet()) {
            OpenType<?> otItemType = ct.getType(key);
            OpenType<?> thisItemType = this.getType(key);
            if (otItemType != null && thisItemType.isAssignableFrom(otItemType)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        CompositeType other;
        if (obj == null) {
            return false;
        }
        try {
            other = (CompositeType)obj;
        }
        catch (ClassCastException e) {
            return false;
        }
        if (!this.getTypeName().equals(other.getTypeName())) {
            return false;
        }
        return this.nameToType.equals(other.nameToType);
    }

    @Override
    public int hashCode() {
        if (this.myHashCode == null) {
            int value = 0;
            value += this.getTypeName().hashCode();
            for (String key : this.nameToDescription.keySet()) {
                value += key.hashCode();
                value += this.nameToType.get(key).hashCode();
            }
            this.myHashCode = new Integer(value);
        }
        return this.myHashCode;
    }

    @Override
    public String toString() {
        if (this.myToString == null) {
            StringBuilder result = new StringBuilder();
            result.append(this.getClass().getName());
            result.append("(name=");
            result.append(this.getTypeName());
            result.append(",items=(");
            int i = 0;
            for (String key : this.nameToType.keySet()) {
                if (i > 0) {
                    result.append(",");
                }
                result.append("(itemName=");
                result.append(key);
                result.append(",itemType=");
                result.append(this.nameToType.get(key).toString() + ")");
                ++i;
            }
            result.append("))");
            this.myToString = result.toString();
        }
        return this.myToString;
    }
}

