/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote;

import com.sun.jmx.mbeanserver.Util;
import com.sun.jmx.remote.util.ClassLogger;
import com.sun.jmx.remote.util.EnvHelp;
import java.io.IOException;
import java.net.MalformedURLException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.StringTokenizer;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorProvider;
import javax.management.remote.JMXProviderException;
import javax.management.remote.JMXServiceURL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMXConnectorFactory {
    public static final String DEFAULT_CLASS_LOADER = "jmx.remote.default.class.loader";
    public static final String PROTOCOL_PROVIDER_PACKAGES = "jmx.remote.protocol.provider.pkgs";
    public static final String PROTOCOL_PROVIDER_CLASS_LOADER = "jmx.remote.protocol.provider.class.loader";
    private static final String PROTOCOL_PROVIDER_DEFAULT_PACKAGE = "com.sun.jmx.remote.protocol";
    private static final ClassLogger logger = new ClassLogger("javax.management.remote.misc", "JMXConnectorFactory");

    private JMXConnectorFactory() {
    }

    public static JMXConnector connect(JMXServiceURL serviceURL) throws IOException {
        return JMXConnectorFactory.connect(serviceURL, null);
    }

    public static JMXConnector connect(JMXServiceURL serviceURL, Map<String, ?> environment) throws IOException {
        if (serviceURL == null) {
            throw new NullPointerException("Null JMXServiceURL");
        }
        JMXConnector conn = JMXConnectorFactory.newJMXConnector(serviceURL, environment);
        conn.connect(environment);
        return conn;
    }

    public static JMXConnector newJMXConnector(JMXServiceURL serviceURL, Map<String, ?> environment) throws IOException {
        Map<Object, Object> envcopy;
        if (environment == null) {
            envcopy = new HashMap();
        } else {
            EnvHelp.checkAttributes(environment);
            envcopy = new HashMap(environment);
        }
        ClassLoader loader = JMXConnectorFactory.resolveClassLoader(envcopy);
        Class<JMXConnectorProvider> targetInterface = JMXConnectorProvider.class;
        String protocol = serviceURL.getProtocol();
        String providerClassName = "ClientProvider";
        JMXConnectorProvider provider = JMXConnectorFactory.getProvider(serviceURL, envcopy, "ClientProvider", targetInterface, loader);
        IOException exception = null;
        if (provider == null) {
            if (loader != null) {
                try {
                    JMXConnector connection = JMXConnectorFactory.getConnectorAsService(loader, serviceURL, envcopy);
                    if (connection != null) {
                        return connection;
                    }
                }
                catch (JMXProviderException e) {
                    throw e;
                }
                catch (IOException e) {
                    exception = e;
                }
            }
            provider = JMXConnectorFactory.getProvider(protocol, PROTOCOL_PROVIDER_DEFAULT_PACKAGE, JMXConnectorFactory.class.getClassLoader(), "ClientProvider", targetInterface);
        }
        if (provider == null) {
            MalformedURLException e = new MalformedURLException("Unsupported protocol: " + protocol);
            if (exception == null) {
                throw e;
            }
            throw EnvHelp.initCause(e, exception);
        }
        envcopy = Collections.unmodifiableMap(envcopy);
        return provider.newJMXConnector(serviceURL, envcopy);
    }

    private static String resolvePkgs(Map env) throws JMXProviderException {
        Object pkgsObject = null;
        if (env != null) {
            pkgsObject = env.get(PROTOCOL_PROVIDER_PACKAGES);
        }
        if (pkgsObject == null) {
            pkgsObject = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    return System.getProperty(JMXConnectorFactory.PROTOCOL_PROVIDER_PACKAGES);
                }
            });
        }
        if (pkgsObject == null) {
            return null;
        }
        if (!(pkgsObject instanceof String)) {
            String msg = "Value of jmx.remote.protocol.provider.pkgs parameter is not a String: " + pkgsObject.getClass().getName();
            throw new JMXProviderException(msg);
        }
        String pkgs = (String)pkgsObject;
        if (pkgs.trim().equals("")) {
            return null;
        }
        if (pkgs.startsWith("|") || pkgs.endsWith("|") || pkgs.indexOf("||") >= 0) {
            String msg = "Value of jmx.remote.protocol.provider.pkgs contains an empty element: " + pkgs;
            throw new JMXProviderException(msg);
        }
        return pkgs;
    }

    static <T> T getProvider(JMXServiceURL serviceURL, Map<String, Object> environment, String providerClassName, Class<T> targetInterface, ClassLoader loader) throws IOException {
        String protocol = serviceURL.getProtocol();
        String pkgs = JMXConnectorFactory.resolvePkgs(environment);
        T instance = null;
        if (pkgs != null) {
            environment.put(PROTOCOL_PROVIDER_CLASS_LOADER, loader);
            instance = JMXConnectorFactory.getProvider(protocol, pkgs, loader, providerClassName, targetInterface);
        }
        return instance;
    }

    static <T> Iterator<T> getProviderIterator(Class<T> providerClass, ClassLoader loader) {
        ServiceLoader<T> serviceLoader = ServiceLoader.load(providerClass, loader);
        return serviceLoader.iterator();
    }

    private static JMXConnector getConnectorAsService(ClassLoader loader, JMXServiceURL url, Map<String, ?> map) throws IOException {
        Iterator<JMXConnectorProvider> providers = JMXConnectorFactory.getProviderIterator(JMXConnectorProvider.class, loader);
        JMXConnector connection = null;
        IOException exception = null;
        while (providers.hasNext()) {
            try {
                connection = providers.next().newJMXConnector(url, map);
                return connection;
            }
            catch (JMXProviderException e) {
                throw e;
            }
            catch (Exception e) {
                if (logger.traceOn()) {
                    logger.trace("getConnectorAsService", "URL[" + url + "] Service provider exception: " + e);
                }
                if (e instanceof MalformedURLException || exception != null) continue;
                if (exception instanceof IOException) {
                    exception = (IOException)e;
                    continue;
                }
                exception = EnvHelp.initCause(new IOException(e.getMessage()), e);
            }
        }
        if (exception == null) {
            return null;
        }
        throw exception;
    }

    static <T> T getProvider(String protocol, String pkgs, ClassLoader loader, String providerClassName, Class<T> targetInterface) throws IOException {
        StringTokenizer tokenizer = new StringTokenizer(pkgs, "|");
        while (tokenizer.hasMoreTokens()) {
            Class<?> providerClass;
            String pkg = tokenizer.nextToken();
            String className = pkg + "." + JMXConnectorFactory.protocol2package(protocol) + "." + providerClassName;
            try {
                providerClass = Class.forName(className, true, loader);
            }
            catch (ClassNotFoundException e) {
                continue;
            }
            if (!targetInterface.isAssignableFrom(providerClass)) {
                String msg = "Provider class does not implement " + targetInterface.getName() + ": " + providerClass.getName();
                throw new JMXProviderException(msg);
            }
            Class providerClassT = (Class)Util.cast(providerClass);
            try {
                return providerClassT.newInstance();
            }
            catch (Exception e) {
                String msg = "Exception when instantiating provider [" + className + "]";
                throw new JMXProviderException(msg, e);
            }
        }
        return null;
    }

    static ClassLoader resolveClassLoader(Map environment) {
        ClassLoader loader = null;
        if (environment != null) {
            try {
                loader = (ClassLoader)environment.get(PROTOCOL_PROVIDER_CLASS_LOADER);
            }
            catch (ClassCastException e) {
                String msg = "The ClassLoader supplied in the environment map using the jmx.remote.protocol.provider.class.loader attribute is not an instance of java.lang.ClassLoader";
                throw new IllegalArgumentException("The ClassLoader supplied in the environment map using the jmx.remote.protocol.provider.class.loader attribute is not an instance of java.lang.ClassLoader");
            }
        }
        if (loader == null) {
            loader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }
        return loader;
    }

    private static String protocol2package(String protocol) {
        return protocol.replace('+', '.').replace('-', '_');
    }
}

