/*
 * Decompiled with CFR 0.152.
 */
package javax.print.attribute;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.AttributeSetUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashAttributeSet
implements AttributeSet,
Serializable {
    private static final long serialVersionUID = 5311560590283707917L;
    private Class myInterface;
    private transient HashMap attrMap = new HashMap();

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Attribute[] attrs = this.toArray();
        s.writeInt(attrs.length);
        for (int i = 0; i < attrs.length; ++i) {
            s.writeObject(attrs[i]);
        }
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        this.attrMap = new HashMap();
        int count = s.readInt();
        for (int i = 0; i < count; ++i) {
            Attribute attr = (Attribute)s.readObject();
            this.add(attr);
        }
    }

    public HashAttributeSet() {
        this(Attribute.class);
    }

    public HashAttributeSet(Attribute attribute) {
        this(attribute, Attribute.class);
    }

    public HashAttributeSet(Attribute[] attributes) {
        this(attributes, Attribute.class);
    }

    public HashAttributeSet(AttributeSet attributes) {
        this(attributes, Attribute.class);
    }

    protected HashAttributeSet(Class<?> interfaceName) {
        if (interfaceName == null) {
            throw new NullPointerException("null interface");
        }
        this.myInterface = interfaceName;
    }

    protected HashAttributeSet(Attribute attribute, Class<?> interfaceName) {
        if (interfaceName == null) {
            throw new NullPointerException("null interface");
        }
        this.myInterface = interfaceName;
        this.add(attribute);
    }

    protected HashAttributeSet(Attribute[] attributes, Class<?> interfaceName) {
        if (interfaceName == null) {
            throw new NullPointerException("null interface");
        }
        this.myInterface = interfaceName;
        int n = attributes == null ? 0 : attributes.length;
        for (int i = 0; i < n; ++i) {
            this.add(attributes[i]);
        }
    }

    protected HashAttributeSet(AttributeSet attributes, Class<?> interfaceName) {
        this.myInterface = interfaceName;
        if (attributes != null) {
            Attribute[] attribArray = attributes.toArray();
            int n = attribArray == null ? 0 : attribArray.length;
            for (int i = 0; i < n; ++i) {
                this.add(attribArray[i]);
            }
        }
    }

    @Override
    public Attribute get(Class<?> category) {
        return (Attribute)this.attrMap.get(AttributeSetUtilities.verifyAttributeCategory(category, Attribute.class));
    }

    @Override
    public boolean add(Attribute attribute) {
        Attribute oldAttribute = this.attrMap.put(attribute.getCategory(), AttributeSetUtilities.verifyAttributeValue(attribute, this.myInterface));
        return !attribute.equals(oldAttribute);
    }

    @Override
    public boolean remove(Class<?> category) {
        return category != null && AttributeSetUtilities.verifyAttributeCategory(category, Attribute.class) != null && this.attrMap.remove(category) != null;
    }

    @Override
    public boolean remove(Attribute attribute) {
        return attribute != null && this.attrMap.remove(attribute.getCategory()) != null;
    }

    @Override
    public boolean containsKey(Class<?> category) {
        return category != null && AttributeSetUtilities.verifyAttributeCategory(category, Attribute.class) != null && this.attrMap.get(category) != null;
    }

    @Override
    public boolean containsValue(Attribute attribute) {
        return attribute != null && attribute instanceof Attribute && attribute.equals(this.attrMap.get(attribute.getCategory()));
    }

    @Override
    public boolean addAll(AttributeSet attributes) {
        Attribute[] attrs = attributes.toArray();
        boolean result = false;
        for (int i = 0; i < attrs.length; ++i) {
            Attribute oldValue;
            Attribute newValue = AttributeSetUtilities.verifyAttributeValue(attrs[i], this.myInterface);
            result = !newValue.equals(oldValue = this.attrMap.put(newValue.getCategory(), newValue)) || result;
        }
        return result;
    }

    @Override
    public int size() {
        return this.attrMap.size();
    }

    @Override
    public Attribute[] toArray() {
        Attribute[] attrs = new Attribute[this.size()];
        this.attrMap.values().toArray(attrs);
        return attrs;
    }

    @Override
    public void clear() {
        this.attrMap.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.attrMap.isEmpty();
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof AttributeSet)) {
            return false;
        }
        AttributeSet aset = (AttributeSet)object;
        if (aset.size() != this.size()) {
            return false;
        }
        Attribute[] attrs = this.toArray();
        for (int i = 0; i < attrs.length; ++i) {
            if (aset.containsValue(attrs[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hcode = 0;
        Attribute[] attrs = this.toArray();
        for (int i = 0; i < attrs.length; ++i) {
            hcode += attrs[i].hashCode();
        }
        return hcode;
    }
}

