/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.BevelBorder;

public class SoftBevelBorder
extends BevelBorder {
    public SoftBevelBorder(int bevelType) {
        super(bevelType);
    }

    public SoftBevelBorder(int bevelType, Color highlight, Color shadow) {
        super(bevelType, highlight, shadow);
    }

    public SoftBevelBorder(int bevelType, Color highlightOuterColor, Color highlightInnerColor, Color shadowOuterColor, Color shadowInnerColor) {
        super(bevelType, highlightOuterColor, highlightInnerColor, shadowOuterColor, shadowInnerColor);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.translate(x, y);
        if (this.bevelType == 0) {
            g.setColor(this.getHighlightOuterColor(c));
            g.drawLine(0, 0, width - 2, 0);
            g.drawLine(0, 0, 0, height - 2);
            g.drawLine(1, 1, 1, 1);
            g.setColor(this.getHighlightInnerColor(c));
            g.drawLine(2, 1, width - 2, 1);
            g.drawLine(1, 2, 1, height - 2);
            g.drawLine(2, 2, 2, 2);
            g.drawLine(0, height - 1, 0, height - 2);
            g.drawLine(width - 1, 0, width - 1, 0);
            g.setColor(this.getShadowOuterColor(c));
            g.drawLine(2, height - 1, width - 1, height - 1);
            g.drawLine(width - 1, 2, width - 1, height - 1);
            g.setColor(this.getShadowInnerColor(c));
            g.drawLine(width - 2, height - 2, width - 2, height - 2);
        } else if (this.bevelType == 1) {
            g.setColor(this.getShadowOuterColor(c));
            g.drawLine(0, 0, width - 2, 0);
            g.drawLine(0, 0, 0, height - 2);
            g.drawLine(1, 1, 1, 1);
            g.setColor(this.getShadowInnerColor(c));
            g.drawLine(2, 1, width - 2, 1);
            g.drawLine(1, 2, 1, height - 2);
            g.drawLine(2, 2, 2, 2);
            g.drawLine(0, height - 1, 0, height - 2);
            g.drawLine(width - 1, 0, width - 1, 0);
            g.setColor(this.getHighlightOuterColor(c));
            g.drawLine(2, height - 1, width - 1, height - 1);
            g.drawLine(width - 1, 2, width - 1, height - 1);
            g.setColor(this.getHighlightInnerColor(c));
            g.drawLine(width - 2, height - 2, width - 2, height - 2);
        }
        g.translate(-x, -y);
        g.setColor(oldColor);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.right = 3;
        insets.bottom = 3;
        insets.left = 3;
        insets.top = 3;
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

