/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.metal.MetalBumps;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalToolBarUI;
import javax.swing.plaf.metal.MetalUtils;
import javax.swing.text.JTextComponent;
import sun.swing.StringUIClientPropertyKey;

public class MetalBorders {
    static Object NO_BUTTON_ROLLOVER = new StringUIClientPropertyKey("NoButtonRollover");
    private static Border buttonBorder;
    private static Border textBorder;
    private static Border textFieldBorder;
    private static Border toggleButtonBorder;

    public static Border getButtonBorder() {
        if (buttonBorder == null) {
            buttonBorder = new BorderUIResource.CompoundBorderUIResource(new ButtonBorder(), new BasicBorders.MarginBorder());
        }
        return buttonBorder;
    }

    public static Border getTextBorder() {
        if (textBorder == null) {
            textBorder = new BorderUIResource.CompoundBorderUIResource(new Flush3DBorder(), new BasicBorders.MarginBorder());
        }
        return textBorder;
    }

    public static Border getTextFieldBorder() {
        if (textFieldBorder == null) {
            textFieldBorder = new BorderUIResource.CompoundBorderUIResource(new TextFieldBorder(), new BasicBorders.MarginBorder());
        }
        return textFieldBorder;
    }

    public static Border getToggleButtonBorder() {
        if (toggleButtonBorder == null) {
            toggleButtonBorder = new BorderUIResource.CompoundBorderUIResource(new ToggleButtonBorder(), new BasicBorders.MarginBorder());
        }
        return toggleButtonBorder;
    }

    public static Border getDesktopIconBorder() {
        return new BorderUIResource.CompoundBorderUIResource(new LineBorder(MetalLookAndFeel.getControlDarkShadow(), 1), new MatteBorder(2, 2, 1, 2, MetalLookAndFeel.getControl()));
    }

    static Border getToolBarRolloverBorder() {
        if (MetalLookAndFeel.usingOcean()) {
            return new CompoundBorder(new ButtonBorder(), new RolloverMarginBorder());
        }
        return new CompoundBorder(new RolloverButtonBorder(), new RolloverMarginBorder());
    }

    static Border getToolBarNonrolloverBorder() {
        if (MetalLookAndFeel.usingOcean()) {
            new CompoundBorder(new ButtonBorder(), new RolloverMarginBorder());
        }
        return new CompoundBorder(new ButtonBorder(), new RolloverMarginBorder());
    }

    public static class TableHeaderBorder
    extends AbstractBorder {
        protected Insets editorBorderInsets = new Insets(2, 2, 2, 0);

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            g.setColor(MetalLookAndFeel.getControlDarkShadow());
            g.drawLine(w - 1, 0, w - 1, h - 1);
            g.drawLine(1, h - 1, w - 1, h - 1);
            g.setColor(MetalLookAndFeel.getControlHighlight());
            g.drawLine(0, 0, w - 2, 0);
            g.drawLine(0, 0, 0, h - 2);
            g.translate(-x, -y);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.editorBorderInsets;
        }
    }

    public static class ToggleButtonBorder
    extends ButtonBorder {
        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            AbstractButton button = (AbstractButton)c;
            ButtonModel model = button.getModel();
            if (MetalLookAndFeel.usingOcean()) {
                if (model.isArmed() || !button.isEnabled()) {
                    super.paintBorder(c, g, x, y, w, h);
                } else {
                    g.setColor(MetalLookAndFeel.getControlDarkShadow());
                    g.drawRect(0, 0, w - 1, h - 1);
                }
                return;
            }
            if (!c.isEnabled()) {
                MetalUtils.drawDisabledBorder(g, x, y, w - 1, h - 1);
            } else if (model.isPressed() && model.isArmed()) {
                MetalUtils.drawPressed3DBorder(g, x, y, w, h);
            } else if (model.isSelected()) {
                MetalUtils.drawDark3DBorder(g, x, y, w, h);
            } else {
                MetalUtils.drawFlush3DBorder(g, x, y, w, h);
            }
        }
    }

    public static class ScrollPaneBorder
    extends AbstractBorder
    implements UIResource {
        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            JScrollPane scroll = (JScrollPane)c;
            JViewport colHeader = scroll.getColumnHeader();
            int colHeaderHeight = 0;
            if (colHeader != null) {
                colHeaderHeight = colHeader.getHeight();
            }
            JViewport rowHeader = scroll.getRowHeader();
            int rowHeaderWidth = 0;
            if (rowHeader != null) {
                rowHeaderWidth = rowHeader.getWidth();
            }
            g.translate(x, y);
            g.setColor(MetalLookAndFeel.getControlDarkShadow());
            g.drawRect(0, 0, w - 2, h - 2);
            g.setColor(MetalLookAndFeel.getControlHighlight());
            g.drawLine(w - 1, 1, w - 1, h - 1);
            g.drawLine(1, h - 1, w - 1, h - 1);
            g.setColor(MetalLookAndFeel.getControl());
            g.drawLine(w - 2, 2 + colHeaderHeight, w - 2, 2 + colHeaderHeight);
            g.drawLine(1 + rowHeaderWidth, h - 2, 1 + rowHeaderWidth, h - 2);
            g.translate(-x, -y);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(1, 1, 2, 2);
        }
    }

    public static class TextFieldBorder
    extends Flush3DBorder {
        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            if (!(c instanceof JTextComponent)) {
                if (c.isEnabled()) {
                    MetalUtils.drawFlush3DBorder(g, x, y, w, h);
                } else {
                    MetalUtils.drawDisabledBorder(g, x, y, w, h);
                }
                return;
            }
            if (c.isEnabled() && ((JTextComponent)c).isEditable()) {
                MetalUtils.drawFlush3DBorder(g, x, y, w, h);
            } else {
                MetalUtils.drawDisabledBorder(g, x, y, w, h);
            }
        }
    }

    public static class ToolBarBorder
    extends AbstractBorder
    implements UIResource,
    SwingConstants {
        protected MetalBumps bumps = new MetalBumps(10, 10, MetalLookAndFeel.getControlHighlight(), MetalLookAndFeel.getControlDarkShadow(), UIManager.getColor("ToolBar.background"));

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            if (((JToolBar)c).isFloatable()) {
                if (((JToolBar)c).getOrientation() == 0) {
                    int shift = MetalLookAndFeel.usingOcean() ? -1 : 0;
                    this.bumps.setBumpArea(10, h - 4);
                    if (MetalUtils.isLeftToRight(c)) {
                        this.bumps.paintIcon(c, g, 2, 2 + shift);
                    } else {
                        this.bumps.paintIcon(c, g, w - 12, 2 + shift);
                    }
                } else {
                    this.bumps.setBumpArea(w - 4, 10);
                    this.bumps.paintIcon(c, g, 2, 2);
                }
            }
            if (((JToolBar)c).getOrientation() == 0 && MetalLookAndFeel.usingOcean()) {
                g.setColor(MetalLookAndFeel.getControl());
                g.drawLine(0, h - 2, w, h - 2);
                g.setColor(UIManager.getColor("ToolBar.borderColor"));
                g.drawLine(0, h - 1, w, h - 1);
            }
            g.translate(-x, -y);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets newInsets) {
            Insets margin;
            if (MetalLookAndFeel.usingOcean()) {
                newInsets.set(1, 2, 3, 2);
            } else {
                newInsets.right = 2;
                newInsets.bottom = 2;
                newInsets.left = 2;
                newInsets.top = 2;
            }
            if (((JToolBar)c).isFloatable()) {
                if (((JToolBar)c).getOrientation() == 0) {
                    if (c.getComponentOrientation().isLeftToRight()) {
                        newInsets.left = 16;
                    } else {
                        newInsets.right = 16;
                    }
                } else {
                    newInsets.top = 16;
                }
            }
            if ((margin = ((JToolBar)c).getMargin()) != null) {
                newInsets.left += margin.left;
                newInsets.top += margin.top;
                newInsets.right += margin.right;
                newInsets.bottom += margin.bottom;
            }
            return newInsets;
        }
    }

    static class RolloverMarginBorder
    extends EmptyBorder {
        public RolloverMarginBorder() {
            super(3, 3, 3, 3);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            Insets margin = null;
            if (c instanceof AbstractButton) {
                margin = ((AbstractButton)c).getMargin();
            }
            if (margin == null || margin instanceof UIResource) {
                insets.left = this.left;
                insets.top = this.top;
                insets.right = this.right;
                insets.bottom = this.bottom;
            } else {
                insets.left = margin.left;
                insets.top = margin.top;
                insets.right = margin.right;
                insets.bottom = margin.bottom;
            }
            return insets;
        }
    }

    public static class RolloverButtonBorder
    extends ButtonBorder {
        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            AbstractButton b = (AbstractButton)c;
            ButtonModel model = b.getModel();
            if (model.isRollover() && (!model.isPressed() || model.isArmed())) {
                super.paintBorder(c, g, x, y, w, h);
            }
        }
    }

    public static class PopupMenuBorder
    extends AbstractBorder
    implements UIResource {
        protected static Insets borderInsets = new Insets(3, 1, 2, 1);

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            g.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            g.drawRect(0, 0, w - 1, h - 1);
            g.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
            g.drawLine(1, 1, w - 2, 1);
            g.drawLine(1, 2, 1, 2);
            g.drawLine(1, h - 2, 1, h - 2);
            g.translate(-x, -y);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(3, 1, 2, 1);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets newInsets) {
            newInsets.top = 3;
            newInsets.left = 1;
            newInsets.bottom = 2;
            newInsets.right = 1;
            return newInsets;
        }
    }

    public static class MenuItemBorder
    extends AbstractBorder
    implements UIResource {
        protected static Insets borderInsets = new Insets(2, 2, 2, 2);

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            JMenuItem b = (JMenuItem)c;
            ButtonModel model = b.getModel();
            g.translate(x, y);
            if (c.getParent() instanceof JMenuBar) {
                if (model.isArmed() || model.isSelected()) {
                    g.setColor(MetalLookAndFeel.getControlDarkShadow());
                    g.drawLine(0, 0, w - 2, 0);
                    g.drawLine(0, 0, 0, h - 1);
                    g.drawLine(w - 2, 2, w - 2, h - 1);
                    g.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
                    g.drawLine(w - 1, 1, w - 1, h - 1);
                    g.setColor(MetalLookAndFeel.getMenuBackground());
                    g.drawLine(w - 1, 0, w - 1, 0);
                }
            } else if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                g.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
                g.drawLine(0, 0, w - 1, 0);
                g.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
                g.drawLine(0, h - 1, w - 1, h - 1);
            } else {
                g.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
                g.drawLine(0, 0, 0, h - 1);
            }
            g.translate(-x, -y);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(2, 2, 2, 2);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets newInsets) {
            newInsets.top = 2;
            newInsets.left = 2;
            newInsets.bottom = 2;
            newInsets.right = 2;
            return newInsets;
        }
    }

    public static class MenuBarBorder
    extends AbstractBorder
    implements UIResource {
        protected static Insets borderInsets = new Insets(1, 0, 1, 0);

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            if (MetalLookAndFeel.usingOcean()) {
                if (!MetalToolBarUI.doesMenuBarBorderToolBar((JMenuBar)c)) {
                    g.setColor(MetalLookAndFeel.getControl());
                    g.drawLine(0, h - 2, w, h - 2);
                    g.setColor(UIManager.getColor("MenuBar.borderColor"));
                    g.drawLine(0, h - 1, w, h - 1);
                }
            } else {
                g.setColor(MetalLookAndFeel.getControlShadow());
                g.drawLine(0, h - 1, w, h - 1);
            }
            g.translate(-x, -y);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets newInsets) {
            if (MetalLookAndFeel.usingOcean()) {
                newInsets.set(0, 0, 2, 0);
            } else {
                newInsets.top = 1;
                newInsets.left = 0;
                newInsets.bottom = 1;
                newInsets.right = 0;
            }
            return newInsets;
        }
    }

    public static class OptionDialogBorder
    extends AbstractBorder
    implements UIResource {
        int titleHeight = 0;

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            Color borderColor;
            Object obj;
            g.translate(x, y);
            int messageType = -1;
            if (c instanceof JInternalFrame && (obj = ((JInternalFrame)c).getClientProperty("JInternalFrame.messageType")) != null && obj instanceof Integer) {
                messageType = (Integer)obj;
            }
            switch (messageType) {
                case 0: {
                    borderColor = UIManager.getColor("OptionPane.errorDialog.border.background");
                    break;
                }
                case 3: {
                    borderColor = UIManager.getColor("OptionPane.questionDialog.border.background");
                    break;
                }
                case 2: {
                    borderColor = UIManager.getColor("OptionPane.warningDialog.border.background");
                    break;
                }
                default: {
                    borderColor = MetalLookAndFeel.getPrimaryControlDarkShadow();
                }
            }
            g.setColor(borderColor);
            g.drawLine(1, 0, w - 2, 0);
            g.drawLine(0, 1, 0, h - 2);
            g.drawLine(w - 1, 1, w - 1, h - 2);
            g.drawLine(1, h - 1, w - 2, h - 1);
            for (int i = 1; i < 3; ++i) {
                g.drawRect(i, i, w - i * 2 - 1, h - i * 2 - 1);
            }
            g.translate(-x, -y);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(3, 3, 3, 3);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets newInsets) {
            newInsets.top = 3;
            newInsets.left = 3;
            newInsets.bottom = 3;
            newInsets.right = 3;
            return newInsets;
        }
    }

    public static class PaletteBorder
    extends AbstractBorder
    implements UIResource {
        int titleHeight = 0;

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            g.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            g.drawLine(0, 1, 0, h - 2);
            g.drawLine(1, h - 1, w - 2, h - 1);
            g.drawLine(w - 1, 1, w - 1, h - 2);
            g.drawLine(1, 0, w - 2, 0);
            g.drawRect(1, 1, w - 3, h - 3);
            g.translate(-x, -y);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(1, 1, 1, 1);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets newInsets) {
            newInsets.top = 1;
            newInsets.left = 1;
            newInsets.bottom = 1;
            newInsets.right = 1;
            return newInsets;
        }
    }

    static class WarningDialogBorder
    extends DialogBorder
    implements UIResource {
        WarningDialogBorder() {
        }

        @Override
        protected Color getActiveBackground() {
            return UIManager.getColor("OptionPane.warningDialog.border.background");
        }
    }

    static class QuestionDialogBorder
    extends DialogBorder
    implements UIResource {
        QuestionDialogBorder() {
        }

        @Override
        protected Color getActiveBackground() {
            return UIManager.getColor("OptionPane.questionDialog.border.background");
        }
    }

    static class ErrorDialogBorder
    extends DialogBorder
    implements UIResource {
        ErrorDialogBorder() {
        }

        @Override
        protected Color getActiveBackground() {
            return UIManager.getColor("OptionPane.errorDialog.border.background");
        }
    }

    static class DialogBorder
    extends AbstractBorder
    implements UIResource {
        private static final int corner = 14;

        DialogBorder() {
        }

        protected Color getActiveBackground() {
            return MetalLookAndFeel.getPrimaryControlDarkShadow();
        }

        protected Color getActiveHighlight() {
            return MetalLookAndFeel.getPrimaryControlShadow();
        }

        protected Color getActiveShadow() {
            return MetalLookAndFeel.getPrimaryControlInfo();
        }

        protected Color getInactiveBackground() {
            return MetalLookAndFeel.getControlDarkShadow();
        }

        protected Color getInactiveHighlight() {
            return MetalLookAndFeel.getControlShadow();
        }

        protected Color getInactiveShadow() {
            return MetalLookAndFeel.getControlInfo();
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            Color shadow;
            Color highlight;
            Color background;
            Window window = SwingUtilities.getWindowAncestor(c);
            if (window != null && window.isActive()) {
                background = this.getActiveBackground();
                highlight = this.getActiveHighlight();
                shadow = this.getActiveShadow();
            } else {
                background = this.getInactiveBackground();
                highlight = this.getInactiveHighlight();
                shadow = this.getInactiveShadow();
            }
            g.setColor(background);
            g.drawLine(x + 1, y + 0, x + w - 2, y + 0);
            g.drawLine(x + 0, y + 1, x + 0, y + h - 2);
            g.drawLine(x + w - 1, y + 1, x + w - 1, y + h - 2);
            g.drawLine(x + 1, y + h - 1, x + w - 2, y + h - 1);
            for (int i = 1; i < 5; ++i) {
                g.drawRect(x + i, y + i, w - i * 2 - 1, h - i * 2 - 1);
            }
            if (window instanceof Dialog && ((Dialog)window).isResizable()) {
                g.setColor(highlight);
                g.drawLine(15, 3, w - 14, 3);
                g.drawLine(3, 15, 3, h - 14);
                g.drawLine(w - 2, 15, w - 2, h - 14);
                g.drawLine(15, h - 2, w - 14, h - 2);
                g.setColor(shadow);
                g.drawLine(14, 2, w - 14 - 1, 2);
                g.drawLine(2, 14, 2, h - 14 - 1);
                g.drawLine(w - 3, 14, w - 3, h - 14 - 1);
                g.drawLine(14, h - 3, w - 14 - 1, h - 3);
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(5, 5, 5, 5);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets newInsets) {
            newInsets.top = 5;
            newInsets.left = 5;
            newInsets.bottom = 5;
            newInsets.right = 5;
            return newInsets;
        }
    }

    static class FrameBorder
    extends AbstractBorder
    implements UIResource {
        private static final int corner = 14;

        FrameBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            ColorUIResource shadow;
            ColorUIResource highlight;
            ColorUIResource background;
            Window window = SwingUtilities.getWindowAncestor(c);
            if (window != null && window.isActive()) {
                background = MetalLookAndFeel.getPrimaryControlDarkShadow();
                highlight = MetalLookAndFeel.getPrimaryControlShadow();
                shadow = MetalLookAndFeel.getPrimaryControlInfo();
            } else {
                background = MetalLookAndFeel.getControlDarkShadow();
                highlight = MetalLookAndFeel.getControlShadow();
                shadow = MetalLookAndFeel.getControlInfo();
            }
            g.setColor(background);
            g.drawLine(x + 1, y + 0, x + w - 2, y + 0);
            g.drawLine(x + 0, y + 1, x + 0, y + h - 2);
            g.drawLine(x + w - 1, y + 1, x + w - 1, y + h - 2);
            g.drawLine(x + 1, y + h - 1, x + w - 2, y + h - 1);
            for (int i = 1; i < 5; ++i) {
                g.drawRect(x + i, y + i, w - i * 2 - 1, h - i * 2 - 1);
            }
            if (window instanceof Frame && ((Frame)window).isResizable()) {
                g.setColor(highlight);
                g.drawLine(15, 3, w - 14, 3);
                g.drawLine(3, 15, 3, h - 14);
                g.drawLine(w - 2, 15, w - 2, h - 14);
                g.drawLine(15, h - 2, w - 14, h - 2);
                g.setColor(shadow);
                g.drawLine(14, 2, w - 14 - 1, 2);
                g.drawLine(2, 14, 2, h - 14 - 1);
                g.drawLine(w - 3, 14, w - 3, h - 14 - 1);
                g.drawLine(14, h - 3, w - 14 - 1, h - 3);
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(5, 5, 5, 5);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets newInsets) {
            newInsets.top = 5;
            newInsets.left = 5;
            newInsets.bottom = 5;
            newInsets.right = 5;
            return newInsets;
        }
    }

    public static class InternalFrameBorder
    extends AbstractBorder
    implements UIResource {
        private static final int corner = 14;

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            ColorUIResource shadow;
            ColorUIResource highlight;
            ColorUIResource background;
            if (c instanceof JInternalFrame && ((JInternalFrame)c).isSelected()) {
                background = MetalLookAndFeel.getPrimaryControlDarkShadow();
                highlight = MetalLookAndFeel.getPrimaryControlShadow();
                shadow = MetalLookAndFeel.getPrimaryControlInfo();
            } else {
                background = MetalLookAndFeel.getControlDarkShadow();
                highlight = MetalLookAndFeel.getControlShadow();
                shadow = MetalLookAndFeel.getControlInfo();
            }
            g.setColor(background);
            g.drawLine(1, 0, w - 2, 0);
            g.drawLine(0, 1, 0, h - 2);
            g.drawLine(w - 1, 1, w - 1, h - 2);
            g.drawLine(1, h - 1, w - 2, h - 1);
            for (int i = 1; i < 5; ++i) {
                g.drawRect(x + i, y + i, w - i * 2 - 1, h - i * 2 - 1);
            }
            if (c instanceof JInternalFrame && ((JInternalFrame)c).isResizable()) {
                g.setColor(highlight);
                g.drawLine(15, 3, w - 14, 3);
                g.drawLine(3, 15, 3, h - 14);
                g.drawLine(w - 2, 15, w - 2, h - 14);
                g.drawLine(15, h - 2, w - 14, h - 2);
                g.setColor(shadow);
                g.drawLine(14, 2, w - 14 - 1, 2);
                g.drawLine(2, 14, 2, h - 14 - 1);
                g.drawLine(w - 3, 14, w - 3, h - 14 - 1);
                g.drawLine(14, h - 3, w - 14 - 1, h - 3);
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(5, 5, 5, 5);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets newInsets) {
            newInsets.top = 5;
            newInsets.left = 5;
            newInsets.bottom = 5;
            newInsets.right = 5;
            return newInsets;
        }
    }

    public static class ButtonBorder
    extends AbstractBorder
    implements UIResource {
        protected static Insets borderInsets = new Insets(3, 3, 3, 3);

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            if (MetalLookAndFeel.usingOcean()) {
                this.paintOceanBorder(c, g, x, y, w, h);
                return;
            }
            AbstractButton button = (AbstractButton)c;
            ButtonModel model = button.getModel();
            if (model.isEnabled()) {
                boolean isDefault;
                boolean isPressed = model.isPressed() && model.isArmed();
                boolean bl = isDefault = button instanceof JButton && ((JButton)button).isDefaultButton();
                if (isPressed && isDefault) {
                    MetalUtils.drawDefaultButtonPressedBorder(g, x, y, w, h);
                } else if (isPressed) {
                    MetalUtils.drawPressed3DBorder(g, x, y, w, h);
                } else if (isDefault) {
                    MetalUtils.drawDefaultButtonBorder(g, x, y, w, h, false);
                } else {
                    MetalUtils.drawButtonBorder(g, x, y, w, h, false);
                }
            } else {
                MetalUtils.drawDisabledBorder(g, x, y, w - 1, h - 1);
            }
        }

        private void paintOceanBorder(Component c, Graphics g, int x, int y, int w, int h) {
            AbstractButton button = (AbstractButton)c;
            ButtonModel model = ((AbstractButton)c).getModel();
            g.translate(x, y);
            if (MetalUtils.isToolBarButton(button)) {
                if (model.isEnabled()) {
                    if (model.isPressed()) {
                        g.setColor(MetalLookAndFeel.getWhite());
                        g.fillRect(1, h - 1, w - 1, 1);
                        g.fillRect(w - 1, 1, 1, h - 1);
                        g.setColor(MetalLookAndFeel.getControlDarkShadow());
                        g.drawRect(0, 0, w - 2, h - 2);
                        g.fillRect(1, 1, w - 3, 1);
                    } else if (model.isSelected() || model.isRollover()) {
                        g.setColor(MetalLookAndFeel.getWhite());
                        g.fillRect(1, h - 1, w - 1, 1);
                        g.fillRect(w - 1, 1, 1, h - 1);
                        g.setColor(MetalLookAndFeel.getControlDarkShadow());
                        g.drawRect(0, 0, w - 2, h - 2);
                    } else {
                        g.setColor(MetalLookAndFeel.getWhite());
                        g.drawRect(1, 1, w - 2, h - 2);
                        g.setColor(UIManager.getColor("Button.toolBarBorderBackground"));
                        g.drawRect(0, 0, w - 2, h - 2);
                    }
                } else {
                    g.setColor(UIManager.getColor("Button.disabledToolBarBorderBackground"));
                    g.drawRect(0, 0, w - 2, h - 2);
                }
            } else if (model.isEnabled()) {
                boolean pressed = model.isPressed();
                boolean armed = model.isArmed();
                if (c instanceof JButton && ((JButton)c).isDefaultButton()) {
                    g.setColor(MetalLookAndFeel.getControlDarkShadow());
                    g.drawRect(0, 0, w - 1, h - 1);
                    g.drawRect(1, 1, w - 3, h - 3);
                } else if (pressed) {
                    g.setColor(MetalLookAndFeel.getControlDarkShadow());
                    g.fillRect(0, 0, w, 2);
                    g.fillRect(0, 2, 2, h - 2);
                    g.fillRect(w - 1, 1, 1, h - 1);
                    g.fillRect(1, h - 1, w - 2, 1);
                } else if (model.isRollover() && button.getClientProperty(NO_BUTTON_ROLLOVER) == null) {
                    g.setColor(MetalLookAndFeel.getPrimaryControl());
                    g.drawRect(0, 0, w - 1, h - 1);
                    g.drawRect(2, 2, w - 5, h - 5);
                    g.setColor(MetalLookAndFeel.getControlDarkShadow());
                    g.drawRect(1, 1, w - 3, h - 3);
                } else {
                    g.setColor(MetalLookAndFeel.getControlDarkShadow());
                    g.drawRect(0, 0, w - 1, h - 1);
                }
            } else {
                g.setColor(MetalLookAndFeel.getInactiveControlTextColor());
                g.drawRect(0, 0, w - 1, h - 1);
                if (c instanceof JButton && ((JButton)c).isDefaultButton()) {
                    g.drawRect(1, 1, w - 3, h - 3);
                }
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(3, 3, 3, 3);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets newInsets) {
            newInsets.top = 3;
            newInsets.left = 3;
            newInsets.bottom = 3;
            newInsets.right = 3;
            return newInsets;
        }
    }

    public static class Flush3DBorder
    extends AbstractBorder
    implements UIResource {
        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            if (c.isEnabled()) {
                MetalUtils.drawFlush3DBorder(g, x, y, w, h);
            } else {
                MetalUtils.drawDisabledBorder(g, x, y, w, h);
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(2, 2, 2, 2);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets newInsets) {
            newInsets.top = 2;
            newInsets.left = 2;
            newInsets.bottom = 2;
            newInsets.right = 2;
            return newInsets;
        }
    }
}

