/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.CellRendererPane;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalUtils;

public class MetalComboBoxButton
extends JButton {
    protected JComboBox comboBox;
    protected JList listBox;
    protected CellRendererPane rendererPane;
    protected Icon comboIcon;
    protected boolean iconOnly = false;

    public final JComboBox getComboBox() {
        return this.comboBox;
    }

    public final void setComboBox(JComboBox cb) {
        this.comboBox = cb;
    }

    public final Icon getComboIcon() {
        return this.comboIcon;
    }

    public final void setComboIcon(Icon i) {
        this.comboIcon = i;
    }

    public final boolean isIconOnly() {
        return this.iconOnly;
    }

    public final void setIconOnly(boolean isIconOnly) {
        this.iconOnly = isIconOnly;
    }

    MetalComboBoxButton() {
        super("");
        DefaultButtonModel model = new DefaultButtonModel(){

            @Override
            public void setArmed(boolean armed) {
                super.setArmed(this.isPressed() ? true : armed);
            }
        };
        this.setModel(model);
    }

    public MetalComboBoxButton(JComboBox cb, Icon i, CellRendererPane pane, JList list) {
        this();
        this.comboBox = cb;
        this.comboIcon = i;
        this.rendererPane = pane;
        this.listBox = list;
        this.setEnabled(this.comboBox.isEnabled());
    }

    public MetalComboBoxButton(JComboBox cb, Icon i, boolean onlyIcon, CellRendererPane pane, JList list) {
        this(cb, i, pane, list);
        this.iconOnly = onlyIcon;
    }

    @Override
    public boolean isFocusTraversable() {
        return false;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.setBackground(this.comboBox.getBackground());
            this.setForeground(this.comboBox.getForeground());
        } else {
            this.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
            this.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        int iconLeft;
        boolean leftToRight = MetalUtils.isLeftToRight(this.comboBox);
        super.paintComponent(g);
        Insets insets = this.getInsets();
        int width = this.getWidth() - (insets.left + insets.right);
        int height = this.getHeight() - (insets.top + insets.bottom);
        if (height <= 0 || width <= 0) {
            return;
        }
        int left = insets.left;
        int top = insets.top;
        int right = left + (width - 1);
        int bottom = top + (height - 1);
        int iconWidth = 0;
        int n = iconLeft = leftToRight ? right : left;
        if (this.comboIcon != null) {
            iconWidth = this.comboIcon.getIconWidth();
            int iconHeight = this.comboIcon.getIconHeight();
            int iconTop = 0;
            if (this.iconOnly) {
                iconLeft = this.getWidth() / 2 - iconWidth / 2;
                iconTop = this.getHeight() / 2 - iconHeight / 2;
            } else {
                iconLeft = leftToRight ? left + (width - 1) - iconWidth : left;
                iconTop = top + (bottom - top) / 2 - iconHeight / 2;
            }
            this.comboIcon.paintIcon(this, g, iconLeft, iconTop);
            if (this.comboBox.hasFocus() && (!MetalLookAndFeel.usingOcean() || this.comboBox.isEditable())) {
                g.setColor(MetalLookAndFeel.getFocusColor());
                g.drawRect(left - 1, top - 1, width + 3, height + 1);
            }
        }
        if (MetalLookAndFeel.usingOcean()) {
            return;
        }
        if (!this.iconOnly && this.comboBox != null) {
            ListCellRenderer renderer = this.comboBox.getRenderer();
            boolean renderPressed = this.getModel().isPressed();
            Component c = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, renderPressed, false);
            c.setFont(this.rendererPane.getFont());
            if (this.model.isArmed() && this.model.isPressed()) {
                if (this.isOpaque()) {
                    c.setBackground(UIManager.getColor("Button.select"));
                }
                c.setForeground(this.comboBox.getForeground());
            } else if (!this.comboBox.isEnabled()) {
                if (this.isOpaque()) {
                    c.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
                }
                c.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
            } else {
                c.setForeground(this.comboBox.getForeground());
                c.setBackground(this.comboBox.getBackground());
            }
            int cWidth = width - (insets.right + iconWidth);
            boolean shouldValidate = false;
            if (c instanceof JPanel) {
                shouldValidate = true;
            }
            if (leftToRight) {
                this.rendererPane.paintComponent(g, c, this, left, top, cWidth, height, shouldValidate);
            } else {
                this.rendererPane.paintComponent(g, c, this, left + iconWidth, top, cWidth, height, shouldValidate);
            }
        }
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension ret = new Dimension();
        Insets insets = this.getInsets();
        ret.width = insets.left + this.getComboIcon().getIconWidth() + insets.right;
        ret.height = insets.bottom + this.getComboIcon().getIconHeight() + insets.top;
        return ret;
    }
}

