/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.Toolkit;
import java.io.Serializable;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.EditableView;
import javax.swing.text.html.HTML;

class HiddenTagView
extends EditableView
implements DocumentListener {
    float yAlign = 1.0f;
    boolean isSettingAttributes;
    static final int circleR = 3;
    static final int circleD = 6;
    static final int tagSize = 6;
    static final int padding = 3;
    static final Color UnknownTagBorderColor = Color.black;
    static final Border StartBorder = new StartTagBorder();
    static final Border EndBorder = new EndTagBorder();

    HiddenTagView(Element e) {
        super(e);
    }

    protected Component createComponent() {
        Font font;
        JTextField tf = new JTextField(this.getElement().getName());
        Document doc = this.getDocument();
        if (doc instanceof StyledDocument) {
            font = ((StyledDocument)doc).getFont(this.getAttributes());
            tf.setFont(font);
        } else {
            font = tf.getFont();
        }
        tf.getDocument().addDocumentListener(this);
        this.updateYAlign(font);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBackground(null);
        if (this.isEndTag()) {
            panel.setBorder(EndBorder);
        } else {
            panel.setBorder(StartBorder);
        }
        panel.add(tf);
        return panel;
    }

    public float getAlignment(int axis) {
        if (axis == 1) {
            return this.yAlign;
        }
        return 0.5f;
    }

    public float getMinimumSpan(int axis) {
        if (axis == 0 && this.isVisible()) {
            return Math.max(30.0f, super.getPreferredSpan(axis));
        }
        return super.getMinimumSpan(axis);
    }

    public float getPreferredSpan(int axis) {
        if (axis == 0 && this.isVisible()) {
            return Math.max(30.0f, super.getPreferredSpan(axis));
        }
        return super.getPreferredSpan(axis);
    }

    public float getMaximumSpan(int axis) {
        if (axis == 0 && this.isVisible()) {
            return Math.max(30.0f, super.getMaximumSpan(axis));
        }
        return super.getMaximumSpan(axis);
    }

    public void insertUpdate(DocumentEvent e) {
        this.updateModelFromText();
    }

    public void removeUpdate(DocumentEvent e) {
        this.updateModelFromText();
    }

    public void changedUpdate(DocumentEvent e) {
        this.updateModelFromText();
    }

    public void changedUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        if (!this.isSettingAttributes) {
            this.setTextFromModel();
        }
    }

    void updateYAlign(Font font) {
        Container c = this.getContainer();
        FontMetrics fm = c != null ? c.getFontMetrics(font) : Toolkit.getDefaultToolkit().getFontMetrics(font);
        float h = fm.getHeight();
        float d = fm.getDescent();
        this.yAlign = h > 0.0f ? (h - d) / h : 0.0f;
    }

    void resetBorder() {
        Component comp = this.getComponent();
        if (comp != null) {
            if (this.isEndTag()) {
                ((JPanel)comp).setBorder(EndBorder);
            } else {
                ((JPanel)comp).setBorder(StartBorder);
            }
        }
    }

    void setTextFromModel() {
        if (SwingUtilities.isEventDispatchThread()) {
            this._setTextFromModel();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    HiddenTagView.this._setTextFromModel();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _setTextFromModel() {
        Document doc = this.getDocument();
        try {
            JTextComponent text;
            this.isSettingAttributes = true;
            if (doc instanceof AbstractDocument) {
                ((AbstractDocument)doc).readLock();
            }
            if ((text = this.getTextComponent()) != null) {
                text.setText(this.getRepresentedText());
                this.resetBorder();
                Container host = this.getContainer();
                if (host != null) {
                    this.preferenceChanged(this, true, true);
                    host.repaint();
                }
            }
        }
        finally {
            this.isSettingAttributes = false;
            if (doc instanceof AbstractDocument) {
                ((AbstractDocument)doc).readUnlock();
            }
        }
    }

    void updateModelFromText() {
        if (!this.isSettingAttributes) {
            if (SwingUtilities.isEventDispatchThread()) {
                this._updateModelFromText();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        HiddenTagView.this._updateModelFromText();
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _updateModelFromText() {
        Document doc = this.getDocument();
        Object name = this.getElement().getAttributes().getAttribute(StyleConstants.NameAttribute);
        if (name instanceof HTML.UnknownTag && doc instanceof StyledDocument) {
            SimpleAttributeSet sas = new SimpleAttributeSet();
            JTextComponent textComponent = this.getTextComponent();
            if (textComponent != null) {
                String text = textComponent.getText();
                this.isSettingAttributes = true;
                try {
                    sas.addAttribute(StyleConstants.NameAttribute, new HTML.UnknownTag(text));
                    ((StyledDocument)doc).setCharacterAttributes(this.getStartOffset(), this.getEndOffset() - this.getStartOffset(), sas, false);
                }
                finally {
                    this.isSettingAttributes = false;
                }
            }
        }
    }

    JTextComponent getTextComponent() {
        Component comp = this.getComponent();
        return comp == null ? null : (JTextComponent)((Container)comp).getComponent(0);
    }

    String getRepresentedText() {
        String retValue = this.getElement().getName();
        return retValue == null ? "" : retValue;
    }

    boolean isEndTag() {
        Object end;
        AttributeSet as = this.getElement().getAttributes();
        return as != null && (end = as.getAttribute(HTML.Attribute.ENDTAG)) != null && end instanceof String && ((String)end).equals("true");
    }

    static class EndTagBorder
    implements Border,
    Serializable {
        EndTagBorder() {
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(UnknownTagBorderColor);
            g.drawLine((x += 3) + (width -= 6) - 1, y + 3, x + width - 1, y + height - 3);
            g.drawArc(x + width - 6 - 1, y + height - 6 - 1, 6, 6, 270, 90);
            g.drawArc(x + width - 6 - 1, y, 6, 6, 0, 90);
            g.drawLine(x + 6, y, x + width - 3, y);
            g.drawLine(x + 6, y + height - 1, x + width - 3, y + height - 1);
            g.drawLine(x + 6, y, x, y + height / 2);
            g.drawLine(x + 6, y + height, x, y + height / 2);
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(2, 11, 2, 5);
        }

        public boolean isBorderOpaque() {
            return false;
        }
    }

    static class StartTagBorder
    implements Border,
    Serializable {
        StartTagBorder() {
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(UnknownTagBorderColor);
            g.drawLine(x += 3, y + 3, x, y + height - 3);
            g.drawArc(x, y + height - 6 - 1, 6, 6, 180, 90);
            g.drawArc(x, y, 6, 6, 90, 90);
            g.drawLine(x + 3, y, x + (width -= 6) - 6, y);
            g.drawLine(x + 3, y + height - 1, x + width - 6, y + height - 1);
            g.drawLine(x + width - 6, y, x + width - 1, y + height / 2);
            g.drawLine(x + width - 6, y + height, x + width - 1, y + height / 2);
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(2, 5, 2, 11);
        }

        public boolean isBorderOpaque() {
            return false;
        }
    }
}

