/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.AwtGraphicsConfigData;
import sun.awt.X11.Native;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class AwtScreenData
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return 24;
    }

    public int getDataSize() {
        return AwtScreenData.getSize();
    }

    public long getPData() {
        return this.pData;
    }

    public AwtScreenData(long addr) {
        log.finest("Creating");
        this.pData = addr;
        this.should_free_memory = false;
    }

    public AwtScreenData() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(AwtScreenData.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public int get_numConfigs() {
        log.finest("");
        return Native.getInt(this.pData + 0L);
    }

    public void set_numConfigs(int v) {
        log.finest("");
        Native.putInt(this.pData + 0L, v);
    }

    public long get_root() {
        log.finest("");
        return Native.getLong(this.pData + 4L);
    }

    public void set_root(long v) {
        log.finest("");
        Native.putLong(this.pData + 4L, v);
    }

    public long get_whitepixel() {
        log.finest("");
        return Native.getLong(this.pData + 8L);
    }

    public void set_whitepixel(long v) {
        log.finest("");
        Native.putLong(this.pData + 8L, v);
    }

    public long get_blackpixel() {
        log.finest("");
        return Native.getLong(this.pData + 12L);
    }

    public void set_blackpixel(long v) {
        log.finest("");
        Native.putLong(this.pData + 12L, v);
    }

    public AwtGraphicsConfigData get_defaultConfig(int index) {
        log.finest("");
        return Native.getLong(this.pData + 16L) != 0L ? new AwtGraphicsConfigData(Native.getLong(this.pData + 16L) + (long)(index * 96)) : null;
    }

    public long get_defaultConfig() {
        log.finest("");
        return Native.getLong(this.pData + 16L);
    }

    public void set_defaultConfig(long v) {
        log.finest("");
        Native.putLong(this.pData + 16L, v);
    }

    public long get_configs(int index) {
        log.finest("");
        return Native.getLong(this.pData + 20L) + (long)(index * Native.getLongSize());
    }

    public long get_configs() {
        log.finest("");
        return Native.getLong(this.pData + 20L);
    }

    public void set_configs(long v) {
        log.finest("");
        Native.putLong(this.pData + 20L, v);
    }

    String getName() {
        return "AwtScreenData";
    }

    String getFieldsAsString() {
        String ret = "";
        ret = ret + "numConfigs = " + this.get_numConfigs() + ", ";
        ret = ret + "root = " + this.get_root() + ", ";
        ret = ret + "whitepixel = " + this.get_whitepixel() + ", ";
        ret = ret + "blackpixel = " + this.get_blackpixel() + ", ";
        ret = ret + "defaultConfig = " + this.get_defaultConfig() + ", ";
        ret = ret + "configs = " + this.get_configs() + ", ";
        return ret;
    }
}

