/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import sun.awt.ComponentAccessor;
import sun.awt.GlobalCursorManager;
import sun.awt.SunToolkit;
import sun.awt.X11.XAwtState;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XComponentPeer;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindowPeer;
import sun.awt.X11.XlibWrapper;

public final class XGlobalCursorManager
extends GlobalCursorManager {
    private static Field field_pData;
    private static Field field_type;
    private static Class cursorClass;
    private static Method method_setPData;
    private WeakReference<Component> nativeContainer;
    private static XGlobalCursorManager manager;

    static GlobalCursorManager getCursorManager() {
        if (manager == null) {
            manager = new XGlobalCursorManager();
        }
        return manager;
    }

    static void nativeUpdateCursor(Component heavy) {
        XGlobalCursorManager.getCursorManager().updateCursorLater(heavy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCursor(Component comp, Cursor cursor, boolean useCache) {
        ComponentPeer nc_peer;
        if (comp == null) {
            return;
        }
        Cursor cur = useCache ? cursor : this.getCapableCursor(comp);
        Component nc = null;
        if (useCache) {
            XGlobalCursorManager xGlobalCursorManager = this;
            synchronized (xGlobalCursorManager) {
                nc = (Component)this.nativeContainer.get();
            }
        } else {
            nc = this.getNativeContainer(comp);
        }
        if (nc != null && (nc_peer = ComponentAccessor.getPeer(nc)) instanceof XComponentPeer) {
            XGlobalCursorManager xGlobalCursorManager = this;
            synchronized (xGlobalCursorManager) {
                this.nativeContainer = new WeakReference<Component>(nc);
            }
            ((XComponentPeer)nc_peer).pSetCursor(cur);
            XGlobalCursorManager.updateGrabbedCursor(cur);
        }
    }

    private static void updateGrabbedCursor(Cursor cur) {
        XBaseWindow target = XAwtState.getGrabWindow();
        if (target instanceof XWindowPeer) {
            XWindowPeer grabber = (XWindowPeer)target;
            grabber.pSetCursor(cur);
        }
    }

    protected void updateCursorOutOfJava() {
        XGlobalCursorManager.updateGrabbedCursor(Cursor.getPredefinedCursor(0));
    }

    private Component getNativeContainer(Component comp) {
        while (comp != null && ComponentAccessor.getPeer(comp) instanceof LightweightPeer) {
            comp = ComponentAccessor.getParent_NoClientCode(comp);
        }
        return comp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getCursorPos(Point p) {
        if (!((XToolkit)Toolkit.getDefaultToolkit()).getLastCursorPos(p)) {
            XToolkit.awtLock();
            try {
                long display = XToolkit.getDisplay();
                long root_window = XlibWrapper.RootWindow(display, XlibWrapper.DefaultScreen(display));
                XlibWrapper.XQueryPointer(display, root_window, XlibWrapper.larg1, XlibWrapper.larg2, XlibWrapper.larg3, XlibWrapper.larg4, XlibWrapper.larg5, XlibWrapper.larg6, XlibWrapper.larg7);
                p.x = XlibWrapper.unsafe.getInt(XlibWrapper.larg3);
                p.y = XlibWrapper.unsafe.getInt(XlibWrapper.larg4);
                Object var7_4 = null;
            }
            catch (Throwable throwable) {
                Object var7_5 = null;
                XToolkit.awtUnlock();
                throw throwable;
            }
            XToolkit.awtUnlock();
            {
            }
        }
    }

    protected Component findHeavyweightUnderCursor() {
        return XAwtState.getComponentMouseEntered();
    }

    protected Component findComponentAt(Container con, int x, int y) {
        return con.findComponentAt(x, y);
    }

    protected Point getLocationOnScreen(Component c) {
        return c.getLocationOnScreen();
    }

    protected Component findHeavyweightUnderCursor(boolean useCache) {
        return this.findHeavyweightUnderCursor();
    }

    private Cursor getCapableCursor(Component comp) {
        Component c = comp;
        while (c != null && !(c instanceof Window) && ComponentAccessor.isEnabledImpl(c) && ComponentAccessor.getVisible(c) && ComponentAccessor.getPeer(c) != null) {
            c = ComponentAccessor.getParent_NoClientCode(c);
        }
        if (c instanceof Window) {
            return ComponentAccessor.isEnabledImpl(c) && ComponentAccessor.getVisible(c) && ComponentAccessor.getPeer(c) != null && ComponentAccessor.isEnabledImpl(comp) ? ComponentAccessor.getCursor_NoClientCode(comp) : Cursor.getPredefinedCursor(0);
        }
        if (c == null) {
            return null;
        }
        return this.getCapableCursor(ComponentAccessor.getParent_NoClientCode(c));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long getCursor(Cursor c) {
        long pData = 0L;
        int type = 0;
        try {
            pData = field_pData.getLong(c);
            type = field_type.getInt(c);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (pData != 0L) {
            return pData;
        }
        int cursorType = 0;
        switch (type) {
            case 0: {
                cursorType = 68;
                break;
            }
            case 1: {
                cursorType = 34;
                break;
            }
            case 2: {
                cursorType = 152;
                break;
            }
            case 3: {
                cursorType = 150;
                break;
            }
            case 4: {
                cursorType = 12;
                break;
            }
            case 6: {
                cursorType = 134;
                break;
            }
            case 5: {
                cursorType = 14;
                break;
            }
            case 7: {
                cursorType = 136;
                break;
            }
            case 9: {
                cursorType = 16;
                break;
            }
            case 8: {
                cursorType = 138;
                break;
            }
            case 10: {
                cursorType = 70;
                break;
            }
            case 11: {
                cursorType = 96;
                break;
            }
            case 12: {
                cursorType = 60;
                break;
            }
            case 13: {
                cursorType = 52;
            }
        }
        XToolkit.awtLock();
        try {
            pData = XlibWrapper.XCreateFontCursor(XToolkit.getDisplay(), cursorType);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
        XGlobalCursorManager.setPData(c, pData);
        return pData;
    }

    static void setPData(Cursor c, long pData) {
        try {
            method_setPData.invoke(c, pData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        cursorClass = Cursor.class;
        field_pData = SunToolkit.getField(cursorClass, "pData");
        field_type = SunToolkit.getField(cursorClass, "type");
        method_setPData = SunToolkit.getMethod(cursorClass, "setPData", new Class[]{Long.TYPE});
        if (field_pData == null || field_type == null || method_setPData == null) {
            System.out.println("Unable to initialize XGlobalCursorManager: ");
            Thread.dumpStack();
        }
    }
}

