/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.peer.KeyboardFocusManagerPeer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.CausedFocusEvent;
import sun.awt.SunToolkit;
import sun.awt.X11.XWindow;
import sun.awt.X11.XWindowPeer;

public class XKeyboardFocusManagerPeer
implements KeyboardFocusManagerPeer {
    private static final Logger focusLog = Logger.getLogger("sun.awt.X11.focus.XKeyboardFocusManagerPeer");
    KeyboardFocusManager manager;
    private static Object lock = new Object(){};
    private static Component currentFocusOwner;
    private static Window currentFocusedWindow;
    static Method shouldNativelyFocusHeavyweightMethod;

    XKeyboardFocusManagerPeer(KeyboardFocusManager manager) {
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setCurrentNativeFocusOwner(Component comp) {
        if (focusLog.isLoggable(Level.FINER)) {
            focusLog.finer("Setting current native focus owner " + comp);
        }
        Object object = lock;
        synchronized (object) {
            currentFocusOwner = comp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setCurrentNativeFocusedWindow(Window win) {
        if (focusLog.isLoggable(Level.FINER)) {
            focusLog.finer("Setting current native focused window " + win);
        }
        XWindowPeer from = null;
        XWindowPeer to = null;
        Object object = lock;
        synchronized (object) {
            if (currentFocusedWindow != null) {
                from = (XWindowPeer)currentFocusedWindow.getPeer();
            }
            if ((currentFocusedWindow = win) != null) {
                to = (XWindowPeer)currentFocusedWindow.getPeer();
            }
        }
        if (from != null) {
            from.updateSecurityWarningVisibility();
        }
        if (to != null) {
            to.updateSecurityWarningVisibility();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Component getCurrentNativeFocusOwner() {
        Object object = lock;
        synchronized (object) {
            return currentFocusOwner;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Window getCurrentNativeFocusedWindow() {
        Object object = lock;
        synchronized (object) {
            return currentFocusedWindow;
        }
    }

    public Window getCurrentFocusedWindow() {
        return XKeyboardFocusManagerPeer.getCurrentNativeFocusedWindow();
    }

    public void setCurrentFocusOwner(Component comp) {
        XKeyboardFocusManagerPeer.setCurrentNativeFocusOwner(comp);
    }

    public Component getCurrentFocusOwner() {
        return XKeyboardFocusManagerPeer.getCurrentNativeFocusOwner();
    }

    public void clearGlobalFocusOwner(Window activeWindow) {
        if (activeWindow != null) {
            Component focusOwner = activeWindow.getFocusOwner();
            if (focusLog.isLoggable(Level.FINE)) {
                focusLog.fine("Clearing global focus owner " + focusOwner);
            }
            if (focusOwner != null) {
                CausedFocusEvent fl = new CausedFocusEvent(focusOwner, 1005, false, null, CausedFocusEvent.Cause.CLEAR_GLOBAL_FOCUS_OWNER);
                XWindow.sendEvent(fl);
            }
        }
    }

    static boolean simulateMotifRequestFocus(Component lightweightChild, Component target, boolean temporary, boolean focusedWindowChangeAllowed, long time, CausedFocusEvent.Cause cause) {
        Component currentOwner;
        if (lightweightChild == null) {
            lightweightChild = target;
        }
        if ((currentOwner = XKeyboardFocusManagerPeer.getCurrentNativeFocusOwner()) != null && currentOwner.getPeer() == null) {
            currentOwner = null;
        }
        if (focusLog.isLoggable(Level.FINER)) {
            focusLog.finer("Simulating transfer from " + currentOwner + " to " + lightweightChild);
        }
        CausedFocusEvent fg = new CausedFocusEvent(lightweightChild, 1004, false, currentOwner, cause);
        CausedFocusEvent fl = null;
        if (currentOwner != null) {
            fl = new CausedFocusEvent(currentOwner, 1005, false, lightweightChild, cause);
        }
        if (fl != null) {
            XWindow.sendEvent(fl);
        }
        XWindow.sendEvent(fg);
        return true;
    }

    static int shouldNativelyFocusHeavyweight(Component heavyweight, Component descendant, boolean temporary, boolean focusedWindowChangeAllowed, long time, CausedFocusEvent.Cause cause) {
        int result;
        block6: {
            if (shouldNativelyFocusHeavyweightMethod == null) {
                Class[] arg_types = new Class[]{Component.class, Component.class, Boolean.TYPE, Boolean.TYPE, Long.TYPE, CausedFocusEvent.Cause.class};
                shouldNativelyFocusHeavyweightMethod = SunToolkit.getMethod(KeyboardFocusManager.class, "shouldNativelyFocusHeavyweight", arg_types);
            }
            Object[] args = new Object[]{heavyweight, descendant, temporary, focusedWindowChangeAllowed, time, cause};
            result = 0;
            if (shouldNativelyFocusHeavyweightMethod != null) {
                try {
                    result = (Integer)shouldNativelyFocusHeavyweightMethod.invoke(null, args);
                }
                catch (IllegalAccessException e) {
                    assert (false);
                }
                catch (InvocationTargetException e) {
                    if ($assertionsDisabled) break block6;
                    throw new AssertionError();
                }
            }
        }
        return result;
    }
}

