/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.peer.PopupMenuPeer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.SunToolkit;
import sun.awt.X11.XComponentPeer;
import sun.awt.X11.XEvent;
import sun.awt.X11.XKeyEvent;
import sun.awt.X11.XMenuPeer;
import sun.awt.X11.XMenuWindow;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindow;

public class XPopupMenuPeer
extends XMenuWindow
implements PopupMenuPeer {
    private static Logger log = Logger.getLogger("sun.awt.X11.XBaseMenuWindow");
    private XComponentPeer componentPeer;
    private PopupMenu popupMenuTarget;
    private XMenuPeer showingMousePressedSubmenu = null;
    private static final int CAPTION_MARGIN_TOP = 4;
    private static final int CAPTION_SEPARATOR_HEIGHT = 6;
    private static final Field f_enabled = SunToolkit.getField(MenuItem.class, "enabled");
    private static final Field f_label = SunToolkit.getField(MenuItem.class, "label");
    private static final Method m_getFont;
    private static final Field f_items;

    XPopupMenuPeer(PopupMenu target) {
        super((XMenuPeer)null);
        this.popupMenuTarget = target;
    }

    public void setFont(Font f) {
        this.resetMapping();
        this.setItemsFont(f);
        this.postPaintEvent();
    }

    public void setLabel(String label) {
        this.resetMapping();
        this.postPaintEvent();
    }

    public void setEnabled(boolean enabled) {
        this.postPaintEvent();
    }

    public void enable() {
        this.setEnabled(true);
    }

    public void disable() {
        this.setEnabled(false);
    }

    public void addSeparator() {
        if (log.isLoggable(Level.FINER)) {
            log.finer("addSeparator is not implemented");
        }
    }

    public void show(Event e) {
        this.target = (Component)e.target;
        Vector targetItemVector = this.getMenuTargetItems();
        if (targetItemVector != null) {
            this.reloadItems(targetItemVector);
            Point tl = this.target.getLocationOnScreen();
            Point pt = new Point(tl.x + e.x, tl.y + e.y);
            if (!this.ensureCreated()) {
                return;
            }
            Dimension dim = this.getDesiredSize();
            Rectangle bounds = this.getWindowBounds(pt, dim);
            this.reshape(bounds);
            this.xSetVisible(true);
            this.toFront();
            this.selectItem(null, false);
            this.grabInput();
        }
    }

    Font getTargetFont() {
        if (this.popupMenuTarget == null) {
            return XWindow.defaultFont;
        }
        try {
            return (Font)m_getFont.invoke(this.popupMenuTarget, new Object[0]);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return XWindow.defaultFont;
    }

    String getTargetLabel() {
        if (this.target == null) {
            return "";
        }
        try {
            String label = (String)f_label.get(this.popupMenuTarget);
            return label == null ? "" : label;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return "";
        }
    }

    boolean isTargetEnabled() {
        if (this.popupMenuTarget == null) {
            return false;
        }
        try {
            return f_enabled.getBoolean(this.popupMenuTarget);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return false;
        }
    }

    Vector getMenuTargetItems() {
        try {
            return (Vector)f_items.get(this.popupMenuTarget);
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
            return null;
        }
    }

    protected Rectangle getWindowBounds(Point origin, Dimension windowSize) {
        Rectangle globalBounds = new Rectangle(origin.x, origin.y, 0, 0);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle res = this.fitWindowRight(globalBounds, windowSize, screenSize);
        if (res != null) {
            return res;
        }
        res = this.fitWindowLeft(globalBounds, windowSize, screenSize);
        if (res != null) {
            return res;
        }
        res = this.fitWindowBelow(globalBounds, windowSize, screenSize);
        if (res != null) {
            return res;
        }
        res = this.fitWindowAbove(globalBounds, windowSize, screenSize);
        if (res != null) {
            return res;
        }
        return this.fitWindowToScreen(windowSize, screenSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Dimension getCaptionSize() {
        String s = this.getTargetLabel();
        if (s.equals("")) {
            return null;
        }
        Graphics g = this.getGraphics();
        if (g == null) {
            return null;
        }
        try {
            Dimension textDimension;
            g.setFont(this.getTargetFont());
            FontMetrics fm = g.getFontMetrics();
            String str = this.getTargetLabel();
            int width = fm.stringWidth(str);
            int height = 4 + fm.getHeight() + 6;
            Dimension dimension = textDimension = new Dimension(width, height);
            Object var10_9 = null;
            g.dispose();
            return dimension;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            g.dispose();
            throw throwable;
        }
    }

    protected void paintCaption(Graphics g, Rectangle rect) {
        String s = this.getTargetLabel();
        if (s.equals("")) {
            return;
        }
        g.setFont(this.getTargetFont());
        FontMetrics fm = g.getFontMetrics();
        String str = this.getTargetLabel();
        int width = fm.stringWidth(str);
        int textx = rect.x + (rect.width - width) / 2;
        int texty = rect.y + 4 + fm.getAscent();
        int sepy = rect.y + rect.height - 3;
        g.setColor(this.isTargetEnabled() ? this.getForegroundColor() : this.getDisabledColor());
        g.drawString(s, textx, texty);
        this.draw3DRect(g, rect.x, sepy, rect.width, 2, false);
    }

    protected void doDispose() {
        super.doDispose();
        XToolkit.targetDisposedPeer(this.popupMenuTarget, this);
    }

    protected void handleEvent(AWTEvent event) {
        switch (event.getID()) {
            case 500: 
            case 501: 
            case 502: 
            case 503: 
            case 504: 
            case 505: 
            case 506: {
                this.doHandleJavaMouseEvent((MouseEvent)event);
                break;
            }
            case 401: 
            case 402: {
                this.doHandleJavaKeyEvent((KeyEvent)event);
                break;
            }
            default: {
                super.handleEvent(event);
            }
        }
    }

    void ungrabInputImpl() {
        this.hide();
    }

    public void handleKeyPress(XEvent xev) {
        XKeyEvent xkey = xev.get_xkey();
        if (log.isLoggable(Level.FINE)) {
            log.fine(xkey.toString());
        }
        if (this.isEventDisabled(xev)) {
            return;
        }
        Component currentSource = this.getEventSource();
        this.handleKeyPress(xkey);
    }

    static {
        f_items = SunToolkit.getField(Menu.class, "items");
        m_getFont = SunToolkit.getMethod(MenuComponent.class, "getFont_NoClientCode", null);
    }
}

