/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image.codec;

import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.image.codec.jpeg.JPEGDecodeParam;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import com.sun.imageio.plugins.jpeg.JPEGImageReader;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.plugins.jpeg.JPEGHuffmanTable;
import javax.imageio.plugins.jpeg.JPEGImageReadParam;
import javax.imageio.plugins.jpeg.JPEGQTable;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class JPEGImageDecoderImpl
implements JPEGImageDecoder {
    private static final String JPGMime = "image/jpeg";
    private JPEGImageReader JPGReader;
    private InputStream in;
    private JPEGDecodeParam param;

    public JPEGImageDecoderImpl(InputStream in) {
        this(in, null);
    }

    public JPEGImageDecoderImpl(InputStream in, JPEGDecodeParam param) {
        this.in = in;
        this.setJPEGDecodeParam(param);
        Iterator<ImageReader> JPGReaderIter = ImageIO.getImageReadersByMIMEType(JPGMime);
        if (JPGReaderIter.hasNext()) {
            this.JPGReader = (JPEGImageReader)JPGReaderIter.next();
        }
        this.JPGReader.setInput(new MemoryCacheImageInputStream(in));
    }

    public BufferedImage decodeAsBufferedImage() throws IOException, ImageFormatException {
        JPEGImageReadParam irp = null;
        if (this.param != null) {
            JPEGQTable[] qTables = new JPEGQTable[4];
            JPEGHuffmanTable[] DCHuffmanTables = new JPEGHuffmanTable[4];
            JPEGHuffmanTable[] ACHuffmanTables = new JPEGHuffmanTable[4];
            for (int i = 0; i < 4; ++i) {
                qTables[i] = new JPEGQTable(this.param.getQTable(i).getTable());
                com.sun.image.codec.jpeg.JPEGHuffmanTable dcHuffman = this.param.getDCHuffmanTable(i);
                com.sun.image.codec.jpeg.JPEGHuffmanTable acHuffman = this.param.getACHuffmanTable(i);
                DCHuffmanTables[i] = new JPEGHuffmanTable(dcHuffman.getLengths(), dcHuffman.getSymbols());
                ACHuffmanTables[i] = new JPEGHuffmanTable(acHuffman.getLengths(), dcHuffman.getSymbols());
            }
            irp = new JPEGImageReadParam();
            irp.setDecodeTables(qTables, DCHuffmanTables, ACHuffmanTables);
        }
        return this.JPGReader.read(0, irp);
    }

    public Raster decodeAsRaster() throws IOException, ImageFormatException {
        return this.JPGReader.readRaster(0, null);
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public JPEGDecodeParam getJPEGDecodeParam() {
        if (this.param == null) {
            return null;
        }
        return (JPEGDecodeParam)this.param.clone();
    }

    public void setJPEGDecodeParam(JPEGDecodeParam jdp) {
        this.param = jdp;
    }
}

