/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Map;
import sun.font.Font2D;
import sun.font.FontManager;
import sun.text.CodePointIterator;

public final class FontResolver {
    private Font[] allFonts;
    private Font[] supplementaryFonts;
    private int[] supplementaryIndices;
    private static final int DEFAULT_SIZE = 12;
    private Font defaultFont = new Font("Dialog", 0, 12);
    private static final int SHIFT = 9;
    private static final int BLOCKSIZE = 128;
    private static final int MASK = 127;
    private int[][] blocks = new int[512][];
    private static FontResolver INSTANCE;

    private FontResolver() {
    }

    private Font[] getAllFonts() {
        if (this.allFonts == null) {
            this.allFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
            for (int i = 0; i < this.allFonts.length; ++i) {
                this.allFonts[i] = this.allFonts[i].deriveFont(12.0f);
            }
        }
        return this.allFonts;
    }

    private int getIndexFor(char c) {
        if (this.defaultFont.canDisplay(c)) {
            return 1;
        }
        for (int i = 0; i < this.getAllFonts().length; ++i) {
            if (!this.allFonts[i].canDisplay(c)) continue;
            return i + 2;
        }
        return 1;
    }

    private Font[] getAllSCFonts() {
        if (this.supplementaryFonts == null) {
            ArrayList<Font> fonts = new ArrayList<Font>();
            ArrayList<Integer> indices = new ArrayList<Integer>();
            for (int i = 0; i < this.getAllFonts().length; ++i) {
                Font font = this.allFonts[i];
                Font2D font2D = FontManager.getFont2D(font);
                if (!font2D.hasSupplementaryChars()) continue;
                fonts.add(font);
                indices.add(new Integer(i));
            }
            int len = fonts.size();
            this.supplementaryIndices = new int[len];
            for (int i = 0; i < len; ++i) {
                this.supplementaryIndices[i] = (Integer)indices.get(i);
            }
            this.supplementaryFonts = fonts.toArray(new Font[len]);
        }
        return this.supplementaryFonts;
    }

    private int getIndexFor(int cp) {
        if (this.defaultFont.canDisplay(cp)) {
            return 1;
        }
        for (int i = 0; i < this.getAllSCFonts().length; ++i) {
            if (!this.supplementaryFonts[i].canDisplay(cp)) continue;
            return this.supplementaryIndices[i] + 2;
        }
        return 1;
    }

    public int getFontIndex(char c) {
        int index;
        int blockIndex = c >> 9;
        int[] block = this.blocks[blockIndex];
        if (block == null) {
            block = new int[128];
            this.blocks[blockIndex] = block;
        }
        if (block[index = c & 0x7F] == 0) {
            block[index] = this.getIndexFor(c);
        }
        return block[index];
    }

    public int getFontIndex(int cp) {
        if (cp < 65536) {
            return this.getFontIndex((char)cp);
        }
        return this.getIndexFor(cp);
    }

    public int nextFontRunIndex(CodePointIterator iter) {
        int cp = iter.next();
        int fontIndex = 1;
        if (cp != -1) {
            fontIndex = this.getFontIndex(cp);
            while ((cp = iter.next()) != -1) {
                if (this.getFontIndex(cp) == fontIndex) continue;
                iter.prev();
                break;
            }
        }
        return fontIndex;
    }

    public Font getFont(int index, Map attributes) {
        Font font = this.defaultFont;
        if (index >= 2) {
            font = this.allFonts[index - 2];
        }
        return font.deriveFont(attributes);
    }

    public static FontResolver getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FontResolver();
        }
        return INSTANCE;
    }
}

