/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import sun.font.CharToGlyphMapper;
import sun.font.FontManager;
import sun.font.FontScaler;
import sun.font.FontScalerException;
import sun.font.Type1Font;

public final class Type1GlyphMapper
extends CharToGlyphMapper {
    Type1Font font;
    FontScaler scaler;

    public Type1GlyphMapper(Type1Font font) {
        this.font = font;
        this.initMapper();
    }

    private void initMapper() {
        this.scaler = this.font.getScaler();
        try {
            this.missingGlyph = this.scaler.getMissingGlyphCode();
        }
        catch (FontScalerException fe) {
            this.scaler = FontManager.getNullScaler();
            try {
                this.missingGlyph = this.scaler.getMissingGlyphCode();
            }
            catch (FontScalerException e) {
                this.missingGlyph = 0;
            }
        }
    }

    public int getNumGlyphs() {
        try {
            return this.scaler.getNumGlyphs();
        }
        catch (FontScalerException e) {
            this.scaler = FontManager.getNullScaler();
            return this.getNumGlyphs();
        }
    }

    public int getMissingGlyphCode() {
        return this.missingGlyph;
    }

    public boolean canDisplay(char ch) {
        try {
            return this.scaler.getGlyphCode(ch) != this.missingGlyph;
        }
        catch (FontScalerException e) {
            this.scaler = FontManager.getNullScaler();
            return this.canDisplay(ch);
        }
    }

    public int charToGlyph(char ch) {
        try {
            return this.scaler.getGlyphCode(ch);
        }
        catch (FontScalerException e) {
            this.scaler = FontManager.getNullScaler();
            return this.charToGlyph(ch);
        }
    }

    public int charToGlyph(int ch) {
        if (ch < 0 || ch > 65535) {
            return this.missingGlyph;
        }
        try {
            return this.scaler.getGlyphCode((char)ch);
        }
        catch (FontScalerException e) {
            this.scaler = FontManager.getNullScaler();
            return this.charToGlyph(ch);
        }
    }

    public void charsToGlyphs(int count, char[] unicodes, int[] glyphs) {
        for (int i = 0; i < count; ++i) {
            char low;
            int code = unicodes[i];
            if (code >= 55296 && code <= 56319 && i < count - 1 && (low = unicodes[i + 1]) >= '\udc00' && low <= '\udfff') {
                code = (code - 55296) * 1024 + low - 56320 + 65536;
                glyphs[i + 1] = 65535;
            }
            glyphs[i] = this.charToGlyph(code);
            if (code < 65536) continue;
            ++i;
        }
    }

    public void charsToGlyphs(int count, int[] unicodes, int[] glyphs) {
        for (int i = 0; i < count; ++i) {
            glyphs[i] = this.charToGlyph(unicodes[i]);
        }
    }

    public boolean charsToGlyphsNS(int count, char[] unicodes, int[] glyphs) {
        for (int i = 0; i < count; ++i) {
            char low;
            int code = unicodes[i];
            if (code >= 55296 && code <= 56319 && i < count - 1 && (low = unicodes[i + 1]) >= '\udc00' && low <= '\udfff') {
                code = (code - 55296) * 1024 + low - 56320 + 65536;
                glyphs[i + 1] = 65535;
            }
            glyphs[i] = this.charToGlyph(code);
            if (code < 768) continue;
            if (FontManager.isComplexCharCode(code)) {
                return true;
            }
            if (code < 65536) continue;
            ++i;
        }
        return false;
    }
}

