/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import sun.io.CharToByteConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;

public class CharToByteUTF8
extends CharToByteConverter {
    private char highHalfZoneCode;

    public int flush(byte[] output, int outStart, int outEnd) throws MalformedInputException {
        if (this.highHalfZoneCode != '\u0000') {
            this.highHalfZoneCode = '\u0000';
            this.badInputLength = 0;
            throw new MalformedInputException();
        }
        this.charOff = 0;
        this.byteOff = 0;
        return 0;
    }

    public int convert(char[] input, int inOff, int inEnd, byte[] output, int outOff, int outEnd) throws ConversionBufferFullException, MalformedInputException {
        char inputChar;
        byte[] outputByte = new byte[6];
        this.charOff = inOff;
        this.byteOff = outOff;
        if (this.highHalfZoneCode != '\u0000') {
            inputChar = this.highHalfZoneCode;
            this.highHalfZoneCode = '\u0000';
            if (input[inOff] >= '\udc00' && input[inOff] <= '\udfff') {
                int ucs4 = (this.highHalfZoneCode - 55296) * 1024 + (input[inOff] - 56320) + 65536;
                output[0] = (byte)(0xF0 | ucs4 >> 18 & 7);
                output[1] = (byte)(0x80 | ucs4 >> 12 & 0x3F);
                output[2] = (byte)(0x80 | ucs4 >> 6 & 0x3F);
                output[3] = (byte)(0x80 | ucs4 & 0x3F);
                ++this.charOff;
                this.highHalfZoneCode = '\u0000';
            } else {
                this.badInputLength = 0;
                throw new MalformedInputException();
            }
        }
        while (this.charOff < inEnd) {
            int outputSize;
            int inputSize;
            inputChar = input[this.charOff];
            if (inputChar < '\u0080') {
                outputByte[0] = (byte)inputChar;
                inputSize = 1;
                outputSize = 1;
            } else if (inputChar < '\u0800') {
                outputByte[0] = (byte)(0xC0 | inputChar >> 6 & 0x1F);
                outputByte[1] = (byte)(0x80 | inputChar & 0x3F);
                inputSize = 1;
                outputSize = 2;
            } else if (inputChar >= '\ud800' && inputChar <= '\udbff') {
                if (this.charOff + 1 >= inEnd) {
                    this.highHalfZoneCode = inputChar;
                    break;
                }
                char lowChar = input[this.charOff + 1];
                if (lowChar < '\udc00' || lowChar > '\udfff') {
                    this.badInputLength = 1;
                    throw new MalformedInputException();
                }
                int ucs4 = (inputChar - 55296) * 1024 + (lowChar - 56320) + 65536;
                outputByte[0] = (byte)(0xF0 | ucs4 >> 18 & 7);
                outputByte[1] = (byte)(0x80 | ucs4 >> 12 & 0x3F);
                outputByte[2] = (byte)(0x80 | ucs4 >> 6 & 0x3F);
                outputByte[3] = (byte)(0x80 | ucs4 & 0x3F);
                outputSize = 4;
                inputSize = 2;
            } else {
                outputByte[0] = (byte)(0xE0 | inputChar >> 12 & 0xF);
                outputByte[1] = (byte)(0x80 | inputChar >> 6 & 0x3F);
                outputByte[2] = (byte)(0x80 | inputChar & 0x3F);
                inputSize = 1;
                outputSize = 3;
            }
            if (this.byteOff + outputSize > outEnd) {
                throw new ConversionBufferFullException();
            }
            for (int i = 0; i < outputSize; ++i) {
                output[this.byteOff++] = outputByte[i];
            }
            this.charOff += inputSize;
        }
        return this.byteOff - outOff;
    }

    public boolean canConvert(char ch) {
        return true;
    }

    public int getMaxBytesPerChar() {
        return 3;
    }

    public void reset() {
        this.charOff = 0;
        this.byteOff = 0;
        this.highHalfZoneCode = '\u0000';
    }

    public String getCharacterEncoding() {
        return "UTF8";
    }
}

