/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import java.security.AccessController;
import sun.io.CharToByteConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.security.action.GetPropertyAction;

public class CharToByteUnicode
extends CharToByteConverter {
    static final char BYTE_ORDER_MARK = '\ufeff';
    protected boolean usesMark = true;
    private boolean markWritten = false;
    static final int UNKNOWN = 0;
    static final int BIG = 1;
    static final int LITTLE = 2;
    protected int byteOrder = 0;

    public CharToByteUnicode() {
        String enc = AccessController.doPrivileged(new GetPropertyAction("sun.io.unicode.encoding", "UnicodeBig"));
        this.byteOrder = enc.equals("UnicodeBig") ? 1 : (enc.equals("UnicodeLittle") ? 2 : 1);
    }

    public CharToByteUnicode(int byteOrder, boolean usesMark) {
        this.byteOrder = byteOrder;
        this.usesMark = usesMark;
    }

    public CharToByteUnicode(boolean usesMark) {
        this();
        this.usesMark = usesMark;
    }

    public String getCharacterEncoding() {
        switch (this.byteOrder) {
            case 1: {
                return this.usesMark ? "UnicodeBig" : "UnicodeBigUnmarked";
            }
            case 2: {
                return this.usesMark ? "UnicodeLittle" : "UnicodeLittleUnmarked";
            }
        }
        return "UnicodeUnknown";
    }

    public int convert(char[] in, int inOff, int inEnd, byte[] out, int outOff, int outEnd) throws ConversionBufferFullException, MalformedInputException {
        this.charOff = inOff;
        this.byteOff = outOff;
        if (inOff >= inEnd) {
            return 0;
        }
        int inI = inOff;
        int outI = outOff;
        int outTop = outEnd - 2;
        if (this.usesMark && !this.markWritten) {
            if (outI > outTop) {
                throw new ConversionBufferFullException();
            }
            if (this.byteOrder == 1) {
                out[outI++] = -2;
                out[outI++] = -1;
            } else {
                out[outI++] = -1;
                out[outI++] = -2;
            }
            this.markWritten = true;
        }
        if (this.byteOrder == 1) {
            while (inI < inEnd) {
                if (outI > outTop) {
                    this.charOff = inI;
                    this.byteOff = outI;
                    throw new ConversionBufferFullException();
                }
                char c = in[inI++];
                out[outI++] = (byte)(c >> 8);
                out[outI++] = (byte)(c & 0xFF);
            }
        } else {
            while (inI < inEnd) {
                if (outI > outTop) {
                    this.charOff = inI;
                    this.byteOff = outI;
                    throw new ConversionBufferFullException();
                }
                char c = in[inI++];
                out[outI++] = (byte)(c & 0xFF);
                out[outI++] = (byte)(c >> 8);
            }
        }
        this.charOff = inI;
        this.byteOff = outI;
        return outI - outOff;
    }

    public int flush(byte[] in, int inOff, int inEnd) {
        this.charOff = 0;
        this.byteOff = 0;
        return 0;
    }

    public void reset() {
        this.charOff = 0;
        this.byteOff = 0;
        this.markWritten = false;
    }

    public int getMaxBytesPerChar() {
        return 4;
    }
}

