/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.opengl;

import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.CompositeType;
import sun.java2d.opengl.OGLGraphicsConfig;
import sun.java2d.opengl.OGLSurfaceData;

abstract class OGLPaints {
    private static Map<Integer, OGLPaints> impls = new HashMap<Integer, OGLPaints>(4, 1.0f);

    OGLPaints() {
    }

    static boolean isValid(SunGraphics2D sg2d) {
        OGLPaints impl = impls.get(sg2d.paintState);
        return impl != null && impl.isPaintValid(sg2d);
    }

    abstract boolean isPaintValid(SunGraphics2D var1);

    static {
        impls.put(2, new Gradient());
        impls.put(3, new LinearGradient());
        impls.put(4, new RadialGradient());
        impls.put(5, new Texture());
    }

    private static class RadialGradient
    extends MultiGradient {
        private RadialGradient() {
        }
    }

    private static class LinearGradient
    extends MultiGradient {
        private LinearGradient() {
        }

        boolean isPaintValid(SunGraphics2D sg2d) {
            LinearGradientPaint paint = (LinearGradientPaint)sg2d.paint;
            if (paint.getFractions().length == 2 && paint.getCycleMethod() != MultipleGradientPaint.CycleMethod.REPEAT && paint.getColorSpace() != MultipleGradientPaint.ColorSpaceType.LINEAR_RGB) {
                return true;
            }
            return super.isPaintValid(sg2d);
        }
    }

    private static abstract class MultiGradient
    extends OGLPaints {
        protected MultiGradient() {
        }

        boolean isPaintValid(SunGraphics2D sg2d) {
            MultipleGradientPaint paint = (MultipleGradientPaint)sg2d.paint;
            if (paint.getFractions().length > 12) {
                return false;
            }
            OGLSurfaceData dstData = (OGLSurfaceData)sg2d.surfaceData;
            OGLGraphicsConfig gc = dstData.getOGLGraphicsConfig();
            return gc.isCapPresent(524288);
        }
    }

    private static class Texture
    extends OGLPaints {
        private Texture() {
        }

        boolean isPaintValid(SunGraphics2D sg2d) {
            OGLSurfaceData oglData;
            SurfaceData srcData;
            TexturePaint paint = (TexturePaint)sg2d.paint;
            OGLSurfaceData dstData = (OGLSurfaceData)sg2d.surfaceData;
            BufferedImage bi = paint.getImage();
            if (!dstData.isTexNonPow2Available()) {
                int imgw = bi.getWidth();
                int imgh = bi.getHeight();
                if ((imgw & imgw - 1) != 0 || (imgh & imgh - 1) != 0) {
                    return false;
                }
            }
            if (!((srcData = dstData.getSourceSurfaceData(bi, 0, CompositeType.SrcOver, null)) instanceof OGLSurfaceData)) {
                srcData = dstData.getSourceSurfaceData(bi, 0, CompositeType.SrcOver, null);
                if (!(srcData instanceof OGLSurfaceData)) {
                    return false;
                }
            }
            return (oglData = (OGLSurfaceData)srcData).getType() == 3;
        }
    }

    private static class Gradient
    extends OGLPaints {
        private Gradient() {
        }

        boolean isPaintValid(SunGraphics2D sg2d) {
            return true;
        }
    }
}

