/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.util.Dictionary;
import java.util.Enumeration;
import sun.misc.CacheEntry;
import sun.misc.CacheEnumerator;

public class Cache
extends Dictionary {
    private CacheEntry[] table;
    private int count;
    private int threshold;
    private float loadFactor;

    private void init(int initialCapacity, float loadFactor) {
        if (initialCapacity <= 0 || (double)loadFactor <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = loadFactor;
        this.table = new CacheEntry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public Cache(int initialCapacity, float loadFactor) {
        this.init(initialCapacity, loadFactor);
    }

    public Cache(int initialCapacity) {
        this.init(initialCapacity, 0.75f);
    }

    public Cache() {
        try {
            this.init(101, 0.75f);
        }
        catch (IllegalArgumentException ex) {
            throw new Error("panic");
        }
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public synchronized Enumeration keys() {
        return new CacheEnumerator(this.table, true);
    }

    public synchronized Enumeration elements() {
        return new CacheEnumerator(this.table, false);
    }

    public synchronized Object get(Object key) {
        CacheEntry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        CacheEntry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                return e.check();
            }
            e = e.next;
        }
        return null;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        CacheEntry[] oldTable = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        CacheEntry[] newTable = new CacheEntry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newTable;
        int i = oldCapacity;
        while (i-- > 0) {
            CacheEntry old = oldTable[i];
            while (old != null) {
                CacheEntry e = old;
                old = old.next;
                if (e.check() != null) {
                    int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                    e.next = newTable[index];
                    newTable[index] = e;
                    continue;
                }
                --this.count;
            }
        }
    }

    public synchronized Object put(Object key, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        CacheEntry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        CacheEntry ne = null;
        CacheEntry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                Object old = e.check();
                e.setThing(value);
                return old;
            }
            if (e.check() == null) {
                ne = e;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(key, value);
        }
        if (ne == null) {
            ne = new CacheEntry();
            ne.next = tab[index];
            tab[index] = ne;
            ++this.count;
        }
        ne.hash = hash;
        ne.key = key;
        ne.setThing(value);
        return null;
    }

    public synchronized Object remove(Object key) {
        CacheEntry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        CacheEntry e = tab[index];
        CacheEntry prev = null;
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                return e.check();
            }
            prev = e;
            e = e.next;
        }
        return null;
    }
}

