/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import sun.misc.OSEnvironment;
import sun.misc.VMNotification;

public class VM {
    private static boolean suspended = false;
    @Deprecated
    public static final int STATE_GREEN = 1;
    @Deprecated
    public static final int STATE_YELLOW = 2;
    @Deprecated
    public static final int STATE_RED = 3;
    private static volatile boolean booted = false;
    private static long directMemory = 0x4000000L;
    private static boolean defaultAllowArraySyntax;
    private static boolean allowArraySyntax;
    private static volatile int finalRefCount;
    private static volatile int peakFinalRefCount;
    private static Map<Integer, Thread.State> threadStateMap;
    private static Map<Integer, String> threadStateNames;

    @Deprecated
    public static boolean threadsSuspended() {
        return suspended;
    }

    public static boolean allowThreadSuspension(ThreadGroup g, boolean b) {
        return g.allowThreadSuspension(b);
    }

    @Deprecated
    public static boolean suspendThreads() {
        suspended = true;
        return true;
    }

    @Deprecated
    public static void unsuspendThreads() {
        suspended = false;
    }

    @Deprecated
    public static void unsuspendSomeThreads() {
    }

    @Deprecated
    public static final int getState() {
        return 1;
    }

    @Deprecated
    public static void registerVMNotification(VMNotification n) {
    }

    @Deprecated
    public static void asChange(int as_old, int as_new) {
    }

    @Deprecated
    public static void asChange_otherthread(int as_old, int as_new) {
    }

    public static void booted() {
        booted = true;
    }

    public static boolean isBooted() {
        return booted;
    }

    public static long maxDirectMemory() {
        if (booted) {
            return directMemory;
        }
        Properties p = System.getProperties();
        String s = (String)p.remove("sun.nio.MaxDirectMemorySize");
        System.setProperties(p);
        if (s != null) {
            if (s.equals("-1")) {
                directMemory = Runtime.getRuntime().maxMemory();
            } else {
                long l = Long.parseLong(s);
                if (l > -1L) {
                    directMemory = l;
                }
            }
        }
        return directMemory;
    }

    public static boolean allowArraySyntax() {
        if (!booted) {
            String s = System.getProperty("sun.lang.ClassLoader.allowArraySyntax");
            allowArraySyntax = s == null ? defaultAllowArraySyntax : Boolean.parseBoolean(s);
        }
        return allowArraySyntax;
    }

    public static void initializeOSEnvironment() {
        if (!booted) {
            OSEnvironment.initialize();
        }
    }

    public static int getFinalRefCount() {
        return finalRefCount;
    }

    public static int getPeakFinalRefCount() {
        return peakFinalRefCount;
    }

    public static void addFinalRefCount(int n) {
        if ((finalRefCount += n) > peakFinalRefCount) {
            peakFinalRefCount = finalRefCount;
        }
    }

    public static Thread.State toThreadState(int threadStatus) {
        VM.initThreadStateMap();
        Thread.State s = threadStateMap.get(threadStatus);
        if (s == null) {
            s = Thread.State.RUNNABLE;
        }
        return s;
    }

    private static synchronized void initThreadStateMap() {
        if (threadStateMap != null) {
            return;
        }
        Thread.State[] ts = Thread.State.values();
        int[][] vmThreadStateValues = new int[ts.length][];
        String[][] vmThreadStateNames = new String[ts.length][];
        VM.getThreadStateValues(vmThreadStateValues, vmThreadStateNames);
        threadStateMap = new HashMap<Integer, Thread.State>();
        threadStateNames = new HashMap<Integer, String>();
        for (int i = 0; i < ts.length; ++i) {
            String state = ts[i].name();
            int[] values = null;
            String[] names = null;
            for (int j = 0; j < ts.length; ++j) {
                if (!vmThreadStateNames[j][0].startsWith(state)) continue;
                values = vmThreadStateValues[j];
                names = vmThreadStateNames[j];
            }
            if (values == null) {
                throw new InternalError("No VM thread state mapped to " + state);
            }
            if (values.length != names.length) {
                throw new InternalError("VM thread state values and names  mapped to " + state + ": length not matched");
            }
            for (int k = 0; k < values.length; ++k) {
                threadStateMap.put(values[k], ts[i]);
                threadStateNames.put(values[k], names[k]);
            }
        }
    }

    private static native void getThreadStateValues(int[][] var0, String[][] var1);

    private static native void initialize();

    static {
        allowArraySyntax = defaultAllowArraySyntax = false;
        finalRefCount = 0;
        peakFinalRefCount = 0;
        threadStateMap = null;
        threadStateNames = null;
        VM.initialize();
    }
}

