/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import sun.net.ProgressSource;
import sun.net.www.http.ChunkedInputStream;

public class MeteredStream
extends FilterInputStream {
    protected boolean closed = false;
    protected int expected;
    protected int count = 0;
    protected int markedCount = 0;
    protected int markLimit = -1;
    protected ProgressSource pi;

    public MeteredStream(InputStream is, ProgressSource pi, int expected) {
        super(is);
        this.pi = pi;
        this.expected = expected;
        if (pi != null) {
            pi.updateProgress(0, expected);
        }
    }

    private final void justRead(int n) throws IOException {
        if (n == -1) {
            if (!this.isMarked()) {
                this.close();
            }
            return;
        }
        this.count += n;
        if (this.count - this.markedCount > this.markLimit) {
            this.markLimit = -1;
        }
        if (this.pi != null) {
            this.pi.updateProgress(this.count, this.expected);
        }
        if (this.isMarked()) {
            return;
        }
        if (this.expected > 0 && this.count >= this.expected) {
            this.close();
        }
    }

    private boolean isMarked() {
        if (this.markLimit < 0) {
            return false;
        }
        return this.count - this.markedCount <= this.markLimit;
    }

    public synchronized int read() throws IOException {
        if (this.closed) {
            return -1;
        }
        int c = this.in.read();
        if (c != -1) {
            this.justRead(1);
        } else {
            this.justRead(c);
        }
        return c;
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            return -1;
        }
        int n = this.in.read(b, off, len);
        this.justRead(n);
        return n;
    }

    public synchronized long skip(long n) throws IOException {
        if (this.closed) {
            return 0L;
        }
        if (this.in instanceof ChunkedInputStream) {
            n = this.in.skip(n);
        } else {
            int min = n > (long)(this.expected - this.count) ? this.expected - this.count : (int)n;
            n = this.in.skip(min);
        }
        this.justRead((int)n);
        return n;
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.pi != null) {
            this.pi.finishTracking();
        }
        this.closed = true;
        this.in.close();
    }

    public synchronized int available() throws IOException {
        return this.closed ? 0 : this.in.available();
    }

    public synchronized void mark(int readLimit) {
        if (this.closed) {
            return;
        }
        super.mark(readLimit);
        this.markedCount = this.count;
        this.markLimit = readLimit;
    }

    public synchronized void reset() throws IOException {
        if (this.closed) {
            return;
        }
        if (!this.isMarked()) {
            throw new IOException("Resetting to an invalid mark");
        }
        this.count = this.markedCount;
        super.reset();
    }

    public boolean markSupported() {
        if (this.closed) {
            return false;
        }
        return super.markSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
            if (this.pi != null) {
                this.pi.close();
            }
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }
}

