/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageObserver;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.VolatileImage;
import java.awt.image.WritableRaster;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.lang.ref.SoftReference;
import java.text.AttributedCharacterIterator;
import java.util.Hashtable;
import java.util.Map;
import sun.awt.image.SunWritableRaster;
import sun.awt.image.ToolkitImage;
import sun.font.CompositeFont;
import sun.font.Font2D;
import sun.font.Font2DHandle;
import sun.font.FontManager;
import sun.font.PhysicalFont;
import sun.print.ProxyGraphics2D;
import sun.print.RasterPrinterJob;

public abstract class PathGraphics
extends ProxyGraphics2D {
    private Printable mPainter;
    private PageFormat mPageFormat;
    private int mPageIndex;
    private boolean mCanRedraw;
    protected boolean printingGlyphVector;
    protected static SoftReference<Hashtable<Font2DHandle, Object>> fontMapRef = new SoftReference<Object>(null);

    protected PathGraphics(Graphics2D graphics, PrinterJob printerJob, Printable painter, PageFormat pageFormat, int pageIndex, boolean canRedraw) {
        super(graphics, printerJob);
        this.mPainter = painter;
        this.mPageFormat = pageFormat;
        this.mPageIndex = pageIndex;
        this.mCanRedraw = canRedraw;
    }

    protected Printable getPrintable() {
        return this.mPainter;
    }

    protected PageFormat getPageFormat() {
        return this.mPageFormat;
    }

    protected int getPageIndex() {
        return this.mPageIndex;
    }

    public boolean canDoRedraws() {
        return this.mCanRedraw;
    }

    public abstract void redrawRegion(Rectangle2D var1, double var2, double var4, Shape var6, AffineTransform var7) throws PrinterException;

    public void drawLine(int x1, int y1, int x2, int y2) {
        Paint paint = this.getPaint();
        try {
            AffineTransform deviceTransform = this.getTransform();
            if (this.getClip() != null) {
                this.deviceClip(this.getClip().getPathIterator(deviceTransform));
            }
            this.deviceDrawLine(x1, y1, x2, y2, (Color)paint);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Expected a Color instance");
        }
    }

    public void drawRect(int x, int y, int width, int height) {
        Paint paint = this.getPaint();
        try {
            AffineTransform deviceTransform = this.getTransform();
            if (this.getClip() != null) {
                this.deviceClip(this.getClip().getPathIterator(deviceTransform));
            }
            this.deviceFrameRect(x, y, width, height, (Color)paint);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Expected a Color instance");
        }
    }

    public void fillRect(int x, int y, int width, int height) {
        Paint paint = this.getPaint();
        try {
            AffineTransform deviceTransform = this.getTransform();
            if (this.getClip() != null) {
                this.deviceClip(this.getClip().getPathIterator(deviceTransform));
            }
            this.deviceFillRect(x, y, width, height, (Color)paint);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Expected a Color instance");
        }
    }

    public void clearRect(int x, int y, int width, int height) {
        this.fill(new Rectangle2D.Float(x, y, width, height), this.getBackground());
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.draw(new RoundRectangle2D.Float(x, y, width, height, arcWidth, arcHeight));
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.fill(new RoundRectangle2D.Float(x, y, width, height, arcWidth, arcHeight));
    }

    public void drawOval(int x, int y, int width, int height) {
        this.draw(new Ellipse2D.Float(x, y, width, height));
    }

    public void fillOval(int x, int y, int width, int height) {
        this.fill(new Ellipse2D.Float(x, y, width, height));
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.draw(new Arc2D.Float(x, y, width, height, startAngle, arcAngle, 0));
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.fill(new Arc2D.Float(x, y, width, height, startAngle, arcAngle, 2));
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        if (nPoints > 0) {
            float fromX = xPoints[0];
            float fromY = yPoints[0];
            for (int i = 1; i < nPoints; ++i) {
                float toX = xPoints[i];
                float toY = yPoints[i];
                this.draw(new Line2D.Float(fromX, fromY, toX, toY));
                fromX = toX;
                fromY = toY;
            }
        }
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.draw(new Polygon(xPoints, yPoints, nPoints));
    }

    public void drawPolygon(Polygon p) {
        this.draw(p);
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.fill(new Polygon(xPoints, yPoints, nPoints));
    }

    public void fillPolygon(Polygon p) {
        this.fill(p);
    }

    public void drawString(String str, int x, int y) {
        this.drawString(str, (float)x, (float)y);
    }

    public void drawString(String str, float x, float y) {
        if (str.length() == 0) {
            return;
        }
        TextLayout layout = new TextLayout(str, this.getFont(), this.getFontRenderContext());
        layout.draw(this, x, y);
    }

    protected void drawString(String str, float x, float y, Font font, FontRenderContext frc, float w) {
        TextLayout layout = new TextLayout(str, font, frc);
        Shape textShape = layout.getOutline(AffineTransform.getTranslateInstance(x, y));
        this.fill(textShape);
    }

    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.drawString(iterator, (float)x, (float)y);
    }

    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        if (iterator == null) {
            throw new NullPointerException("attributedcharacteriterator is null");
        }
        TextLayout layout = new TextLayout(iterator, this.getFontRenderContext());
        layout.draw(this, x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawGlyphVector(GlyphVector g, float x, float y) {
        if (this.printingGlyphVector) {
            assert (!this.printingGlyphVector);
            this.fill(g.getOutline(x, y));
            return;
        }
        try {
            this.printingGlyphVector = true;
            if (RasterPrinterJob.shapeTextProp || !this.printedSimpleGlyphVector(g, x, y)) {
                this.fill(g.getOutline(x, y));
            }
        }
        finally {
            this.printingGlyphVector = false;
        }
    }

    protected int platformFontCount(Font font, String str) {
        return 0;
    }

    protected boolean printGlyphVector(GlyphVector gv, float x, float y) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean printedSimpleGlyphVector(GlyphVector g, float x, float y) {
        int flags = g.getLayoutFlags();
        if (flags != 0 && flags != 2) {
            return this.printGlyphVector(g, x, y);
        }
        Font font = g.getFont();
        Font2D font2D = FontManager.getFont2D(font);
        if (font2D.handle.font2D != font2D) {
            return false;
        }
        Class<PathGraphics> clazz = PathGraphics.class;
        synchronized (PathGraphics.class) {
            String str;
            int numFonts;
            FontRenderContext gvFrc;
            GlyphVector gv2;
            int gc;
            int i;
            Hashtable<Font2DHandle, Object> fontMap = fontMapRef.get();
            if (fontMap == null) {
                fontMap = new Hashtable();
                fontMapRef = new SoftReference<Hashtable<Font2DHandle, Object>>(fontMap);
            }
            // ** MonitorExit[var8_7] (shouldn't be in output)
            int numGlyphs = g.getNumGlyphs();
            int[] glyphCodes = g.getGlyphCodes(0, numGlyphs, null);
            char[] glyphToCharMap = null;
            Object mapArray = null;
            CompositeFont cf = null;
            Hashtable<Font2DHandle, Object> hashtable = fontMap;
            synchronized (hashtable) {
                if (font2D instanceof CompositeFont) {
                    cf = (CompositeFont)font2D;
                    int numSlots = cf.getNumSlots();
                    mapArray = (char[][])fontMap.get(font2D.handle);
                    if (mapArray == null) {
                        mapArray = new char[numSlots][];
                        fontMap.put(font2D.handle, mapArray);
                    }
                    for (int i2 = 0; i2 < numGlyphs; ++i2) {
                        int slot = glyphCodes[i2] >>> 24;
                        if (slot >= numSlots) {
                            return false;
                        }
                        if (mapArray[slot] != null) continue;
                        PhysicalFont slotFont = cf.getSlotFont(slot);
                        char[] map = (char[])fontMap.get(slotFont.handle);
                        if (map == null) {
                            map = PathGraphics.getGlyphToCharMapForFont(slotFont);
                        }
                        mapArray[slot] = map;
                    }
                } else {
                    glyphToCharMap = (char[])fontMap.get(font2D.handle);
                    if (glyphToCharMap == null) {
                        glyphToCharMap = PathGraphics.getGlyphToCharMapForFont(font2D);
                        fontMap.put(font2D.handle, glyphToCharMap);
                    }
                }
            }
            char[] chars = new char[numGlyphs];
            if (cf != null) {
                for (i = 0; i < numGlyphs; ++i) {
                    int ch;
                    gc = glyphCodes[i];
                    char[] map = mapArray[gc >>> 24];
                    gc &= 0xFFFFFF;
                    if (map == null) {
                        return false;
                    }
                    if (gc == 65535) {
                        ch = 10;
                    } else {
                        if (gc < 0 || gc >= map.length) {
                            return false;
                        }
                        ch = map[gc];
                    }
                    if (ch == 65535) {
                        return false;
                    }
                    chars[i] = ch;
                }
            } else {
                for (i = 0; i < numGlyphs; ++i) {
                    int ch;
                    gc = glyphCodes[i];
                    if (gc == 65535) {
                        ch = 10;
                    } else {
                        if (gc < 0 || gc >= glyphToCharMap.length) {
                            return false;
                        }
                        ch = glyphToCharMap[gc];
                    }
                    if (ch == 65535) {
                        return false;
                    }
                    chars[i] = ch;
                }
            }
            if ((gv2 = font.createGlyphVector(gvFrc = g.getFontRenderContext(), chars)).getNumGlyphs() != numGlyphs) {
                return this.printGlyphVector(g, x, y);
            }
            int[] glyphCodes2 = gv2.getGlyphCodes(0, numGlyphs, null);
            for (int i3 = 0; i3 < numGlyphs; ++i3) {
                if (glyphCodes[i3] == glyphCodes2[i3]) continue;
                return this.printGlyphVector(g, x, y);
            }
            FontRenderContext g2dFrc = this.getFontRenderContext();
            boolean compatibleFRC = gvFrc.equals(g2dFrc);
            if (!compatibleFRC && gvFrc.usesFractionalMetrics() == g2dFrc.usesFractionalMetrics()) {
                AffineTransform gvAT = gvFrc.getTransform();
                AffineTransform g2dAT = this.getTransform();
                double[] gvMatrix = new double[4];
                double[] g2dMatrix = new double[4];
                gvAT.getMatrix(gvMatrix);
                g2dAT.getMatrix(g2dMatrix);
                compatibleFRC = true;
                for (int i4 = 0; i4 < 4; ++i4) {
                    if (gvMatrix[i4] == g2dMatrix[i4]) continue;
                    compatibleFRC = false;
                    break;
                }
            }
            if ((numFonts = this.platformFontCount(font, str = new String(chars, 0, numGlyphs))) == 0) {
                return false;
            }
            float[] positions = g.getGlyphPositions(0, numGlyphs, null);
            boolean noPositionAdjustments = (flags & 2) == 0 || this.samePositions(gv2, glyphCodes2, glyphCodes, positions);
            Point2D gvAdvancePt = g.getGlyphPosition(numGlyphs);
            float gvAdvanceX = (float)gvAdvancePt.getX();
            boolean layoutAffectsAdvance = false;
            if (font.hasLayoutAttributes() && this.printingGlyphVector && noPositionAdjustments) {
                boolean tracking;
                Map<TextAttribute, ?> map = font.getAttributes();
                Object o = map.get(TextAttribute.TRACKING);
                boolean bl = tracking = o != null && o instanceof Number && ((Number)o).floatValue() != 0.0f;
                if (tracking) {
                    noPositionAdjustments = false;
                } else {
                    Rectangle2D bounds = font.getStringBounds(str, gvFrc);
                    float strAdvanceX = (float)bounds.getWidth();
                    if ((double)Math.abs(strAdvanceX - gvAdvanceX) > 1.0E-5) {
                        layoutAffectsAdvance = true;
                    }
                }
            }
            if (compatibleFRC && noPositionAdjustments && !layoutAffectsAdvance) {
                this.drawString(str, x, y, font, gvFrc, 0.0f);
                return true;
            }
            if (numFonts == 1 && this.canDrawStringToWidth() && noPositionAdjustments) {
                this.drawString(str, x, y, font, gvFrc, gvAdvanceX);
                return true;
            }
            if (FontManager.isComplexText(chars, 0, chars.length)) {
                return this.printGlyphVector(g, x, y);
            }
            if (numGlyphs > 10 && this.printGlyphVector(g, x, y)) {
                return true;
            }
            for (int i5 = 0; i5 < numGlyphs; ++i5) {
                String s = new String(chars, i5, 1);
                this.drawString(s, x + positions[i5 * 2], y + positions[i5 * 2 + 1], font, gvFrc, 0.0f);
            }
            return true;
        }
    }

    private boolean samePositions(GlyphVector gv, int[] gvcodes, int[] origCodes, float[] origPositions) {
        int numGlyphs = gv.getNumGlyphs();
        float[] gvpos = gv.getGlyphPositions(0, numGlyphs, null);
        if (numGlyphs != gvcodes.length || origCodes.length != gvcodes.length || origPositions.length != gvpos.length) {
            return false;
        }
        for (int i = 0; i < numGlyphs; ++i) {
            if (gvcodes[i] == origCodes[i] && gvpos[i] == origPositions[i]) continue;
            return false;
        }
        return true;
    }

    protected boolean canDrawStringToWidth() {
        return false;
    }

    private static char[] getGlyphToCharMapForFont(Font2D font2D) {
        int numGlyphs = font2D.getNumGlyphs();
        int missingGlyph = font2D.getMissingGlyphCode();
        char[] glyphToCharMap = new char[numGlyphs];
        for (int i = 0; i < numGlyphs; ++i) {
            glyphToCharMap[i] = 65535;
        }
        for (int c = 0; c < 65535; c = (int)((char)(c + 1))) {
            int glyph;
            if (c >= 55296 && c <= 57343 || (glyph = font2D.charToGlyph(c)) == missingGlyph || glyph >= numGlyphs || glyphToCharMap[glyph] != '\uffff') continue;
            glyphToCharMap[glyph] = c;
        }
        return glyphToCharMap;
    }

    public void draw(Shape s) {
        this.fill(this.getStroke().createStrokedShape(s));
    }

    public void fill(Shape s) {
        Paint paint = this.getPaint();
        try {
            this.fill(s, (Color)paint);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Expected a Color instance");
        }
    }

    public void fill(Shape s, Color color) {
        AffineTransform deviceTransform = this.getTransform();
        if (this.getClip() != null) {
            this.deviceClip(this.getClip().getPathIterator(deviceTransform));
        }
        this.deviceFill(s.getPathIterator(deviceTransform), color);
    }

    protected abstract void deviceFill(PathIterator var1, Color var2);

    protected abstract void deviceClip(PathIterator var1);

    protected abstract void deviceFrameRect(int var1, int var2, int var3, int var4, Color var5);

    protected abstract void deviceDrawLine(int var1, int var2, int var3, int var4, Color var5);

    protected abstract void deviceFillRect(int var1, int var2, int var3, int var4, Color var5);

    protected BufferedImage getBufferedImage(Image img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        if (img instanceof ToolkitImage) {
            return ((ToolkitImage)img).getBufferedImage();
        }
        if (img instanceof VolatileImage) {
            return ((VolatileImage)img).getSnapshot();
        }
        return null;
    }

    protected boolean hasTransparentPixels(BufferedImage bufferedImage) {
        boolean hasTransparency;
        ColorModel colorModel = bufferedImage.getColorModel();
        boolean bl = colorModel == null ? true : (hasTransparency = colorModel.getTransparency() != 1);
        if (hasTransparency && bufferedImage != null && (bufferedImage.getType() == 2 || bufferedImage.getType() == 3)) {
            DataBuffer db = bufferedImage.getRaster().getDataBuffer();
            SampleModel sm = bufferedImage.getRaster().getSampleModel();
            if (db instanceof DataBufferInt && sm instanceof SinglePixelPackedSampleModel) {
                SinglePixelPackedSampleModel psm = (SinglePixelPackedSampleModel)sm;
                int[] int_data = SunWritableRaster.stealData((DataBufferInt)db, 0);
                int x = bufferedImage.getMinX();
                int y = bufferedImage.getMinY();
                int w = bufferedImage.getWidth();
                int h = bufferedImage.getHeight();
                int stride = psm.getScanlineStride();
                boolean hastranspixel = false;
                for (int j = y; j < y + h; ++j) {
                    int yoff = j * stride;
                    for (int i = x; i < x + w; ++i) {
                        if ((int_data[yoff + i] & 0xFF000000) == -16777216) continue;
                        hastranspixel = true;
                        break;
                    }
                    if (hastranspixel) break;
                }
                if (!hastranspixel) {
                    hasTransparency = false;
                }
            }
        }
        return hasTransparency;
    }

    protected boolean isBitmaskTransparency(BufferedImage bufferedImage) {
        ColorModel colorModel = bufferedImage.getColorModel();
        return colorModel != null && colorModel.getTransparency() == 2;
    }

    protected boolean drawBitmaskImage(BufferedImage bufferedImage, AffineTransform xform, Color bgcolor, int srcX, int srcY, int srcWidth, int srcHeight) {
        int hgt;
        int bottom;
        int wid;
        int right;
        ColorModel colorModel = bufferedImage.getColorModel();
        if (!(colorModel instanceof IndexColorModel)) {
            return false;
        }
        IndexColorModel icm = (IndexColorModel)colorModel;
        if (colorModel.getTransparency() != 2) {
            return false;
        }
        if (bgcolor != null && bgcolor.getAlpha() < 128) {
            return false;
        }
        if ((xform.getType() & 0xFFFFFFF4) != 0) {
            return false;
        }
        if ((this.getTransform().getType() & 0xFFFFFFF4) != 0) {
            return false;
        }
        BufferedImage subImage = null;
        WritableRaster raster = bufferedImage.getRaster();
        int transpixel = icm.getTransparentPixel();
        byte[] alphas = new byte[icm.getMapSize()];
        icm.getAlphas(alphas);
        if (transpixel >= 0) {
            alphas[transpixel] = 0;
        }
        int rw = raster.getWidth();
        int rh = raster.getHeight();
        if (srcX > rw || srcY > rh) {
            return false;
        }
        if (srcX + srcWidth > rw) {
            right = rw;
            wid = right - srcX;
        } else {
            right = srcX + srcWidth;
            wid = srcWidth;
        }
        if (srcY + srcHeight > rh) {
            bottom = rh;
            hgt = bottom - srcY;
        } else {
            bottom = srcY + srcHeight;
            hgt = srcHeight;
        }
        int[] pixels = new int[wid];
        for (int j = srcY; j < bottom; ++j) {
            int startx = -1;
            raster.getPixels(srcX, j, wid, 1, pixels);
            for (int i = srcX; i < right; ++i) {
                if (alphas[pixels[i - srcX]] == 0) {
                    if (startx < 0) continue;
                    subImage = bufferedImage.getSubimage(startx, j, i - startx, 1);
                    xform.translate(startx, j);
                    this.drawImageToPlatform(subImage, xform, bgcolor, 0, 0, i - startx, 1, true);
                    xform.translate(-startx, -j);
                    startx = -1;
                    continue;
                }
                if (startx >= 0) continue;
                startx = i;
            }
            if (startx < 0) continue;
            subImage = bufferedImage.getSubimage(startx, j, right - startx, 1);
            xform.translate(startx, j);
            this.drawImageToPlatform(subImage, xform, bgcolor, 0, 0, right - startx, 1, true);
            xform.translate(-startx, -j);
        }
        return true;
    }

    protected abstract boolean drawImageToPlatform(Image var1, AffineTransform var2, Color var3, int var4, int var5, int var6, int var7, boolean var8);

    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return this.drawImage(img, x, y, null, observer);
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return this.drawImage(img, x, y, width, height, null, observer);
    }

    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        if (img == null) {
            return true;
        }
        int srcWidth = img.getWidth(null);
        int srcHeight = img.getHeight(null);
        boolean result = srcWidth < 0 || srcHeight < 0 ? false : this.drawImage(img, x, y, srcWidth, srcHeight, bgcolor, observer);
        return result;
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        if (img == null) {
            return true;
        }
        int srcWidth = img.getWidth(null);
        int srcHeight = img.getHeight(null);
        boolean result = srcWidth < 0 || srcHeight < 0 ? false : this.drawImage(img, x, y, x + width, y + height, 0, 0, srcWidth, srcHeight, observer);
        return result;
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return this.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null, observer);
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        if (img == null) {
            return true;
        }
        int imgWidth = img.getWidth(null);
        int imgHeight = img.getHeight(null);
        if (imgWidth < 0 || imgHeight < 0) {
            return true;
        }
        int srcWidth = sx2 - sx1;
        int srcHeight = sy2 - sy1;
        float scalex = (float)(dx2 - dx1) / (float)srcWidth;
        float scaley = (float)(dy2 - dy1) / (float)srcHeight;
        AffineTransform xForm = new AffineTransform(scalex, 0.0f, 0.0f, scaley, (float)dx1 - (float)sx1 * scalex, (float)dy1 - (float)sy1 * scaley);
        int tmp = 0;
        if (sx2 < sx1) {
            tmp = sx1;
            sx1 = sx2;
            sx2 = tmp;
        }
        if (sy2 < sy1) {
            tmp = sy1;
            sy1 = sy2;
            sy2 = tmp;
        }
        if (sx1 < 0) {
            sx1 = 0;
        } else if (sx1 > imgWidth) {
            sx1 = imgWidth;
        }
        if (sx2 < 0) {
            sx2 = 0;
        } else if (sx2 > imgWidth) {
            sx2 = imgWidth;
        }
        if (sy1 < 0) {
            sy1 = 0;
        } else if (sy1 > imgHeight) {
            sy1 = imgHeight;
        }
        if (sy2 < 0) {
            sy2 = 0;
        } else if (sy2 > imgHeight) {
            sy2 = imgHeight;
        }
        srcWidth = sx2 - sx1;
        srcHeight = sy2 - sy1;
        if (srcWidth <= 0 || srcHeight <= 0) {
            return true;
        }
        return this.drawImageToPlatform(img, xForm, bgcolor, sx1, sy1, srcWidth, srcHeight, false);
    }

    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        if (img == null) {
            return true;
        }
        int srcWidth = img.getWidth(null);
        int srcHeight = img.getHeight(null);
        boolean result = srcWidth < 0 || srcHeight < 0 ? false : this.drawImageToPlatform(img, xform, null, 0, 0, srcWidth, srcHeight, false);
        return result;
    }

    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        if (img == null) {
            return;
        }
        int srcWidth = img.getWidth(null);
        int srcHeight = img.getHeight(null);
        if (op != null) {
            img = op.filter(img, null);
        }
        if (srcWidth <= 0 || srcHeight <= 0) {
            return;
        }
        AffineTransform xform = new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, x, y);
        this.drawImageToPlatform(img, xform, null, 0, 0, srcWidth, srcHeight, false);
    }

    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        if (img == null) {
            return;
        }
        BufferedImage bufferedImage = null;
        int srcWidth = img.getWidth();
        int srcHeight = img.getHeight();
        if (srcWidth <= 0 || srcHeight <= 0) {
            return;
        }
        if (img instanceof BufferedImage) {
            bufferedImage = (BufferedImage)img;
        } else {
            bufferedImage = new BufferedImage(srcWidth, srcHeight, 2);
            Graphics2D imageGraphics = bufferedImage.createGraphics();
            imageGraphics.drawRenderedImage(img, xform);
        }
        this.drawImageToPlatform(bufferedImage, xform, null, 0, 0, srcWidth, srcHeight, false);
    }
}

