/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect;

import java.lang.reflect.Field;
import sun.reflect.UnsafeQualifiedFieldAccessorImpl;

class UnsafeQualifiedLongFieldAccessorImpl
extends UnsafeQualifiedFieldAccessorImpl {
    UnsafeQualifiedLongFieldAccessorImpl(Field field, boolean isReadOnly) {
        super(field, isReadOnly);
    }

    public Object get(Object obj) throws IllegalArgumentException {
        return new Long(this.getLong(obj));
    }

    public boolean getBoolean(Object obj) throws IllegalArgumentException {
        throw this.newGetBooleanIllegalArgumentException();
    }

    public byte getByte(Object obj) throws IllegalArgumentException {
        throw this.newGetByteIllegalArgumentException();
    }

    public char getChar(Object obj) throws IllegalArgumentException {
        throw this.newGetCharIllegalArgumentException();
    }

    public short getShort(Object obj) throws IllegalArgumentException {
        throw this.newGetShortIllegalArgumentException();
    }

    public int getInt(Object obj) throws IllegalArgumentException {
        throw this.newGetIntIllegalArgumentException();
    }

    public long getLong(Object obj) throws IllegalArgumentException {
        this.ensureObj(obj);
        return unsafe.getLongVolatile(obj, this.fieldOffset);
    }

    public float getFloat(Object obj) throws IllegalArgumentException {
        return this.getLong(obj);
    }

    public double getDouble(Object obj) throws IllegalArgumentException {
        return this.getLong(obj);
    }

    public void set(Object obj, Object value) throws IllegalArgumentException, IllegalAccessException {
        this.ensureObj(obj);
        if (this.isReadOnly) {
            this.throwFinalFieldIllegalAccessException(value);
        }
        if (value == null) {
            this.throwSetIllegalArgumentException(value);
        }
        if (value instanceof Byte) {
            unsafe.putLongVolatile(obj, this.fieldOffset, ((Byte)value).byteValue());
            return;
        }
        if (value instanceof Short) {
            unsafe.putLongVolatile(obj, this.fieldOffset, ((Short)value).shortValue());
            return;
        }
        if (value instanceof Character) {
            unsafe.putLongVolatile(obj, this.fieldOffset, ((Character)value).charValue());
            return;
        }
        if (value instanceof Integer) {
            unsafe.putLongVolatile(obj, this.fieldOffset, ((Integer)value).intValue());
            return;
        }
        if (value instanceof Long) {
            unsafe.putLongVolatile(obj, this.fieldOffset, (Long)value);
            return;
        }
        this.throwSetIllegalArgumentException(value);
    }

    public void setBoolean(Object obj, boolean z) throws IllegalArgumentException, IllegalAccessException {
        this.throwSetIllegalArgumentException(z);
    }

    public void setByte(Object obj, byte b) throws IllegalArgumentException, IllegalAccessException {
        this.setLong(obj, b);
    }

    public void setChar(Object obj, char c) throws IllegalArgumentException, IllegalAccessException {
        this.setLong(obj, c);
    }

    public void setShort(Object obj, short s) throws IllegalArgumentException, IllegalAccessException {
        this.setLong(obj, s);
    }

    public void setInt(Object obj, int i) throws IllegalArgumentException, IllegalAccessException {
        this.setLong(obj, i);
    }

    public void setLong(Object obj, long l) throws IllegalArgumentException, IllegalAccessException {
        this.ensureObj(obj);
        if (this.isReadOnly) {
            this.throwFinalFieldIllegalAccessException(l);
        }
        unsafe.putLongVolatile(obj, this.fieldOffset, l);
    }

    public void setFloat(Object obj, float f) throws IllegalArgumentException, IllegalAccessException {
        this.throwSetIllegalArgumentException(f);
    }

    public void setDouble(Object obj, double d) throws IllegalArgumentException, IllegalAccessException {
        this.throwSetIllegalArgumentException(d);
    }
}

