/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.log;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.rmi.log.LogHandler;
import sun.rmi.log.LogInputStream;
import sun.rmi.log.LogOutputStream;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetPropertyAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReliableLog {
    public static final int PreferredMajorVersion = 0;
    public static final int PreferredMinorVersion = 2;
    private boolean Debug = false;
    private static String snapshotPrefix = "Snapshot.";
    private static String logfilePrefix = "Logfile.";
    private static String versionFile = "Version_Number";
    private static String newVersionFile = "New_Version_Number";
    private static int intBytes = 4;
    private static long diskPageSize = 512L;
    private File dir;
    private int version = 0;
    private String logName = null;
    private LogFile log = null;
    private long snapshotBytes = 0L;
    private long logBytes = 0L;
    private int logEntries = 0;
    private long lastSnapshot = 0L;
    private long lastLog = 0L;
    private LogHandler handler;
    private final byte[] intBuf = new byte[4];
    private int majorFormatVersion = 0;
    private int minorFormatVersion = 0;
    private static final Constructor<? extends LogFile> logClassConstructor = ReliableLog.getLogClassConstructor();

    public ReliableLog(String dirPath, LogHandler handler, boolean pad) throws IOException {
        this.Debug = AccessController.doPrivileged(new GetBooleanAction("sun.rmi.log.debug"));
        this.dir = new File(dirPath);
        if (!(this.dir.exists() && this.dir.isDirectory() || this.dir.mkdir())) {
            throw new IOException("could not create directory for log: " + dirPath);
        }
        this.handler = handler;
        this.lastSnapshot = 0L;
        this.lastLog = 0L;
        this.getVersion();
        if (this.version == 0) {
            try {
                this.snapshot(handler.initialSnapshot());
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException("initial snapshot failed with exception: " + e);
            }
        }
    }

    public ReliableLog(String dirPath, LogHandler handler) throws IOException {
        this(dirPath, handler, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object recover() throws IOException {
        Object snapshot;
        if (this.Debug) {
            System.err.println("log.debug: recover()");
        }
        if (this.version == 0) {
            return null;
        }
        String fname = this.versionName(snapshotPrefix);
        File snapshotFile = new File(fname);
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(snapshotFile));
        if (this.Debug) {
            System.err.println("log.debug: recovering from " + fname);
        }
        try {
            try {
                snapshot = this.handler.recover(in);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                if (this.Debug) {
                    System.err.println("log.debug: recovery failed: " + e);
                }
                throw new IOException("log recover failed with exception: " + e);
            }
            this.snapshotBytes = snapshotFile.length();
        }
        finally {
            ((InputStream)in).close();
        }
        return this.recoverUpdates(snapshot);
    }

    public synchronized void update(Object value) throws IOException {
        this.update(value, true);
    }

    public synchronized void update(Object value, boolean forceToDisk) throws IOException {
        if (this.log == null) {
            throw new IOException("log is inaccessible, it may have been corrupted or closed");
        }
        long entryStart = this.log.getFilePointer();
        boolean spansBoundary = this.log.checkSpansBoundary(entryStart);
        this.writeInt(this.log, spansBoundary ? Integer.MIN_VALUE : 0);
        try {
            this.handler.writeUpdate(new LogOutputStream(this.log), value);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw (IOException)new IOException("write update failed").initCause(e);
        }
        this.log.sync();
        long entryEnd = this.log.getFilePointer();
        int updateLen = (int)(entryEnd - entryStart - (long)intBytes);
        this.log.seek(entryStart);
        if (spansBoundary) {
            this.writeInt(this.log, updateLen | Integer.MIN_VALUE);
            this.log.sync();
            this.log.seek(entryStart);
            this.log.writeByte(updateLen >> 24);
            this.log.sync();
        } else {
            this.writeInt(this.log, updateLen);
            this.log.sync();
        }
        this.log.seek(entryEnd);
        this.logBytes = entryEnd;
        this.lastLog = System.currentTimeMillis();
        ++this.logEntries;
    }

    private static Constructor<? extends LogFile> getLogClassConstructor() {
        String logClassName = AccessController.doPrivileged(new GetPropertyAction("sun.rmi.log.class"));
        if (logClassName != null) {
            try {
                ClassLoader loader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        return ClassLoader.getSystemClassLoader();
                    }
                });
                Class<?> cl = loader.loadClass(logClassName);
                if (LogFile.class.isAssignableFrom(cl)) {
                    return cl.getConstructor(String.class, String.class);
                }
            }
            catch (Exception e) {
                System.err.println("Exception occurred:");
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void snapshot(Object value) throws IOException {
        int oldVersion = this.version;
        this.incrVersion();
        String fname = this.versionName(snapshotPrefix);
        File snapshotFile = new File(fname);
        FileOutputStream out = new FileOutputStream(snapshotFile);
        try {
            try {
                this.handler.snapshot(out, value);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException("snapshot failed with exception of type: " + e.getClass().getName() + ", message was: " + e.getMessage());
            }
            this.lastSnapshot = System.currentTimeMillis();
        }
        finally {
            out.close();
            this.snapshotBytes = snapshotFile.length();
        }
        this.openLogFile(true);
        this.writeVersionFile(true);
        this.commitToNewVersion();
        this.deleteSnapshot(oldVersion);
        this.deleteLogFile(oldVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws IOException {
        if (this.log == null) {
            return;
        }
        try {
            this.log.close();
        }
        finally {
            this.log = null;
        }
    }

    public long snapshotSize() {
        return this.snapshotBytes;
    }

    public long logSize() {
        return this.logBytes;
    }

    private void writeInt(DataOutput out, int val) throws IOException {
        this.intBuf[0] = (byte)(val >> 24);
        this.intBuf[1] = (byte)(val >> 16);
        this.intBuf[2] = (byte)(val >> 8);
        this.intBuf[3] = (byte)val;
        out.write(this.intBuf);
    }

    private String fName(String name) {
        return this.dir.getPath() + File.separator + name;
    }

    private String versionName(String name) {
        return this.versionName(name, 0);
    }

    private String versionName(String prefix, int ver) {
        ver = ver == 0 ? this.version : ver;
        return this.fName(prefix) + String.valueOf(ver);
    }

    private void incrVersion() {
        do {
            ++this.version;
        } while (this.version == 0);
    }

    private void deleteFile(String name) throws IOException {
        File f = new File(name);
        if (!f.delete()) {
            throw new IOException("couldn't remove file: " + name);
        }
    }

    private void deleteNewVersionFile() throws IOException {
        this.deleteFile(this.fName(newVersionFile));
    }

    private void deleteSnapshot(int ver) throws IOException {
        if (ver == 0) {
            return;
        }
        this.deleteFile(this.versionName(snapshotPrefix, ver));
    }

    private void deleteLogFile(int ver) throws IOException {
        if (ver == 0) {
            return;
        }
        this.deleteFile(this.versionName(logfilePrefix, ver));
    }

    private void openLogFile(boolean truncate) throws IOException {
        try {
            this.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        this.logName = this.versionName(logfilePrefix);
        try {
            this.log = logClassConstructor == null ? new LogFile(this.logName, "rw") : logClassConstructor.newInstance(this.logName, "rw");
        }
        catch (Exception e) {
            throw (IOException)new IOException("unable to construct LogFile instance").initCause(e);
        }
        if (truncate) {
            this.initializeLogFile();
        }
    }

    private void initializeLogFile() throws IOException {
        this.log.setLength(0L);
        this.majorFormatVersion = 0;
        this.writeInt(this.log, 0);
        this.minorFormatVersion = 2;
        this.writeInt(this.log, 2);
        this.logBytes = intBytes * 2;
        this.logEntries = 0;
    }

    private void writeVersionFile(boolean newVersion) throws IOException {
        String name = newVersion ? newVersionFile : versionFile;
        DataOutputStream out = new DataOutputStream(new FileOutputStream(this.fName(name)));
        this.writeInt(out, this.version);
        out.close();
    }

    private void createFirstVersion() throws IOException {
        this.version = 0;
        this.writeVersionFile(false);
    }

    private void commitToNewVersion() throws IOException {
        this.writeVersionFile(false);
        this.deleteNewVersionFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readVersion(String name) throws IOException {
        DataInputStream in = new DataInputStream(new FileInputStream(name));
        try {
            int n = in.readInt();
            return n;
        }
        finally {
            in.close();
        }
    }

    private void getVersion() throws IOException {
        try {
            this.version = this.readVersion(this.fName(newVersionFile));
            this.commitToNewVersion();
        }
        catch (IOException e) {
            try {
                this.deleteNewVersionFile();
            }
            catch (IOException ex) {
                // empty catch block
            }
            try {
                this.version = this.readVersion(this.fName(versionFile));
            }
            catch (IOException ex) {
                this.createFirstVersion();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object recoverUpdates(Object state) throws IOException {
        this.logBytes = 0L;
        this.logEntries = 0;
        if (this.version == 0) {
            return state;
        }
        String fname = this.versionName(logfilePrefix);
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(fname));
        DataInputStream dataIn = new DataInputStream(in);
        if (this.Debug) {
            System.err.println("log.debug: reading updates from " + fname);
        }
        try {
            this.majorFormatVersion = dataIn.readInt();
            this.logBytes += (long)intBytes;
            this.minorFormatVersion = dataIn.readInt();
            this.logBytes += (long)intBytes;
        }
        catch (EOFException e) {
            this.openLogFile(true);
            in = null;
        }
        if (this.majorFormatVersion != 0) {
            if (this.Debug) {
                System.err.println("log.debug: major version mismatch: " + this.majorFormatVersion + "." + this.minorFormatVersion);
            }
            throw new IOException("Log file " + this.logName + " has a " + "version " + this.majorFormatVersion + "." + this.minorFormatVersion + " format, and this implementation " + " understands only version " + 0 + "." + 2);
        }
        try {
            while (in != null) {
                int updateLen = 0;
                try {
                    updateLen = dataIn.readInt();
                }
                catch (EOFException e) {
                    if (this.Debug) {
                        System.err.println("log.debug: log was sync'd cleanly");
                    }
                    break;
                }
                if (updateLen <= 0) {
                    if (this.Debug) {
                        System.err.println("log.debug: last update incomplete, updateLen = 0x" + Integer.toHexString(updateLen));
                    }
                    break;
                }
                if (((InputStream)in).available() < updateLen) {
                    if (this.Debug) {
                        System.err.println("log.debug: log was truncated");
                    }
                    break;
                }
                if (this.Debug) {
                    System.err.println("log.debug: rdUpdate size " + updateLen);
                }
                try {
                    state = this.handler.readUpdate(new LogInputStream(in, updateLen), state);
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IOException("read update failed with exception: " + e);
                }
                this.logBytes += (long)(intBytes + updateLen);
                ++this.logEntries;
            }
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
        }
        if (this.Debug) {
            System.err.println("log.debug: recovered updates: " + this.logEntries);
        }
        this.openLogFile(false);
        if (this.log == null) {
            throw new IOException("rmid's log is inaccessible, it may have been corrupted or closed");
        }
        this.log.seek(this.logBytes);
        this.log.setLength(this.logBytes);
        return state;
    }

    public static class LogFile
    extends RandomAccessFile {
        private final FileDescriptor fd = this.getFD();

        public LogFile(String name, String mode) throws FileNotFoundException, IOException {
            super(name, mode);
        }

        protected void sync() throws IOException {
            this.fd.sync();
        }

        protected boolean checkSpansBoundary(long fp) {
            return fp % 512L > 508L;
        }
    }
}

