/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.server;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.rmi.MarshalException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.Operation;
import java.rmi.server.RemoteCall;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteRef;
import java.security.AccessController;
import sun.rmi.runtime.Log;
import sun.rmi.server.Util;
import sun.rmi.transport.Connection;
import sun.rmi.transport.LiveRef;
import sun.rmi.transport.StreamRemoteCall;
import sun.security.action.GetBooleanAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnicastRef
implements RemoteRef {
    public static final Log clientRefLog = Log.getLog("sun.rmi.client.ref", "transport", Util.logLevel);
    public static final Log clientCallLog = Log.getLog("sun.rmi.client.call", "RMI", AccessController.doPrivileged(new GetBooleanAction("sun.rmi.client.logCalls")));
    protected LiveRef ref;

    public UnicastRef() {
    }

    public UnicastRef(LiveRef liveRef) {
        this.ref = liveRef;
    }

    public LiveRef getLiveRef() {
        return this.ref;
    }

    /*
     * Exception decompiling
     */
    @Override
    public Object invoke(Remote obj, Method method, Object[] params, long opnum) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void marshalCustomCallData(ObjectOutput out) throws IOException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void marshalValue(Class<?> type, Object value, ObjectOutput out) throws IOException {
        if (type.isPrimitive()) {
            if (type == Integer.TYPE) {
                out.writeInt((Integer)value);
                return;
            } else if (type == Boolean.TYPE) {
                out.writeBoolean((Boolean)value);
                return;
            } else if (type == Byte.TYPE) {
                out.writeByte(((Byte)value).byteValue());
                return;
            } else if (type == Character.TYPE) {
                out.writeChar(((Character)value).charValue());
                return;
            } else if (type == Short.TYPE) {
                out.writeShort(((Short)value).shortValue());
                return;
            } else if (type == Long.TYPE) {
                out.writeLong((Long)value);
                return;
            } else if (type == Float.TYPE) {
                out.writeFloat(((Float)value).floatValue());
                return;
            } else {
                if (type != Double.TYPE) throw new Error("Unrecognized primitive type: " + type);
                out.writeDouble((Double)value);
            }
            return;
        } else {
            out.writeObject(value);
        }
    }

    protected static Object unmarshalValue(Class<?> type, ObjectInput in) throws IOException, ClassNotFoundException {
        if (type.isPrimitive()) {
            if (type == Integer.TYPE) {
                return in.readInt();
            }
            if (type == Boolean.TYPE) {
                return in.readBoolean();
            }
            if (type == Byte.TYPE) {
                return in.readByte();
            }
            if (type == Character.TYPE) {
                return Character.valueOf(in.readChar());
            }
            if (type == Short.TYPE) {
                return in.readShort();
            }
            if (type == Long.TYPE) {
                return in.readLong();
            }
            if (type == Float.TYPE) {
                return Float.valueOf(in.readFloat());
            }
            if (type == Double.TYPE) {
                return in.readDouble();
            }
            throw new Error("Unrecognized primitive type: " + type);
        }
        return in.readObject();
    }

    @Override
    public RemoteCall newCall(RemoteObject obj, Operation[] ops, int opnum, long hash) throws RemoteException {
        clientRefLog.log(Log.BRIEF, "get connection");
        Connection conn = this.ref.getChannel().newConnection();
        try {
            clientRefLog.log(Log.VERBOSE, "create call context");
            if (clientCallLog.isLoggable(Log.VERBOSE)) {
                this.logClientCall(obj, ops[opnum]);
            }
            StreamRemoteCall call = new StreamRemoteCall(conn, this.ref.getObjID(), opnum, hash);
            try {
                this.marshalCustomCallData(call.getOutputStream());
            }
            catch (IOException e) {
                throw new MarshalException("error marshaling custom call data");
            }
            return call;
        }
        catch (RemoteException e) {
            this.ref.getChannel().free(conn, false);
            throw e;
        }
    }

    @Override
    public void invoke(RemoteCall call) throws Exception {
        try {
            clientRefLog.log(Log.VERBOSE, "execute call");
            call.executeCall();
        }
        catch (RemoteException e) {
            clientRefLog.log(Log.BRIEF, "exception: ", e);
            this.free(call, false);
            throw e;
        }
        catch (Error e) {
            clientRefLog.log(Log.BRIEF, "error: ", e);
            this.free(call, false);
            throw e;
        }
        catch (RuntimeException e) {
            clientRefLog.log(Log.BRIEF, "exception: ", e);
            this.free(call, false);
            throw e;
        }
        catch (Exception e) {
            clientRefLog.log(Log.BRIEF, "exception: ", e);
            this.free(call, true);
            throw e;
        }
    }

    private void free(RemoteCall call, boolean reuse) throws RemoteException {
        Connection conn = ((StreamRemoteCall)call).getConnection();
        this.ref.getChannel().free(conn, reuse);
    }

    @Override
    public void done(RemoteCall call) throws RemoteException {
        clientRefLog.log(Log.BRIEF, "free connection (reuse = true)");
        this.free(call, true);
        try {
            call.done();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void logClientCall(Object obj, Object method) {
        clientCallLog.log(Log.VERBOSE, "outbound call: " + this.ref + " : " + obj.getClass().getName() + this.ref.getObjID().toString() + ": " + method);
    }

    @Override
    public String getRefClass(ObjectOutput out) {
        return "UnicastRef";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.ref.write(out, false);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.ref = LiveRef.read(in, false);
    }

    @Override
    public String remoteToString() {
        return Util.getUnqualifiedName(this.getClass()) + " [liveRef: " + this.ref + "]";
    }

    @Override
    public int remoteHashCode() {
        return this.ref.hashCode();
    }

    @Override
    public boolean remoteEquals(RemoteRef sub) {
        if (sub instanceof UnicastRef) {
            return this.ref.remoteEquals(((UnicastRef)sub).ref);
        }
        return false;
    }
}

