/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.server;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.MarshalException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.rmi.ServerException;
import java.rmi.UnmarshalException;
import java.rmi.server.ExportException;
import java.rmi.server.RemoteCall;
import java.rmi.server.RemoteRef;
import java.rmi.server.RemoteStub;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.ServerRef;
import java.rmi.server.Skeleton;
import java.rmi.server.SkeletonNotFoundException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import sun.rmi.runtime.Log;
import sun.rmi.server.Dispatcher;
import sun.rmi.server.MarshalInputStream;
import sun.rmi.server.UnicastRef;
import sun.rmi.server.Util;
import sun.rmi.server.WeakClassHashMap;
import sun.rmi.transport.LiveRef;
import sun.rmi.transport.Target;
import sun.rmi.transport.tcp.TCPTransport;
import sun.security.action.GetBooleanAction;

public class UnicastServerRef
extends UnicastRef
implements ServerRef,
Dispatcher {
    public static final boolean logCalls = AccessController.doPrivileged(new GetBooleanAction("java.rmi.server.logCalls"));
    public static final Log callLog = Log.getLog("sun.rmi.server.call", "RMI", logCalls);
    private static final long serialVersionUID = -7384275867073752268L;
    private static final boolean wantExceptionLog = AccessController.doPrivileged(new GetBooleanAction("sun.rmi.server.exceptionTrace"));
    private boolean forceStubUse = false;
    private static final boolean suppressStackTraces = AccessController.doPrivileged(new GetBooleanAction("sun.rmi.server.suppressStackTraces"));
    private transient Skeleton skel;
    private transient Map<Long, Method> hashToMethod_Map = null;
    private static final WeakClassHashMap<Map<Long, Method>> hashToMethod_Maps = new HashToMethod_Maps();
    private static final Map<Class<?>, ?> withoutSkeletons = Collections.synchronizedMap(new WeakHashMap());

    public UnicastServerRef() {
    }

    public UnicastServerRef(LiveRef ref) {
        super(ref);
    }

    public UnicastServerRef(int port) {
        super(new LiveRef(port));
    }

    public UnicastServerRef(boolean forceStubUse) {
        this(0);
        this.forceStubUse = forceStubUse;
    }

    public RemoteStub exportObject(Remote impl, Object data) throws RemoteException {
        this.forceStubUse = true;
        return (RemoteStub)this.exportObject(impl, data, false);
    }

    public Remote exportObject(Remote impl, Object data, boolean permanent) throws RemoteException {
        Remote stub;
        Class<?> implClass = impl.getClass();
        try {
            stub = Util.createProxy(implClass, this.getClientRef(), this.forceStubUse);
        }
        catch (IllegalArgumentException e) {
            throw new ExportException("remote object implements illegal remote interface", e);
        }
        if (stub instanceof RemoteStub) {
            this.setSkeleton(impl);
        }
        Target target = new Target(impl, this, stub, this.ref.getObjID(), permanent);
        this.ref.exportObject(target);
        this.hashToMethod_Map = hashToMethod_Maps.get(implClass);
        return stub;
    }

    public String getClientHost() throws ServerNotActiveException {
        return TCPTransport.getClientHost();
    }

    public void setSkeleton(Remote impl) throws RemoteException {
        if (!withoutSkeletons.containsKey(impl.getClass())) {
            try {
                this.skel = Util.createSkeleton(impl);
            }
            catch (SkeletonNotFoundException e) {
                withoutSkeletons.put(impl.getClass(), null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void dispatch(Remote obj, RemoteCall call) throws IOException {
        try {
            in = call.getInputStream();
            num = in.readInt();
            if (num < 0) ** GOTO lbl10
            if (this.skel != null) {
                this.oldDispatch(obj, call, num);
                return;
            }
            try {
                throw new UnmarshalException("skeleton class not found but required for client version");
lbl10:
                // 1 sources

                op = in.readLong();
            }
            catch (Exception readEx) {
                throw new UnmarshalException("error unmarshalling call header", readEx);
            }
            marshalStream = (MarshalInputStream)in;
            marshalStream.skipDefaultResolveClass();
            method = this.hashToMethod_Map.get(op);
            if (method == null) {
                throw new UnmarshalException("unrecognized method hash: method not supported by remote object");
            }
            this.logCall(obj, method);
            types = method.getParameterTypes();
            params = new Object[types.length];
            try {
                this.unmarshalCustomCallData(in);
                for (i = 0; i < types.length; ++i) {
                    params[i] = UnicastServerRef.unmarshalValue(types[i], in);
                }
            }
            catch (IOException e) {
                throw new UnmarshalException("error unmarshalling arguments", e);
            }
            catch (ClassNotFoundException e) {
                throw new UnmarshalException("error unmarshalling arguments", e);
            }
            finally {
                call.releaseInputStream();
            }
            try {
                result = method.invoke(obj, params);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
            try {
                out = call.getResultStream(true);
                rtype = method.getReturnType();
                if (rtype != Void.TYPE) {
                    UnicastServerRef.marshalValue(rtype, result, out);
                }
            }
            catch (IOException ex) {
                throw new MarshalException("error marshalling return", ex);
            }
        }
        catch (Throwable e) {
            this.logCallException(e);
            out = call.getResultStream(false);
            if (e instanceof Error) {
                e /* !! */  = new ServerError("Error occurred in server thread", (Error)e);
            } else if (e instanceof RemoteException) {
                e /* !! */  = new ServerException("RemoteException occurred in server thread", (Exception)e);
            }
            if (UnicastServerRef.suppressStackTraces) {
                UnicastServerRef.clearStackTraces(e /* !! */ );
            }
            out.writeObject(e /* !! */ );
        }
        finally {
            call.releaseInputStream();
            call.releaseOutputStream();
        }
    }

    protected void unmarshalCustomCallData(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void oldDispatch(Remote obj, RemoteCall call, int op) throws IOException {
        try {
            long hash;
            ObjectInput in;
            try {
                in = call.getInputStream();
                try {
                    Class<?> clazz = Class.forName("sun.rmi.transport.DGCImpl_Skel");
                    if (clazz.isAssignableFrom(this.skel.getClass())) {
                        ((MarshalInputStream)in).useCodebaseOnly();
                    }
                }
                catch (ClassNotFoundException ignore) {
                    // empty catch block
                }
                hash = in.readLong();
            }
            catch (Exception readEx) {
                throw new UnmarshalException("error unmarshalling call header", readEx);
            }
            this.logCall(obj, this.skel.getOperations()[op]);
            this.unmarshalCustomCallData(in);
            this.skel.dispatch(obj, call, op, hash);
        }
        catch (Throwable e2) {
            RemoteException e2;
            this.logCallException(e2);
            ObjectOutput out = call.getResultStream(false);
            if (e2 instanceof Error) {
                e2 = new ServerError("Error occurred in server thread", (Error)e2);
            } else if (e2 instanceof RemoteException) {
                e2 = new ServerException("RemoteException occurred in server thread", (Exception)e2);
            }
            if (suppressStackTraces) {
                UnicastServerRef.clearStackTraces(e2);
            }
            out.writeObject(e2);
        }
        finally {
            call.releaseInputStream();
            call.releaseOutputStream();
        }
    }

    public static void clearStackTraces(Throwable t) {
        StackTraceElement[] empty = new StackTraceElement[]{};
        while (t != null) {
            t.setStackTrace(empty);
            t = t.getCause();
        }
    }

    private void logCall(Remote obj, Object method) {
        if (callLog.isLoggable(Log.VERBOSE)) {
            String clientHost;
            try {
                clientHost = this.getClientHost();
            }
            catch (ServerNotActiveException snae) {
                clientHost = "(local)";
            }
            callLog.log(Log.VERBOSE, "[" + clientHost + ": " + obj.getClass().getName() + this.ref.getObjID().toString() + ": " + method + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logCallException(Throwable e) {
        if (callLog.isLoggable(Log.BRIEF)) {
            String clientHost = "";
            try {
                clientHost = "[" + this.getClientHost() + "] ";
            }
            catch (ServerNotActiveException serverNotActiveException) {
                // empty catch block
            }
            callLog.log(Log.BRIEF, clientHost + "exception: ", e);
        }
        if (wantExceptionLog) {
            PrintStream log;
            PrintStream printStream = log = System.err;
            synchronized (printStream) {
                log.println();
                log.println("Exception dispatching call to " + this.ref.getObjID() + " in thread \"" + Thread.currentThread().getName() + "\" at " + new Date() + ":");
                e.printStackTrace(log);
            }
        }
    }

    public String getRefClass(ObjectOutput out) {
        return "UnicastServerRef";
    }

    protected RemoteRef getClientRef() {
        return new UnicastRef(this.ref);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.ref = null;
        this.skel = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HashToMethod_Maps
    extends WeakClassHashMap<Map<Long, Method>> {
        HashToMethod_Maps() {
        }

        @Override
        protected Map<Long, Method> computeValue(Class<?> remoteClass) {
            HashMap<Long, Method> map = new HashMap<Long, Method>();
            for (Class<?> cl = remoteClass; cl != null; cl = cl.getSuperclass()) {
                for (Class<?> intf : cl.getInterfaces()) {
                    if (!Remote.class.isAssignableFrom(intf)) continue;
                    Method[] arr$ = intf.getMethods();
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        Method method;
                        final Method m = method = arr$[i$];
                        AccessController.doPrivileged(new PrivilegedAction<Void>(){

                            @Override
                            public Void run() {
                                m.setAccessible(true);
                                return null;
                            }
                        });
                        map.put(Util.computeMethodHash(m), m);
                    }
                }
            }
            return map;
        }
    }
}

