/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sun.rmi.runtime.Log;
import sun.rmi.server.MarshalInputStream;
import sun.rmi.transport.Channel;
import sun.rmi.transport.Connection;
import sun.rmi.transport.DGCClient;
import sun.rmi.transport.DGCImpl;
import sun.rmi.transport.Endpoint;
import sun.rmi.transport.LiveRef;

class ConnectionInputStream
extends MarshalInputStream {
    private boolean dgcAckNeeded = false;
    private Map incomingRefTable = new HashMap(5);
    private UID ackID;

    ConnectionInputStream(InputStream in) throws IOException {
        super(in);
    }

    void readID() throws IOException {
        this.ackID = UID.read(this);
    }

    void saveRef(LiveRef ref) {
        Endpoint ep = ref.getEndpoint();
        ArrayList<LiveRef> refList = (ArrayList<LiveRef>)this.incomingRefTable.get(ep);
        if (refList == null) {
            refList = new ArrayList<LiveRef>();
            this.incomingRefTable.put(ep, refList);
        }
        refList.add(ref);
    }

    void registerRefs() throws IOException {
        if (!this.incomingRefTable.isEmpty()) {
            Set entrySet = this.incomingRefTable.entrySet();
            for (Map.Entry entry : entrySet) {
                Endpoint ep = (Endpoint)entry.getKey();
                List refList = (List)entry.getValue();
                DGCClient.registerRefs(ep, refList);
            }
        }
    }

    void setAckNeeded() {
        this.dgcAckNeeded = true;
    }

    void done(Connection c) {
        if (this.dgcAckNeeded) {
            Connection conn = null;
            Channel ch = null;
            boolean reuse = true;
            DGCImpl.dgcLog.log(Log.VERBOSE, "send ack");
            try {
                ch = c.getChannel();
                conn = ch.newConnection();
                DataOutputStream out = new DataOutputStream(conn.getOutputStream());
                out.writeByte(84);
                if (this.ackID == null) {
                    this.ackID = new UID();
                }
                this.ackID.write(out);
                conn.releaseOutputStream();
                conn.getInputStream().available();
                conn.releaseInputStream();
            }
            catch (RemoteException e) {
                reuse = false;
            }
            catch (IOException e) {
                reuse = false;
            }
            try {
                if (conn != null) {
                    ch.free(conn, reuse);
                }
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
    }
}

