/*
 * Decompiled with CFR 0.152.
 */
package sun.security.acl;

import java.security.Principal;
import java.security.acl.AclEntry;
import java.security.acl.Group;
import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AclEntryImpl
implements AclEntry {
    private Principal user = null;
    private Vector<Permission> permissionSet = new Vector(10, 10);
    private boolean negative = false;

    public AclEntryImpl(Principal user) {
        this.user = user;
    }

    public AclEntryImpl() {
    }

    @Override
    public boolean setPrincipal(Principal user) {
        if (this.user != null) {
            return false;
        }
        this.user = user;
        return true;
    }

    @Override
    public void setNegativePermissions() {
        this.negative = true;
    }

    @Override
    public boolean isNegative() {
        return this.negative;
    }

    @Override
    public boolean addPermission(Permission permission) {
        if (this.permissionSet.contains(permission)) {
            return false;
        }
        this.permissionSet.addElement(permission);
        return true;
    }

    @Override
    public boolean removePermission(Permission permission) {
        return this.permissionSet.removeElement(permission);
    }

    @Override
    public boolean checkPermission(Permission permission) {
        return this.permissionSet.contains(permission);
    }

    @Override
    public Enumeration<Permission> permissions() {
        return this.permissionSet.elements();
    }

    @Override
    public String toString() {
        StringBuffer s = new StringBuffer();
        if (this.negative) {
            s.append("-");
        } else {
            s.append("+");
        }
        if (this.user instanceof Group) {
            s.append("Group.");
        } else {
            s.append("User.");
        }
        s.append(this.user + "=");
        Enumeration<Permission> e = this.permissions();
        while (e.hasMoreElements()) {
            Permission p = e.nextElement();
            s.append(p);
            if (!e.hasMoreElements()) continue;
            s.append(",");
        }
        return new String(s);
    }

    @Override
    public synchronized Object clone() {
        AclEntryImpl cloned = new AclEntryImpl(this.user);
        cloned.permissionSet = (Vector)this.permissionSet.clone();
        cloned.negative = this.negative;
        return cloned;
    }

    @Override
    public Principal getPrincipal() {
        return this.user;
    }
}

